# Código de Conducta Convenido para Contribuyentes

## Nuestro compromiso

Nosotros, como miembros, contribuyentes y administradores nos comprometemos a hacer de la participación en nuestra comunidad una experiencia libre de acoso para todo el mundo, independientemente de la edad, dimensión corporal, minusvalía visible o invisible, etnicidad, características sexuales, identidad y expresión de género, nivel de experiencia, educación, nivel socio-económico, nacionalidad, apariencia personal, raza, religión, o identidad u orientación sexual.

Nos comprometemos a actuar e interactuar de maneras que contribuyan a una comunidad abierta, acogedora, diversa, inclusiva y sana.

## Nuestros estándares

Ejemplos de comportamiento que contribuyen a crear un ambiente positivo para nuestra comunidad:

* Demostrar empatía y amabilidad ante otras personas
* Respeto a diferentes opiniones, puntos de vista y experiencias
* Dar y aceptar adecuadamente retroalimentación constructiva
* Aceptar la responsabilidad y disculparse ante quienes se vean afectados por nuestros errores, aprendiendo de la experiencia
* Centrarse en lo que sea mejor no sólo para nosotros como individuos, sino para la comunidad en general

Ejemplos de comportamiento inaceptable:

* El uso de lenguaje o imágenes sexualizadas, y aproximaciones o
  atenciones sexuales de cualquier tipo
* Comentarios despectivos (_trolling_), insultantes o derogatorios, y ataques personales o políticos
* El acoso en público o privado
* Publicar información privada de otras personas, tales como direcciones físicas o de correo
  electrónico, sin su permiso explícito
* Otras conductas que puedan ser razonablemente consideradas como inapropiadas en un
  entorno profesional

## Aplicación de las responsabilidades

Los administradores de la comunidad son responsables de aclarar y hacer cumplir nuestros estándares de comportamiento aceptable y tomarán acciones apropiadas y correctivas de forma justa en respuesta a cualquier comportamiento que consideren inapropiado, amenazante, ofensivo o dañino.

Los administradores de la comunidad tendrán el derecho y la responsabilidad de eliminar, editar o rechazar comentarios, _commits_, código, ediciones de páginas de wiki, _issues_ y otras contribuciones que no se alineen con este Código de Conducta, y comunicarán las razones para sus decisiones de moderación cuando sea apropiado.

## Alcance

Este código de conducta aplica tanto a espacios del proyecto como a espacios públicos donde un individuo esté en representación del proyecto o comunidad. Ejemplos de esto incluyen el uso de la cuenta oficial de correo electrónico, publicaciones a través de las redes sociales oficiales, o presentaciones con personas designadas en eventos en línea o no.

## Aplicación

Instancias de comportamiento abusivo, acosador o inaceptable de otro modo podrán ser reportadas a los administradores de la comunidad responsables del cumplimiento a través de [coc@phpcfdi.com](). Todas las quejas serán evaluadas e investigadas de una manera puntual y justa.

Todos los administradores de la comunidad están obligados a respetar la privacidad y la seguridad de quienes reporten incidentes.

## Guías de Aplicación

Los administradores de la comunidad seguirán estas Guías de Impacto en la Comunidad para determinar las consecuencias de cualquier acción que juzguen como un incumplimiento de este Código de Conducta:

### 1. Corrección

**Impacto en la Comunidad**: El uso de lenguaje inapropiado u otro comportamiento considerado no profesional o no acogedor en la comunidad.

**Consecuencia**: Un aviso escrito y privado por parte de los administradores de la comunidad, proporcionando claridad alrededor de la naturaleza de este incumplimiento y una explicación de por qué el comportamiento es inaceptable. Una disculpa pública podría ser solicitada.

### 2. Aviso

**Impacto en la Comunidad**: Un incumplimiento causado por un único incidente o por una cadena de acciones.

**Consecuencia**: Un aviso con consecuencias por comportamiento prolongado. No se interactúa con las personas involucradas, incluyendo interacción no solicitada con quienes se encuentran aplicando el Código de Conducta, por un periodo especificado de tiempo. Esto incluye evitar las interacciones en espacios de la comunidad, así como a través de canales externos como las redes sociales. Incumplir estos términos puede conducir a una expulsión temporal o permanente.

### 3. Expulsión temporal

**Impacto en la Comunidad**: Una serie de incumplimientos de los estándares de la comunidad, incluyendo comportamiento inapropiado continuo.

**Consecuencia**: Una expulsión temporal de cualquier forma de interacción o comunicación pública con la comunidad durante un intervalo de tiempo especificado. No se permite interactuar de manera pública o privada con las personas involucradas, incluyendo interacciones no solicitadas con quienes se encuentran aplicando el Código de Conducta, durante este periodo. Incumplir estos términos puede conducir a una expulsión permanente.

### 4. Expulsión permanente

**Impacto en la Comunidad**: Demostrar un patrón sistemático de incumplimientos de los estándares de la comunidad, incluyendo conductas inapropiadas prolongadas en el tiempo, acoso de individuos, o agresiones o menosprecio a grupos de individuos.

**Consecuencia**: Una expulsión permanente de cualquier tipo de interacción pública con la comunidad del proyecto.

## Atribución

Este Código de Conducta es una adaptación del [Contributor Covenant][homepage], versión 2.0,
disponible en https://www.contributor-covenant.org/es/version/2/0/code_of_conduct.html

Las Guías de Impacto en la Comunidad están inspiradas en la [escalera de aplicación del código de conducta de Mozilla](https://github.com/mozilla/diversity).

[homepage]: https://www.contributor-covenant.org

Para respuestas a las preguntas frecuentes de este código de conducta, consulta las FAQ en
https://www.contributor-covenant.org/faq. Hay traducciones disponibles en https://www.contributor-covenant.org/translations
