<?php

namespace App\Http\Controllers;

use App\Models\Productos;
use Illuminate\Http\Request;
use App\Models\Calificaciones;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;

use Illuminate\Support\Carbon;
class CalificacionesController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    public function index()
    {
        $carts = session()->get('cart', []);
        $cart = array_slice($carts, 0, 4);
        $favoritos = session()->get('favoritos', []);
        $favoritos = array_slice($favoritos, 0, 4);
        if($cart){ $totalProducts = count($cart); }else{ $totalProducts = ""; }
        if($favoritos){ $totalFavoritos = count($favoritos); }else{ $totalFavoritos = ""; }
        $datos = Calificaciones::select('codigo_calif', 'codigo_prod', 'name', 'email', 'nombre_prod', 'calificacion_calif', 'resena_calif', 'fecha_calif', 'estatus_calif')
        ->join('users', 'users.id', '=', 'usuario_calif')->join('productos', 'productos.id', '=', 'producto_calif')
        ->where('estatus_calif', '<>', 'Eliminado')->orderBy('calificaciones.id', 'desc')->get();
        return view('calificaciones/index', compact('datos', 'totalProducts', 'cart', 'totalFavoritos', 'favoritos'));
    }
    public function store($id, Request $request)
    {
        $rules = [
            'rating' => 'required|numeric',
            'mensaje' => 'required|string'
        ];
        $messages = [
            'rating.numeric' => 'La calificación contiene caracteres desconocidos.',
            'rating.required' => 'La calificación es obligatoria.',
            'mensaje.string' => 'El mensaje contiene caracteres desconocidos.',
            'mensaje.required' => 'El mensaje es obligatorio.',
		];
        $validator = Validator::make($request->all(), $rules, $messages);
        if ($validator->fails()) { $errors = $validator->errors()->all(); return redirect()->back()->with('danger', implode(', ', $errors));}
        $sanitizedData = $validator->validated();
        $rating = $sanitizedData['rating'];
        $mensaje = $sanitizedData['mensaje'];
        $producto = Productos::where('codigo_prod', '=', $id)->first();
        $permitted_chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $codigo = "PRCO" . substr(str_shuffle($permitted_chars), 0, 16);
        $datos = new Calificaciones();
        $datos->codigo_calif = $codigo;
        $datos->usuario_calif = Auth::user()->id;
        $datos->producto_calif = $producto->id;
        $datos->calificacion_calif = $rating;
        $datos->resena_calif = $mensaje;
        $datos->fecha_calif = Carbon::now('America/Mexico_City');;
        $datos->estatus_calif = 'Pendiente por aprobar';
        $datos->save();
        return redirect()->back()->with('success', '¡Reseña agregada correctamente, gracias por calificar el producto!');
    }
    public function aprobar(Request $request, $id)
    {
        $datos = Calificaciones::where('codigo_calif', $id)->first();
        $datos->estatus_calif = 'Aprobado';
        $datos->save();
        return redirect()->back()->with('success', '¡Aprobado existosamente!');
    }
    public function pendiente(Request $request, $id)
    {
        $datos = Calificaciones::where('codigo_calif', $id)->first();
        $datos->estatus_calif = 'Pendiente por aprobar';
        $datos->save();
        return redirect()->back()->with('success', '¡En espera de ser aprobado!');
    }
    public function delete(Request $request, $id)
    {
        $datos = Calificaciones::where('codigo_calif', $id)->first();
        $datos->estatus_calif = 'Eliminado';
        $datos->save();
        return redirect()->back()->with('success', '¡Eliminado existosamente!');
    }

}
