<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Clientes;
use Illuminate\Http\Request;
use App\Models\Estados_republica;
use Illuminate\Support\Facades\Crypt;

use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;

class ClientesController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    public function index()
    {
        $carts = session()->get('cart', []);
        $cart = array_slice($carts, 0, 4);
        $favoritos = session()->get('favoritos', []);
        $favoritos = array_slice($favoritos, 0, 4);
        if($cart){ $totalProducts = count($cart); }else{ $totalProducts = ""; }
        if($favoritos){ $totalFavoritos = count($favoritos); }else{ $totalFavoritos = ""; }
        $datos = Clientes::select('codigo_clie', 'telefono_clie', 'pais_clie','ciudad_clie', 'estado_clie', 'direccion_clie', 'codigo_postal_clie', 'nombre_facturacion_clie', 'rfc_facturacion_clie',
        'uso_facturacion_clie', 'regimen_facturacion_clie', 'constancia_facturacion_clie', 'codigo_postal_facturacion_clie', 'name as nombre_cliente', 'email', 'estadoCliente.nombre_edo as nombreEstado' )
        ->join('users', 'users.id', '=', 'clientes.usuario_clie' )->leftjoin('estados_republica as estadoCliente', 'estadoCliente.id', '=', 'clientes.estado_clie' )->where('estatus_clie', '=', 'Activo')->get();
        return view('clientes/index', compact('datos', 'totalProducts', 'cart', 'totalFavoritos', 'favoritos'));
    }
    public function cliente($id)
    {
        $carts = session()->get('cart', []);
        $cart = array_slice($carts, 0, 4);
        $favoritos = session()->get('favoritos', []);
        $favoritos = array_slice($favoritos, 0, 4);
        if($cart){ $totalProducts = count($cart); }else{ $totalProducts = ""; }
        if($favoritos){ $totalFavoritos = count($favoritos); }else{ $totalFavoritos = ""; }
        $id = Crypt::decrypt($id);
        $datos = Clientes::select('codigo_clie', 'telefono_clie', 'pais_clie', 'ciudad_clie', 'estado_clie', 'direccion_clie', 'referencia_clie', 'codigo_postal_clie', 'nombre_facturacion_clie', 'rfc_facturacion_clie',
        'uso_facturacion_clie', 'regimen_facturacion_clie', 'constancia_facturacion_clie', 'codigo_postal_facturacion_clie', 'name as nombre_cliente', 'email', 'estadoCliente.nombre_edo as nombreEstado' )
        ->join('users', 'users.id', '=', 'clientes.usuario_clie' )->leftjoin('estados_republica as estadoCliente', 'estadoCliente.id', '=', 'clientes.estado_clie' )->where('email', '=', $id)->first();
        $estadosRepublica = Estados_republica::get();
        return view('clientes.datos', compact('totalProducts', 'cart', 'datos', 'estadosRepublica', 'totalFavoritos', 'favoritos'));
    }
    public function update(Request $request, Clientes $clientes, $id)
    {
        $rules = [
            'nombre' => 'nullable|string',
            'telefono' => 'nullable|string',
            'direccion' => 'nullable|string',
            'referencia' => 'nullable|string',
            'pais' => 'nullable|string',
            'ciudad' => 'nullable|string',
            'estado' => 'nullable|string',
            'cp' => 'nullable|integer',
            'nombre_fact' => 'nullable|string',
            'rfc_fact' => 'nullable|string',
            'uso_fact' => 'nullable|string',
            'regimen_fact' => 'nullable|string',
            'cp_fact' => 'nullable|string',
            'archivo' => 'nullable|mimes:pdf',
        ];
        $validator = Validator::make($request->all(), $rules);
        if ($validator->fails()) { $errors = $validator->errors()->all(); return redirect()->back()->with('danger', implode(', ', $errors));}
        $sanitizedData = $validator->validated();
        $nombre = $sanitizedData['nombre'];
        $telefono = $sanitizedData['telefono'];
        $direccion = $sanitizedData['direccion'];
        $referencia = $sanitizedData['referencia'];
        $pais = $sanitizedData['pais'];
        $ciudad = $sanitizedData['ciudad'];
        $estado = $sanitizedData['estado'];
        $cp = $sanitizedData['cp'];
        $nombre_fact = $sanitizedData['nombre_fact'];
        $rfc_fact = $sanitizedData['rfc_fact'];
        $uso_fact = $sanitizedData['uso_fact'];
        $regimen_fact = $sanitizedData['regimen_fact'];
        $cp_fact = $sanitizedData['cp_fact'];
        $datos = clientes::where('codigo_clie', $id)->first();
        $datos->telefono_clie = $telefono;
        $datos->pais_clie = $pais;
        $datos->ciudad_clie = $ciudad;
        $datos->estado_clie = $estado;
        $datos->direccion_clie = $direccion;
        $datos->referencia_clie = $referencia;
        $datos->codigo_postal_clie = $cp;
        $datos->nombre_facturacion_clie = $nombre_fact;
        $datos->rfc_facturacion_clie = $rfc_fact;
        $datos->uso_facturacion_clie = $uso_fact;
        $datos->regimen_facturacion_clie = $regimen_fact;
        $datos->codigo_postal_facturacion_clie = $cp_fact;
        if ($request->hasFile('archivo')) { $archivo = $request->file('archivo')->store('public/documentos/constancias'); $datos->constancia_facturacion_clie = $archivo;}
        $datos->save();
        $usuario = User::where('id', $datos->usuario_clie)->first();
        $usuario->name = $nombre;
        $usuario->save();
        return redirect()->back()->with('success', '¡Actualizado existosamente!');
    }
    public function descargarDocumento(Request $request, $id)
    {
        $datos = clientes::where('codigo_clie', '=', $id)->first();
        $url = $datos->constancia_facturacion_clie;
        return Storage::download($url);
    }
}
