<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Compras;
use App\Models\Pedidos;
use Illuminate\Http\Request;
use App\Mail\envioCambioEstatus;
use App\Models\Pagos_comprobantes;
use Spatie\Permission\Models\Role;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;
use Barryvdh\DomPDF\Facade\Pdf as FacadePdf;
use App\Models\Datos_empresas;
class ComprasController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    public function pedidos()
    {
        $carts = session()->get('cart', []);
        $cart = array_slice($carts, 0, 4);
        $favoritos = session()->get('favoritos', []);
        $favoritos = array_slice($favoritos, 0, 4);
        if($cart){ $totalProducts = count($cart); }else{ $totalProducts = ""; }
        if($favoritos){ $totalFavoritos = count($favoritos); }else{ $totalFavoritos = ""; }
        $usuario = User::where('id', '=', Auth::user()->id)->first();
        if ($usuario->hasRole('Administrador')){
            $datos = Compras::select('payment_id_paco', 'requiereFact', 'codigo_comp', 'cod_pago_paco', 'codigo_paco', 'numero_pago', 'nombre_comp',
            'telefono_comp', 'email_comp', 'sub_total_comp', 'descuento_comp', 'envio_comp', 'total_comp', 'estatus_paco')
            ->join('pagos_comprobantes', 'pagos_comprobantes.cod_pago_paco','=', 'compras.codigo_comp')->orderBy('pagos_comprobantes.id', 'asc')->get();
        }
        if ($usuario->hasRole('Cliente')){
            $datos = Compras::select('payment_id_paco', 'requiereFact', 'codigo_comp', 'cod_pago_paco', 'codigo_paco', 'numero_pago', 'nombre_comp',
            'telefono_comp', 'email_comp', 'sub_total_comp', 'descuento_comp', 'envio_comp', 'total_comp', 'estatus_paco')
            ->join('pagos_comprobantes', 'pagos_comprobantes.cod_pago_paco','=', 'compras.codigo_comp')->orderBy('pagos_comprobantes.id', 'asc')->where('usuario_comp', Auth::user()->id)->get();
        }
        return view('pedidos/index', compact('datos', 'totalProducts', 'totalFavoritos', 'cart', 'favoritos'));
    }
    public function ventas()
    {
        $carts = session()->get('cart', []);
        $cart = array_slice($carts, 0, 4);
        $favoritos = session()->get('favoritos', []);
        $favoritos = array_slice($favoritos, 0, 4);
        if($cart){ $totalProducts = count($cart); }else{ $totalProducts = ""; }
        if($favoritos){ $totalFavoritos = count($favoritos); }else{ $totalFavoritos = ""; }
        $datos = Compras::select('payment_id_paco', 'requiereFact', 'codigo_comp', 'cod_pago_paco', 'codigo_paco', 'numero_pago', 'nombre_comp',
        'telefono_comp', 'email_comp', 'sub_total_comp', 'descuento_comp', 'envio_comp', 'total_comp', 'estatus_paco')
        ->join('pagos_comprobantes', 'pagos_comprobantes.pago_paco','=', 'compras.id')->where('estatus_paco', '=', 'Entregado')->get();
        return view('ventas/index', compact('datos', 'totalProducts', 'totalFavoritos', 'cart', 'favoritos'));
    }
    public function update($estatus, $id)
    {
        $comprobante = Pagos_comprobantes::select('nombre_comp', 'numero_pago', 'email_comp')->join('compras', 'compras.codigo_comp', '=', 'pagos_comprobantes.cod_pago_paco')->where('codigo_paco','=',$id)->first();
        $empresas = Datos_empresas::first();
        $nombre = $comprobante->nombre_comp;
        $numero = $comprobante->numero_pago;
        $email = $comprobante->email_comp;
        $empresa = $empresas->empresa_config;
        $logo = $empresas->logo_config;
        if($estatus == "Enviado" || $estatus == "Entregado"){
            $correo = new envioCambioEstatus( $empresa, $logo, $nombre, $numero, $estatus);
            Mail::to($email)->send($correo);
            $datos = Pagos_comprobantes::where('codigo_paco','=',$id)->first();
            $datos->estatus_paco = $estatus;
            $datos->save();
        }
        return redirect()->back()->with('success', '¡Actualizado existosamente!');
    }
    public function downloadPDFOC($id)
    {
        $empresas = Datos_empresas::first();
        $comprobantes = Pagos_comprobantes::where('cod_pago_paco', $id)->first();
        $compra = Compras::select('compras.id as idPago', 'codigo_comp', 'numero_pago', 'nombre_comp', 'telefono_comp'
        ,'email_comp', 'pais_comp', 'ciudad_comp', 'direccion_comp', 'edo.nombre_edo as nomEdo', 'cp_comp', 'addDirecciones_comp'
        ,'pais_dire', 'ciudad_dire', 'edoDire.nombre_edo as nomEdo_dire', 'direccion_dire', 'codigo_postal_dire'
        ,'requiereFact', 'nombre_fact_comp', 'rfc_fact_comp', 'uso_fact_comp', 'email_fact_comp', 'regime_fact_comp'
        ,'cp_fact_comp', 'sub_total_comp', 'codigo_cupo', 'descuento_comp', 'envio_comp', 'total_comp')
        ->leftjoin('cupones', 'cupones.id', '=', 'compras.cupon_comp')
        ->leftjoin('direcciones', 'direcciones.id', '=', 'compras.direccionSeleccionada')
        ->leftjoin('estados_republica as edoDire', 'edoDire.id', '=', 'direcciones.estado_dire')
        ->leftjoin('estados_republica as edo', 'edo.id', '=', 'compras.estado_comp')
        ->join('pagos_comprobantes', 'pagos_comprobantes.cod_pago_paco','=', 'compras.codigo_comp')
        ->where('codigo_comp', $id)->first();
        $productos = Pedidos::select('nombreProduct_pedi','producto_pedi', 'descripcion_pedi', 'costoProduct_pedi','cantidad_pedi','total_pedi','colorHtml_pedi')
        ->join('compras', 'compras.id', '=', 'pedidos.compra_pedi')
        ->where('compra_pedi', $compra->idPago)->get();
        $ultimaSolicitud  = $compra->numero_pago;
        $pdf = FacadePdf::loadView('tienda/comprobante_pago', compact('compra','productos', 'empresas', 'ultimaSolicitud'));
        $pdf->getDomPDF()->setHttpContext(stream_context_create(['ssl' => ['allow_self_signed'=> TRUE,'verify_peer' => FALSE,'verify_peer_name' => FALSE ]]));
        return $pdf->setPaper('a4', 'portrait')->download('OC-'.$comprobantes->payment_id_paco.'.pdf');
        //return $pdf->setPaper('a4', 'portrait')->stream('documento.pdf');
    }
}
