<?php

namespace App\Http\Controllers;

use App\Models\Cupones;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class CuponesController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    public function index()
    {
        $carts = session()->get('cart', []);
        $cart = array_slice($carts, 0, 4);
        $favoritos = session()->get('favoritos', []);
        $favoritos = array_slice($favoritos, 0, 4);
        if($cart){ $totalProducts = count($cart); }else{ $totalProducts = ""; }
        if($favoritos){ $totalFavoritos = count($favoritos); }else{ $totalFavoritos = ""; }
        $datos = Cupones::where('estatus_cupo', '<>', 'Eliminado')->get();
        return view('cupones/index', compact('datos', 'totalProducts', 'cart' , 'favoritos', 'totalFavoritos'));
    }
    public function store(Request $request)
    {
        $caracteres = Array("$",",");
        $cantidad = str_replace($caracteres,"",$_POST['cantidad']);
        $permitted_chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $token = "" . substr(str_shuffle($permitted_chars), 0, 5);
        $datos = new Cupones();
        $datos->codigo_cupo = $token;
        $datos->fecha_inicio_cupo = $request->post('fecha_inicio');
        $datos->fecha_vencimiento_cupo = $request->post('fecha_fin');
        $datos->descuento_cupo = $cantidad;
        $datos->tipo_cupo = $request->post('tipo');
        $datos->estatus_cupo = 'Activo';
        $datos->save();
        return redirect()->back()->with('success', '¡Registrado existosamente!');
    }
    public function update(Request $request, Cupones $cupones, $id)
    {
        $datos = Cupones::where('codigo_cupo', $id)->first();
        $datos->nombre_cupo = $request->post('nombre');
        $datos->save();
        return redirect()->back()->with('success', '¡Actualizado existosamente!');
    }
    public function activate(Request $request, $id)
    {
        $datos = Cupones::where('codigo_cupo', $id)->first();
        $datos->estatus_cupo = 'Activo';
        $datos->save();
        return redirect()->back()->with('success', '¡Activado existosamente!');
    }
    public function inactivate(Request $request, $id)
    {
        $datos = Cupones::where('codigo_cupo', $id)->first();
        $datos->estatus_cupo = 'Inactivo';
        $datos->save();
        return redirect()->back()->with('success', '¡Inactivado existosamente!');
    }
    public function delete(Request $request, $id)
    {
        $datos = Cupones::where('codigo_cupo', $id)->first();
        $datos->estatus_cupo = 'Eliminado';
        $datos->save();
        return redirect()->back()->with('success', '¡Eliminado existosamente!');
    }
}
