<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Banners;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Models\Datos_empresas;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Http;

class DatosEmpresasController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    public function index()
    {
        $carts = session()->get('cart', []);
        $cart = array_slice($carts, 0, 4);
        $favoritos = session()->get('favoritos', []);
        $favoritos = array_slice($favoritos, 0, 4);
        if($cart){ $totalProducts = count($cart); }else{ $totalProducts = ""; }
        if($favoritos){ $totalFavoritos = count($favoritos); }else{ $totalFavoritos = ""; }
        $datos = Datos_empresas::first();
        if(!$datos){
            $datos = new Datos_empresas();
            $datos->nombre_config = "Nombre de la empresa";
            $datos->save();
        }
        $url = 'https://api.skydropx.com/v1/carriers';
            // Encabezados de la solicitud
            $headers = [
                'Authorization' => 'Token token=' . env('APISKYDROPX'),
                'Content-Type' => 'application/json',
            ];
            $response = Http::withHeaders($headers)->get($url);
            $carriers = [];
            foreach ($response['data'] as $carrier) {
                $carrierId = $carrier['id'];
                $carrierName = $carrier['attributes']['name'];
                $carriers[] = [
                    'id' => $carrierId,
                    'name' => $carrierName,
                ];
            }
        $banners = Banners::get();
        return view('datos_empresa/index', compact('datos', 'cart', 'totalProducts', 'favoritos', 'totalFavoritos', 'banners', 'carriers'));
    }
    public function update(Request $request, Datos_empresas $datos_empresa)
    {

        $rules = [
            'costo' => ['nullable', 'string', 'regex:/^\$\s?\d+(\.\d{2})?$/'],
            'peso' => ['nullable', 'string', 'regex:/^\d+\s?kg$/'],
            'altura' => ['nullable', 'string', 'regex:/^\d+\s?cm$/'],
            'ancho' => ['nullable', 'string', 'regex:/^\d+\s?cm$/'],
            'longitud' => ['nullable', 'string', 'regex:/^\d+\s?cm$/'],
            'nombre' => ['required', 'string', 'max:50'],
            'email' => ['required', 'email'],
            'telefono' => ['required', 'string', 'max:20'],
            'mensaje_footer' => ['required', 'string', 'max:250'],
            'direccion' => ['required', 'string', 'max:250'],
            'rfc' => ['nullable', 'string', 'max:25'],
            'envio' => ['required', 'string', 'max:25'],
            'paqueteria' => ['nullable', 'string', 'max:25'],
            'facebook' => ['nullable', 'string', 'regex:/^(http|https):\/\/[^ "]+$/'],
            'instagram' => ['nullable', 'string', 'regex:/^(http|https):\/\/[^ "]+$/'],
            'youtube' => ['nullable', 'string', 'regex:/^(http|https):\/\/[^ "]+$/'],
            'tiktok' => ['nullable', 'string', 'regex:/^(http|https):\/\/[^ "]+$/'],
            'mercadoPago' => 'nullable|boolean',
            'paypal' => 'nullable|boolean',
            'empresa' => ['required', 'string', 'max:150'],
            'provincia' => ['required', 'string', 'max:150'],
            'ciudad' => ['required', 'string', 'max:150'],
            'codigo_postal' => ['digits:5'],
        ];
        $messages = [
            'costo.regex' => 'El costo debe tener el formato correcto, por ejemplo: $ 10.00',
            'costo.string' => 'El nombre contiene caracteres desconocidos.',
            'peso.regex' => 'El costo debe tener el formato correcto, por ejemplo: $ 10.00',
            'peso.string' => 'El nombre contiene caracteres desconocidos.',
            'altura.regex' => 'El costo debe tener el formato correcto, por ejemplo: $ 10.00',
            'altura.string' => 'El nombre contiene caracteres desconocidos.',
            'ancho.regex' => 'El costo debe tener el formato correcto, por ejemplo: $ 10.00',
            'ancho.string' => 'El nombre contiene caracteres desconocidos.',
            'longitud.regex' => 'El costo debe tener el formato correcto, por ejemplo: $ 10.00',
            'longitud.string' => 'El nombre contiene caracteres desconocidos.',
            'nombre.string' => 'El nombre contiene caracteres desconocidos.',
            'nombre.required' => 'El nombre es obligatorio.',
            'email.required' => 'El correo electrónico es obligatorio.',
            'email.email' => 'El correo electrónico no contiene el formato adecuado.',
            'telefono.required' => 'El teléfono es obligatorio.',
            'telefono.string' => 'El teléfono contiene caracteres desconocidos.',
            'mensaje_footer.required' => 'El mensaje footer es obligatorio.',
            'mensaje_footer.string' => 'El mensaje footer contiene caracteres desconocidos.',
            'direccion.required' => 'La direccion es obligatorio.',
            'direccion.string' => 'La direccion contiene caracteres desconocidos.',
            'rfc.string' => 'El mensaje contiene caracteres desconocidos.',
            'envio.required' => 'El envio es obligatorio.',
            'envio.string' => 'El envio contiene caracteres desconocidos.',
            'paqueteria.string' => 'El mensaje contiene caracteres desconocidos.',
            'facebook.regex' => 'La URL debe tener el formato correcto Https o http',
            'instagram.regex' => 'La URL debe tener el formato correcto Https o http',
            'youtube.regex' => 'La URL debe tener el formato correcto Https o http',
            'tiktok.regex' => 'La URL debe tener el formato correcto Https o http',
            'empresa.string' => 'La empresa contiene caracteres desconocidos.',
            'provincia.string' => 'La provincia contiene caracteres desconocidos.',
            'ciudad.string' => 'La ciudad contiene caracteres desconocidos.',
            'codigo_postal.digits' => 'El código postal de de contener 5 digitos.',
        ];
        $validator = Validator::make($request->all(), $rules, $messages);
        if ($validator->fails()) { return redirect()->back()->withErrors($validator)->withInput(); }
        $sanitizedData = $validator->validated();



        $imagen = $request->file("logo");
        if($imagen){
            $request->validate([
                'fotografia' => 'image|mimes:jpeg,png,jpg,gif', // Ejemplo de regla para imágenes JPEG, PNG, JPG y GIF con un tamaño máximo de 2MB
            ]);
            $img = Str::random(20).".".$imagen->guessExtension();
            $ruta = public_path("assets/img/logos/");
            copy($imagen->getRealPath(),$ruta.$img);
            $datos = Datos_empresas::first();
            $datos->logo_config = $img;
            $datos->save();
        }


        $datos = Datos_empresas::first();
        $datos->nombre_config = $sanitizedData['nombre'];
        $datos->empresa_config = $sanitizedData['empresa'];
        $datos->rfc_config = $sanitizedData['rfc'];
        $datos->telefono_config = $sanitizedData['telefono'];
        $datos->provincia_config = $sanitizedData['provincia'];
        $datos->ciudad_config = $sanitizedData['ciudad'];
        $datos->codigo_postal_config = $sanitizedData['codigo_postal'];
        $datos->direccion_config = $sanitizedData['direccion'];
        $datos->email_config = $sanitizedData['email'];
        $datos->mensaje_footer_config = $sanitizedData['mensaje_footer'];
        $datos->mercado_pago_config = $request->input('mercadoPago', false);
        $datos->paypal_config = $request->input('paypal', false);
        $datos->envio_config = $sanitizedData['envio'];
        if ($sanitizedData['envio'] === 'Costo Fijo') {
            $datos->costo_envio_config = str_replace(['$', ','], '', $sanitizedData['costo']);
            $datos->weight_config = 0;
            $datos->height_config = 0;
            $datos->length_config = 0;
            $datos->width_config = 0;
        } elseif ($sanitizedData['envio'] === 'Por Paqueteria') {
            $datos->paqueteria_envio_config = $sanitizedData['paqueteria'];
            $datos->weight_config = intval($sanitizedData['peso']);
            $datos->height_config = intval($sanitizedData['altura']);
            $datos->length_config = intval($sanitizedData['ancho']);
            $datos->width_config = intval($sanitizedData['longitud']);
        }
        $datos->facebook_config = $sanitizedData['facebook'];
        $datos->instagram_config = $sanitizedData['instagram'];
        $datos->youtube_config = $sanitizedData['youtube'];
        $datos->tiktok_config = $sanitizedData['tiktok'];
        $datos->color_pricipal_config = $request->post('color_principal');
        $datos->save();
        return redirect()->route("datos_empresa.index")->with("success", "¡Actualizado Correctamente!");
    }
    public function storeBanner(Request $request)
    {
        $validator = Validator::make($request->all(), [ 'imagen' => 'required|image|mimes:jpeg,png,jpeg', ]);
        $imagen = $request->file("imagen");
        $img = Str::random(20).".".$imagen->guessExtension();
        $ruta = public_path("assets/store/img/banners/");
        copy($imagen->getRealPath(),$ruta.$img);
        $permitted_chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $codigo = "BANN" . substr(str_shuffle($permitted_chars), 0, 16);
        $datos = new Banners();
        $datos->codigo_bann = $codigo;
        $datos->imagen_bann = $img;
        $datos->titulo_bann = $request->post('titulo');
        $datos->subtitulo_bann = $request->post('subtitulo');
        $datos->url_bann = $request->post('url');
        $datos->save();
        return redirect()->back()->with('success', '¡Banner agregado correctamente!');
    }
    public function deleteBanner($id, Request $request)
    {
        $imagen = Banners::where('codigo_bann', $id)->first();
        $rutaImagen = public_path("assets/store/img/banners/") . $imagen->imagen_bann;
        if (file_exists($rutaImagen)) {
            unlink($rutaImagen);
        }
        $datos = Banners::where('codigo_bann', $id)->first();
        $datos->delete();
        return redirect()->back()->with('success', '¡Banner eliminado correctamente!');
    }
}
