<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Direcciones;
use Illuminate\Http\Request;
use App\Models\Estados_republica;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;

class DireccionesController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    public function index()
    {
        $carts = session()->get('cart', []);
        $cart = array_slice($carts, 0, 4);
        $favoritos = session()->get('favoritos', []);
        $favoritos = array_slice($favoritos, 0, 4);
        if($cart){ $totalProducts = count($cart); }else{ $totalProducts = ""; }
        if($favoritos){ $totalFavoritos = count($favoritos); }else{ $totalFavoritos = ""; }
        $estadosRepublica = Estados_republica::get();
        $usuario = User::where('id', '=', Auth::user()->id)->first();
        if ($usuario->hasRole('Administrador')){
            $datos = Direcciones::select('name', 'referencia_dire', 'estado_dire', 'direccion_dire', 'pais_dire', 'ciudad_dire', 'nombre_edo', 'codigo_postal_dire', 'codigo_dire')
            ->join('users','users.id', '=', 'direcciones.usuario_dire')
            ->join('estados_republica','estados_republica.id', '=', 'direcciones.estado_dire')
            ->where('estatus_dire', '<>', 'Eliminado')->get();
        }
        if ($usuario->hasRole('Cliente')){
            $datos = Direcciones::select('direccion_dire', 'referencia_dire', 'estado_dire', 'pais_dire', 'ciudad_dire', 'nombre_edo', 'codigo_postal_dire', 'codigo_dire')
            ->join('estados_republica','estados_republica.id', '=', 'direcciones.estado_dire')->where('estatus_dire', '<>', 'Eliminado')->where('usuario_dire', Auth::user()->id)->get();
        }
        return view('direcciones/index', compact('datos', 'totalProducts', 'cart', 'favoritos', 'estadosRepublica','totalFavoritos'));
    }
    public function store(Request $request)
    {
        $rules = [
            'direccion' => 'required|string',
            'referencia' => 'required|string',
            'pais' => 'required|string',
            'ciudad' => 'required|string',
            'estado' => 'required|string',
            'cp' => 'required|integer',
        ];
        $messages = [
            'direccion.string' => 'La dirección contiene caracteres desconocidos.',
            'direccion.required' => 'La dirección es obligatorio.',
            'referencia.string' => 'La referencia contiene caracteres desconocidos.',
            'referencia.required' => 'La referencia es obligatorio.',
            'pais.string' => 'El país contiene caracteres desconocidos.',
            'pais.required' => 'El país es obligatorio.',
            'ciudad.string' => 'La ciudad contiene caracteres desconocidos.',
            'ciudad.required' => 'La ciudad es obligatorio.',
            'estado.string' => 'El estado contiene caracteres desconocidos.',
            'estado.required' => 'El estado es obligatorio.',
            'cp.string' => 'El código postal contiene caracteres desconocidos.',
            'cp.required' => 'El código postal es obligatorio.',
		];
        $validator = Validator::make($request->all(), $rules, $messages);
        if ($validator->fails()) { $errors = $validator->errors()->all(); return redirect()->back()->with('danger', implode(', ', $errors));}
        $sanitizedData = $validator->validated();
        $direccion = $sanitizedData['direccion'];
        $referencia = $sanitizedData['referencia'];
        $pais = $sanitizedData['pais'];
        $ciudad = $sanitizedData['ciudad'];
        $estado = $sanitizedData['estado'];
        $cp = $sanitizedData['cp'];
        $permitted_chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $token = "DIRE" . substr(str_shuffle($permitted_chars), 0, 16);
        $datos = new Direcciones();
        $datos->codigo_dire = $token;
        $datos->usuario_dire = Auth::user()->id;
        $datos->pais_dire = $pais;
        $datos->ciudad_dire = $ciudad;
        $datos->estado_dire = $estado;
        $datos->direccion_dire = $direccion;
        $datos->referencia_dire = $referencia;
        $datos->codigo_postal_dire = $cp;
        $datos->estatus_dire = 'Activo';
        $datos->save();
        return redirect()->back()->with('success', '¡Registrado existosamente!');
    }
    public function update(Request $request, Direcciones $direcciones, $id)
    {
        $rules = [
            'direccion' => 'required|string',
            'referencia' => 'required|string',
            'pais' => 'required|string',
            'ciudad' => 'required|string',
            'estado' => 'required|string',
            'cp' => 'required|integer',
        ];
        $messages = [
            'direccion.string' => 'La dirección contiene caracteres desconocidos.',
            'direccion.required' => 'La dirección es obligatorio.',
            'referencia.string' => 'La dirección contiene caracteres desconocidos.',
            'referencia.required' => 'La dirección es obligatorio.',
            'pais.string' => 'El país contiene caracteres desconocidos.',
            'pais.required' => 'El país es obligatorio.',
            'ciudad.string' => 'La ciudad contiene caracteres desconocidos.',
            'ciudad.required' => 'La ciudad es obligatorio.',
            'estado.string' => 'El estado contiene caracteres desconocidos.',
            'estado.required' => 'El estado es obligatorio.',
            'cp.string' => 'El código postal contiene caracteres desconocidos.',
            'cp.required' => 'El código postal es obligatorio.',
		];
        $validator = Validator::make($request->all(), $rules, $messages);
        if ($validator->fails()) { $errors = $validator->errors()->all(); return redirect()->back()->with('danger', implode(', ', $errors));}
        $sanitizedData = $validator->validated();
        $direccion = $sanitizedData['direccion'];
        $referencia = $sanitizedData['referencia'];
        $pais = $sanitizedData['pais'];
        $ciudad = $sanitizedData['ciudad'];
        $estado = $sanitizedData['estado'];
        $cp = $sanitizedData['cp'];
        $datos = Direcciones::where('codigo_dire', $id)->first();
        $datos->pais_dire = $pais;
        $datos->ciudad_dire = $ciudad;
        $datos->estado_dire = $estado;
        $datos->direccion_dire = $direccion;
        $datos->referencia_dire = $referencia;
        $datos->codigo_postal_dire = $cp;
        $datos->save();
        return redirect()->back()->with('success', '¡Actualizado existosamente!');
    }
    public function delete(Request $request, $id)
    {
        $datos = Direcciones::where('codigo_dire', $id)->first();
        $datos->estatus_dire = 'Eliminado';
        $datos->save();
        return redirect()->back()->with('success', '¡Eliminado existosamente!');
    }
}
