<?php

namespace App\Http\Controllers;

use App\Models\Eventos;
use App\Models\Eventos_boletos;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class EventosController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }
    public function index()
    {
        $carts = session()->get('cart', []);
        $cart = array_slice($carts, 0, 4);
        $favoritos = session()->get('favoritos', []);
        $favoritos = array_slice($favoritos, 0, 4);
        if($cart){ $totalProducts = count($cart); }else{ $totalProducts = ""; }
        if($favoritos){ $totalFavoritos = count($favoritos); }else{ $totalFavoritos = ""; }
        $datos = Eventos::where('estatus_even', '<>', 'Eliminado')->get();
        return view('eventos/index', compact('datos', 'totalProducts', 'cart' , 'favoritos', 'totalFavoritos'));
    }
    public function store(Request $request)
    {
        $permitted_chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $token = "EVEN" . substr(str_shuffle($permitted_chars), 0, 16);
        $datos = new Eventos();
        $datos->codigo_even = $token;
        $datos->fecha_even = $request->post('fecha');
        $datos->nombre_even = $request->post('nombre');
        $datos->estatus_even = 'Activo';
        $datos->save();
        return redirect()->route("eventos.dats", $token)->with("success", "¡Registrado existosamente!");
    }
    public function dats($id, Request $request)
    {
        $carts = session()->get('cart', []);
        $cart = array_slice($carts, 0, 4);
        $favoritos = session()->get('favoritos', []);
        $favoritos = array_slice($favoritos, 0, 4);
        if($cart){ $totalProducts = count($cart); }else{ $totalProducts = ""; }
        if($favoritos){ $totalFavoritos = count($favoritos); }else{ $totalFavoritos = ""; }
        $datos = Eventos::where('codigo_even', $id)->first();
        $boletos = Eventos_boletos::where('estatus_enbo', '=', 'Activo')->where('evento_enbo', $datos->id)->get();
        return view('eventos/dats', compact( 'datos', 'boletos',  'totalProducts', 'cart', 'favoritos', 'totalFavoritos'));
    }
    public function update(Request $request, Eventos $eventos, $id)
    {
        if($request->file("imagenPrincipal")){
            $validator = Validator::make($request->all(), ['imagenPrincipal' => 'required|image|mimes:jpeg,png,jpeg']);
            $imagen = $request->file("imagenPrincipal");
            $img = Str::random(20).".".$imagen->guessExtension();
            $ruta = public_path("assets/img/eventos/");
            copy($imagen->getRealPath(),$ruta.$img);
        }
        if($request->file("banner")){
            $validator = Validator::make($request->all(), ['banner' => 'required|image|mimes:jpeg,png,jpeg']);
            $imagenBanner = $request->file("banner");
            $imgBanner = Str::random(20).".".$imagenBanner->guessExtension();
            $ruta = public_path("assets/img/eventos/");
            copy($imagenBanner->getRealPath(),$ruta.$imgBanner);
        }
        $datos = Eventos::where('codigo_even', $id)->first();
        $datos->nombre_even = $request->post('nombre');
        $datos->decripcion_even = $request->post('descripcion');
        if($request->file("imagenPrincipal")){ $datos->imagen_even = $img; }
        if($request->file("banner")){ $datos->banner_even = $imgBanner; }
        $datos->save();
        return redirect()->back()->with('success', '¡Actualizado existosamente!');
    }
    public function activate(Request $request, $id)
    {
        $datos = Eventos::where('codigo_even', $id)->first();
        $datos->estatus_even = 'Activo';
        $datos->save();
        return redirect()->back()->with('success', '¡Activado existosamente!');
    }
    public function inactivate(Request $request, $id)
    {
        $datos = Eventos::where('codigo_even', $id)->first();
        $datos->estatus_even = 'Inactivo';
        $datos->save();
        return redirect()->back()->with('success', '¡Inactivado existosamente!');
    }
    public function delete(Request $request, $id)
    {
        $datos = Eventos::where('codigo_even', $id)->first();
        $datos->estatus_even = 'Eliminado';
        $datos->save();
        return redirect()->back()->with('success', '¡Eliminado existosamente!');
    }
    public function storeBoletos($id, Request $request)
    {
        $caracteres = Array("$","mm","Dk/t","%",","," ");
        $permitted_chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $evento = Eventos::where('codigo_even', $id,)->first();
        $numeroBoletos = null;
        if($request->post('limitarStock') == 1){ $numeroBoletos = $request->post('numeroBoletos'); }
        $token = "ENBO" . substr(str_shuffle($permitted_chars), 0, 16);
        $datos = new Eventos_boletos();
        $datos->codigo_enbo = $token;
        $datos->evento_enbo = $evento->id;
        $datos->nombre_enbo = $request->post('nombre');
        $datos->precio_enbo = htmlspecialchars(str_replace($caracteres,"",$request->input('precio')));
        $datos->stock_enbo = $request->post('limitarStock');
        $datos->nro_boletos_enbo = $numeroBoletos;
        $datos->estatus_enbo = 'Activo';
        $datos->save();
        return redirect()->back()->with('success', '¡Registrado existosamente!');
    }
    public function updateBoletos($id, Request $request)
    {
        $caracteres = Array("$","mm","Dk/t","%",","," ");
        $datos = Eventos_boletos::where('codigo_enbo', $id,)->first();
        $datos->nombre_enbo = $request->post('nombre');
        $numeroBoletos = null;
        if($request->post('limitarStock') == 1){ $numeroBoletos = $request->post('numeroBoletos'); }
        $datos->precio_enbo = htmlspecialchars(str_replace($caracteres,"",$request->input('precio')));
        $datos->stock_enbo = $request->post('limitarStock');
        $datos->nro_boletos_enbo = $numeroBoletos;
        $datos->estatus_enbo = 'Activo';
        $datos->save();
        return redirect()->back()->with('success', '¡Actualizado existosamente!');
    }
    public function deleteBoletos(Request $request, $id)
    {
        $datos = Eventos_boletos::where('codigo_enbo', $id)->first();
        $datos->estatus_enbo = 'Eliminado';
        $datos->save();
        return redirect()->back()->with('success', '¡Eliminado existosamente!');
    }
}
