<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use App\Models\User;
use App\Models\Compras;
use App\Models\Clientes;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class HomeController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    public function index()
    {
        $carts = session()->get('cart', []);
        $cart = array_slice($carts, 0, 4);
        $favoritos = session()->get('favoritos', []);
        $favoritos = array_slice($favoritos, 0, 4);
        if($cart){ $totalProducts = count($cart); }else{ $totalProducts = 0; }
        if($favoritos){ $totalFavoritos = count($favoritos); }else{ $totalFavoritos = ""; }
        $usuario = User::where('id', '=', Auth::user()->id)->first();
        $mesActual = Carbon::now()->locale('es')->monthName;
        $anioActual = Carbon::now()->locale('es')->year;
        $clientes = Clientes::where('estatus_clie', '=' , 'Activo')->whereYear('created_at', $anioActual)->count();
        $graficaVentasMes = Compras::select(
            DB::raw('MONTH(pagos_comprobantes.fecha_paco) as mes'),
            DB::raw('SUM(total_comp) as total')
        )
        ->join('pagos_comprobantes', 'pagos_comprobantes.cod_pago_paco','=', 'compras.codigo_comp')
        ->whereYear('pagos_comprobantes.fecha_paco', $anioActual)
        ->where('estatus_paco','=','Entregado')
        ->groupBy('mes')
        ->orderBy('mes', 'asc')
        ->get();
        //dd($graficaVentasMes);
        if ($graficaVentasMes->isEmpty()) {
            $labelsVentasMes = [""];
            $dataConteoVisitasMes = [0];
        } else {
            $labelsVentasMes = [];
            $dataConteoVisitasMes = [];
            foreach ($graficaVentasMes as $itemVentasMes) {
                $labelsVentasMes[] = Carbon::createFromFormat('!m', $itemVentasMes->mes)->locale('es')->monthName;
                $dataConteoVisitasMes[] = $itemVentasMes->total;
            }
        }
        if ($usuario->hasRole('Administrador')){
            $conteoCompras = Compras::join('pagos_comprobantes', 'pagos_comprobantes.cod_pago_paco','=', 'compras.codigo_comp')
            ->whereMonth('pagos_comprobantes.fecha_paco', now()->month)->where('estatus_paco','=','Entregado')->sum('total_comp');
            $conteoProductos = Compras::join('pagos_comprobantes', 'pagos_comprobantes.cod_pago_paco','=', 'compras.codigo_comp')
            ->join('pedidos', 'pedidos.compra_pedi', '=', 'compras.id')
            ->whereMonth('pagos_comprobantes.fecha_paco', now()->month)->where('estatus_paco','=','Entregado')->count();
        }
        if ($usuario->hasRole('Cliente')){
            $conteoCompras = Compras::join('pagos_comprobantes', 'pagos_comprobantes.cod_pago_paco','=', 'compras.codigo_comp')
            ->whereMonth('pagos_comprobantes.fecha_paco', now()->month)->where('usuario_comp', Auth::user()->id)->where('estatus_paco','=','Entregado')->sum('total_comp');
            $conteoProductos = Compras::join('pagos_comprobantes', 'pagos_comprobantes.cod_pago_paco','=', 'compras.codigo_comp')
            ->join('pedidos', 'pedidos.compra_pedi', '=', 'compras.id')->whereMonth('pagos_comprobantes.fecha_paco', now()->month)
            ->where('usuario_comp', Auth::user()->id)->where('estatus_paco','=','Entregado')->count();
        }
        return view('home', compact('totalProducts', 'cart', 'totalFavoritos', 'favoritos', 'conteoCompras','mesActual', 'conteoProductos',
        'clientes', 'anioActual', 'labelsVentasMes', 'dataConteoVisitasMes'));
    }
}
