<?php

namespace App\Http\Controllers;

use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Models\Productos_categorias;
use Illuminate\Support\Facades\Validator;

class ProductosCategoriasController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    public function index()
    {
        $carts = session()->get('cart', []);
        $cart = array_slice($carts, 0, 4);
        $favoritos = session()->get('favoritos', []);
        $favoritos = array_slice($favoritos, 0, 4);
        if($cart){ $totalProducts = count($cart); }else{ $totalProducts = ""; }
        if($favoritos){ $totalFavoritos = count($favoritos); }else{ $totalFavoritos = ""; }
        $datos = Productos_categorias::where('estatus_prca', '<>', 'Eliminado')->get();
        return view('categorias/index', compact('datos', 'cart', 'totalProducts', 'favoritos', 'totalFavoritos'));
    }
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [ 'imagen' => 'required|image|mimes:jpeg,png,jpeg', ]);
        $imagen = $request->file("imagen");
        $img = Str::random(20).".".$imagen->guessExtension();
        $ruta = public_path("assets/img/categorias/");
        copy($imagen->getRealPath(),$ruta.$img);
        $permitted_chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $token = "PLCA" . substr(str_shuffle($permitted_chars), 0, 16);
        $rules = [
            'nombre' => 'required|string|max:255',
        ];
        $validator = Validator::make($request->all(), $rules);
        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }
        $datos = new Productos_categorias();
        $datos->codigo_prca = $token;
        $datos->nombre_prca = $request->post('nombre');
        $datos->imagen_prca = $img;
        $datos->estatus_prca = 'Activo';
        $datos->save();
        return redirect()->back()->with('success', '¡Registrado existosamente!');
    }
    public function update(Request $request, Productos_categorias $productos_categorias, $id)
    {
        $validator = Validator::make($request->all(), [ 'imagen' => 'required|image|mimes:jpeg,png,jpeg', ]);
        $imagen = $request->file("imagen");
        $img = Str::random(20).".".$imagen->guessExtension();
        $ruta = public_path("assets/img/categorias/");
        copy($imagen->getRealPath(),$ruta.$img);
        $datos = Productos_categorias::where('codigo_prca', $id)->first();
        $datos->nombre_prca = $request->post('nombre');
        $datos->imagen_prca = $img;
        $datos->save();
        return redirect()->back()->with('success', '¡Actualizado existosamente!');
    }
    public function activate(Request $request, $id)
    {
        $datos = Productos_categorias::where('codigo_prca', $id)->first();
        $datos->estatus_prca = 'Activo';
        $datos->save();
        return redirect()->back()->with('success', '¡Activado existosamente!');
    }
    public function inactivate(Request $request, $id)
    {
        $datos = Productos_categorias::where('codigo_prca', $id)->first();
        $datos->estatus_prca = 'Inactivo';
        $datos->save();
        return redirect()->back()->with('success', '¡Inactivado existosamente!');
    }
    public function delete(Request $request, $id)
    {
        $datos = Productos_categorias::where('codigo_prca', $id)->first();
        $datos->estatus_prca = 'Eliminado';
        $datos->save();
        return redirect()->back()->with('success', '¡Eliminado existosamente!');
    }
}
