<?php

namespace App\Http\Controllers;

use Exception;
use App\Models\Productos;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Models\Productos_marcas;
use App\Models\Productos_colores;
use App\Models\Productos_imagenes;
use Illuminate\Support\Facades\Log;
use App\Models\Productos_categorias;
use Illuminate\Support\Facades\Http;
use App\Models\Productos_subcategorias;
use Illuminate\Support\Facades\Validator;
use Symfony\Component\DomCrawler\Crawler;

class ProductosController extends Controller
{
    public function index()
    {
        $carts = session()->get('cart', []);
        $cart = array_slice($carts, 0, 4);
        $favoritos = session()->get('favoritos', []);
        $favoritos = array_slice($favoritos, 0, 4);
        if($cart){ $totalProducts = count($cart); }else{ $totalProducts = ""; }
        if($favoritos){ $totalFavoritos = count($favoritos); }else{ $totalFavoritos = ""; }
        $categorias = Productos_categorias::where('estatus_prca', '=', 'Activo')->get();
        $subcategorias = Productos_subcategorias::where('estatus_prsu', '=', 'Activo')->get();
        $datos = Productos::join('productos_categorias', 'productos_categorias.id', '=', 'productos.categoria_prod')
        ->join('productos_subcategorias', 'productos_subcategorias.id', '=', 'productos.subcategoria_prod')
        ->where('estatus_prod', '<>', 'Eliminado')->get();
        return view('productos/index', compact('datos', 'categorias','subcategorias', 'totalProducts', 'cart', 'favoritos', 'totalFavoritos'));
    }
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'sku' => 'required|string|max:20|unique:products',
            'nombre' => 'required|string|max:100',
            'categoria' => 'required|string|max:100',
            'subcategoria' => 'required|string|max:100',
        ]);
        $categoria = Productos_categorias::where('codigo_prca', '=', htmlspecialchars($request->input('categoria')))->first();
        $subcategoria = Productos_subcategorias::where('codigo_prsu', '=', htmlspecialchars($request->input('subcategoria')))->first();
        $permitted_chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $codigo = "PROD" . substr(str_shuffle($permitted_chars), 0, 16);
        $sku = htmlspecialchars($request->input('sku'));
        $nombre = htmlspecialchars($request->input('nombre'));
        $datos = new Productos();
        $datos->codigo_prod = $codigo;
        $datos->sku_prod = $sku;
        $datos->nombre_prod = $nombre;
        $datos->categoria_prod = $categoria->id;
        $datos->subcategoria_prod = $subcategoria->id;
        $datos->estatus_prod = 'Activo';
        $datos->save();
        return redirect()->route("productos.dats", $codigo)->with("success", "¡Registrado existosamente!");
    }
    public function dats($id)
    {
        $carts = session()->get('cart', []);
        $cart = array_slice($carts, 0, 4);
        $favoritos = session()->get('favoritos', []);
        $favoritos = array_slice($favoritos, 0, 4);
        if($cart){ $totalProducts = count($cart); }else{ $totalProducts = ""; }
        if($favoritos){ $totalFavoritos = count($favoritos); }else{ $totalFavoritos = ""; }
        $datos = Productos::select('*', 'productos.id as idProducto')
        ->join('productos_categorias', 'productos_categorias.id', '=', 'productos.categoria_prod')
        ->join('productos_subcategorias', 'productos_subcategorias.id', '=', 'productos.subcategoria_prod')
        ->leftjoin('productos_marcas', 'productos_marcas.id', '=', 'productos.marca_prod')
        ->where('codigo_prod', '=', $id)->first();
        $categorias = Productos_categorias::where('estatus_prca', '=', 'Activo')->get();
        $subcategorias = Productos_subcategorias::where('estatus_prsu', '=', 'Activo')->get();
        $marcas = Productos_marcas::where('estatus_prma', '=', 'Activo')->get();
        $colores = Productos_colores ::where('estatus_prco', '=', 'Activo')->where('producto_prco', '=', $datos->idProducto)->get();
        $imagenes = Productos_imagenes::where('estatus_prim', '=', 'Activo')->where('producto_prim', '=', $datos->idProducto)->get();
        return view('productos/dats', compact('marcas','categorias','subcategorias', 'datos', 'colores', 'imagenes',  'totalProducts', 'cart', 'favoritos', 'totalFavoritos'));
    }
    public function update(Request $request, Productos $productos, $id)
    {
        $caracteres = Array("$","mm","Dk/t","%",","," ");
        $validator = Validator::make($request->all(), [
            'sku' => 'required|string|max:20',
            'nombre' => 'required|string|max:100',
            'descripcion_larga' => 'required|string|max:255',
            'marca' => 'string',
            'categoria' => 'string',
            'subcategoria' => 'string',
            'stock' => 'numeric',
        ]);
        $sku = htmlspecialchars($request->input('sku'));
        $nombre = htmlspecialchars($request->input('nombre'));
        $descripcion_corta = $request->input('descripcion_corta');
        $descripcionLarga = $request->input('descripcion_larga');
        $marca = htmlspecialchars($request->input('marca'));
        $categoria = htmlspecialchars($request->input('categoria'));
        $subcategoria = htmlspecialchars($request->input('subcategoria'));
        $linea = htmlspecialchars($request->input('linea'));
        $oferta = htmlspecialchars($request->input('oferta'));
        $nuevos = htmlspecialchars($request->input('nuevos'));
        if($request->file("imagenPrincipal")){
            $validator = Validator::make($request->all(), ['imagenPrincipal' => 'required|image|mimes:jpeg,png,jpeg']);
            $imagen = $request->file("imagenPrincipal");
            $img = Str::random(20).".".$imagen->guessExtension();
            $ruta = public_path("assets/img/productos/");
            copy($imagen->getRealPath(),$ruta.$img);
        }
        $marcas = Productos_marcas::where('codigo_prma', '=', $marca)->first();
        $categoria = Productos_categorias::where('codigo_prca', '=', $categoria)->first();
        $subcategoria = Productos_subcategorias::where('codigo_prsu', '=', $subcategoria)->first();
        $datos = Productos::where('codigo_prod', $id)->first();
        $stock = htmlspecialchars($request->input('stock'));
        $compra = htmlspecialchars(str_replace($caracteres,"",$request->input('compra')));
        if($compra <= 0 ){ return redirect()->back()->with('danger', '¡El costo de compra debe ser mayor a $1.00!'); }
        $venta = htmlspecialchars(str_replace($caracteres,"",$request->input('venta')));
        if($venta <= 0 ){ return redirect()->back()->with('danger', '¡El costo de venta debe ser mayor a $1.00!'); }
        $datos->sku_prod = $sku;
        $datos->nombre_prod = $nombre;
        $datos->descripcion_corta_prod = $descripcion_corta;
        $datos->descripcion_larga_prod = $descripcionLarga;
        if($request->file("imagenPrincipal")){ $datos->imagen_principal_prod = $img; }
        $datos->compra_prod = $compra;
        $datos->venta_prod = $venta;
        $datos->stock_prod = $stock;
        $datos->marca_prod = $marcas->id;
        $datos->categoria_prod = $categoria->id;
        $datos->subcategoria_prod = $subcategoria->id;
        $datos->linea_prod = $linea;
        $datos->ofertas_prod = $oferta;
        $datos->nuevo_prod = $nuevos;
        $datos->save();
        return redirect()->back()->with('success', '¡Actualizado existosamente!');
    }
    public function storeColor(Request $request, $id)
    {
        $producto = Productos::where('codigo_prod', '=', $id)->first();
        $color = $request->input('colorProducto');
        $permitted_chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $codigo = "PRCO" . substr(str_shuffle($permitted_chars), 0, 16);
        $datos = new Productos_colores();
        $datos->codigo_prco = $codigo;
        $datos->producto_prco = $producto->id;
        $datos->color_prco = $color;
        $datos->estatus_prco = 'Activo';
        $datos->save();
        return redirect()->back()->with('success', '¡Color agregado correctamente!');
    }
    public function storeImagen(Request $request, $id)
    {
        $producto = Productos::where('codigo_prod', '=', $id)->first();
        $validator = Validator::make($request->all(), [ 'imagen' => 'required|image|mimes:jpeg,png,jpeg', ]);
        $imagen = $request->file("imagen");
        $img = Str::random(20).".".$imagen->guessExtension();
        $ruta = public_path("assets/img/productos/");
        copy($imagen->getRealPath(),$ruta.$img);
        $permitted_chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $codigo = "PRIM" . substr(str_shuffle($permitted_chars), 0, 16);
        $datos = new Productos_imagenes();
        $datos->codigo_prim = $codigo;
        $datos->producto_prim = $producto->id;
        $datos->imagen_prim = $img;
        $datos->estatus_prim = 'Activo';
        $datos->save();
        return redirect()->back()->with('success', '¡Imagen agregado correctamente!');
    }
    public function deleteColor(Request $request, $id)
    {
        $datos = Productos_colores::where('codigo_prco', $id)->first();
        $datos->estatus_prco = 'Eliminado';
        $datos->save();
        return redirect()->back()->with('success', '¡Eliminado existosamente!');
    }
    public function deleteImagen(Request $request, $id)
    {
        $datos = Productos_imagenes::where('codigo_prim', $id)->first();
        $datos->estatus_prim = 'Eliminado';
        $datos->save();
        return redirect()->back()->with('success', '¡Eliminado existosamente!');
    }
    public function activate(Request $request, $id)
    {
        $datos = Productos::where('codigo_prod', $id)->first();
        $datos->estatus_prod = 'Activo';
        $datos->save();
        return redirect()->back()->with('success', '¡Activado existosamente!');
    }
    public function inactivate(Request $request, $id)
    {
        $datos = Productos::where('codigo_prod', $id)->first();
        $datos->estatus_prod = 'Inactivo';
        $datos->save();
        return redirect()->back()->with('success', '¡Inactivado existosamente!');
    }
    public function delete(Request $request, $id)
    {
        $datos = Productos::where('codigo_prod', $id)->first();
        $datos->estatus_prod = 'Eliminado';
        $datos->save();
        return redirect()->back()->with('success', '¡Eliminado existosamente!');
    }
    public function descargarBGS()
    {
        set_time_limit(0);
        $productosEncontrados = [];
        $categoriasProcesadas = 0;
        $productosTotales = 0;
        // Obtener el contenido de la página principal
        $htmlContentCatSub = Http::get('https://herramienta-automotriz.com.mx/')->body();
        $crawlerCatSub = new Crawler($htmlContentCatSub);
        // Seleccionar los elementos dropdown-full que contienen las categorías
        $crawlerCatSub->filter('.dropdown-full')->each(function (Crawler $categoryNode) use (&$productos, &$categoriasProcesadas, &$productosTotales) {
            // Obtener el nombre de la categoría principal (Productos)
            $categoryName = trim($categoryNode->filter('a.dropdown-toggle')->first()->text());
            $categoryName = str_replace(['caret', "\n", "\r"], '', $categoryName);
            $categoryName = trim(preg_replace('/\s+/', ' ', $categoryName));
            // Buscar las columnas dentro del dropdown-menu
            $categoryNode->filter('.dropdown-menu .col-sm-3')->each(function (Crawler $columnNode) use (&$productos, $categoryName, &$categoriasProcesadas, &$productosTotales) {
                // Obtener la subcategoría (h5)
                $subCategoryNodes = $columnNode->filter('h5');
                if ($subCategoryNodes->count() > 0) {
                    $subCategoryName = trim($subCategoryNodes->text());
                    // Obtener todos los enlaces dentro de esta subcategoría
                    $columnNode->filter('ul li a')->each(function (Crawler $linkNode) use (&$productos, $categoryName, $subCategoryName, &$categoriasProcesadas, &$productosTotales) {
                        $categoryUrl = $linkNode->attr('href');
                        $fullCategoryUrl = "https://herramienta-automotriz.com.mx" . $categoryUrl;
                        $subcategoriaName = trim($linkNode->text());
                        $categoriasProcesadas++;
                        try {
                            // Procesar todas las páginas de esta categoría
                            $pageNum = 1;
                            $procesarPaginas = true;
                            while ($procesarPaginas) {
                                $currentUrl = $fullCategoryUrl;
                                if ($pageNum > 1) { $currentUrl .= "?page=" . $pageNum; }
                                // Obtener el contenido de la página de lista de productos
                                $htmlContentListProd = Http::get($currentUrl)->body();
                                $crawlerListProd = new Crawler($htmlContentListProd);
                                // Extraer productos de esta página
                                $productosEnPagina = 0;
                                $crawlerListProd->filter('div.element.mb30')->each(function (Crawler $card) use (&$productos, $categoryName, $subCategoryName, $subcategoriaName, $categoryUrl, &$productosEnPagina, &$productosTotales) {
                                    try {
                                        // Verificar si el producto está agotado
                                        $isOutOfStock = $card->filter('div.sold-out')->count() > 0;
                                        // Extraer la URL del producto
                                        $productUrl = '';
                                        $productUrlNode = $card->filter('div.product-image a');
                                        if ($productUrlNode->count() > 0) {
                                            $productUrl = $productUrlNode->attr('href');
                                            $fullProductUrl = "https://herramienta-automotriz.com.mx" . $productUrl;
                                        }
                                        // Extraer la imagen
                                        $imageUrl = '';
                                        $imageNode = $card->filter('div.product-image a img');
                                        if ($imageNode->count() > 0) {
                                            $imageUrl = $imageNode->attr('src');
                                            if (strpos($imageUrl, '//') === 0) {
                                                $imageUrl = "https:" . $imageUrl;
                                            }
                                        }
                                        // Extraer el título
                                        $title = '';
                                        $titleNode = $card->filter('div.desc h5 a');
                                        if ($titleNode->count() > 0) {
                                            $title = trim($titleNode->text());
                                        }
                                        // Extraer el código de artículo
                                        $articleCode = '';
                                        $articleNode = $card->filter('div.desc p');
                                        if ($articleNode->count() > 0) {  $articleCode = trim($articleNode->text());}
                                        // Extraer el precio
                                        $price = '';
                                        $priceNode = $card->filter('div.price');
                                        if ($priceNode->count() > 0) {
                                            $price = trim($priceNode->text());
                                        }
                                        // Extraer el ID del producto
                                        $productId = '';
                                        $idInput = $card->filter('form input[name="id"]');
                                        if ($idInput->count() > 0) {
                                            $productId = $idInput->attr('value');
                                        }
                                        // Verificar el tipo de botón (Agregar al Carrito o Ver Opciones)
                                        $hasOptions = false;
                                        if ($card->filter('a.more_btn')->count() > 0) {
                                            $hasOptions = true;
                                        }
                                        $htmlContentProd = Http::get($fullProductUrl)->body();
                                        $crawlerProd= new Crawler($htmlContentProd);
                                        // Extraer la descripción y detalles del producto
                                        $descripcionHtml = '';
                                        $caracteristicas = [];
                                        $medidas = [];
                                        $tieneDescripcion = false;
                                        try {
                                            // Extraer la descripción completa
                                            $descripcionNode = $crawlerProd->filter('.desc_blk .rte[itemprop="description"]');
                                            if ($descripcionNode->count() > 0) {
                                                $descripcionHtml = trim($descripcionNode->html());
                                                $tieneDescripcion = true;
                                                // Extraer características si existen
                                                $caracteristicasNode = $descripcionNode->filter('ul li');
                                                if ($caracteristicasNode->count() > 0) {
                                                    $caracteristicasNode->each(function (Crawler $item) use (&$caracteristicas, &$medidas) {
                                                        $texto = trim($item->text());
                                                        if (preg_match('/^\d+(\.\d+)?\s*(mm|cm|m|pulgadas|"|in|inch)/', $texto) ||
                                                            preg_match('/^[0-9\/]+\s*"/', $texto)) {
                                                            $medidas[] = $texto;
                                                        } else {
                                                            $caracteristicas[] = $texto;
                                                        }
                                                    });
                                                }
                                            }
                                            // Extraer SKU
                                            $skuNode = $crawlerProd->filter('.variant-sku #sku');
                                            if ($skuNode->count() > 0) {
                                                $sku = trim($skuNode->text());
                                            } else {
                                                // Intento alternativo
                                                $skuAlternativeNode = $crawlerProd->filter('.variant-sku');
                                                if ($skuAlternativeNode->count() > 0) {
                                                    $skuText = trim($skuAlternativeNode->text());
                                                    if (preg_match('/Art\.\s*([^\s]+)/', $skuText, $matches)) {
                                                        $sku = $matches[1];
                                                    }
                                                }
                                            }
                                            // Extraer información de stock
                                            $stock = '';
                                            $stockNode = $crawlerProd->filter('.sa_variantStock');
                                            if ($stockNode->count() > 0) {
                                                $stockText = trim($stockNode->text());
                                                if (preg_match('/(\d+)/', $stockText, $matches)) {
                                                    $stock = $matches[1]; // Esto extraerá solo el número
                                                }
                                            }
                                        } catch (\Exception $e) {
                                            // Manejar error al extraer descripción
                                            Log::error("Error al extraer descripción para {$fullProductUrl}: " . $e->getMessage());
                                        }
                                        $productosEncontrados[] = [
                                            'categoria_principal' => $categoryName,
                                            'subcategoria_grupo' => $subCategoryName,
                                            'subcategoria' => $subcategoriaName,
                                            'subcategoria_url' => $categoryUrl,
                                            'titulo' => $title,
                                            'articulo_codigo' => $articleCode,
                                            'precio' => $price,
                                            'producto_url' => $fullProductUrl,
                                            'imagen_url' => $imageUrl,
                                            'producto_id' => $productId,
                                            'agotado' => $isOutOfStock,
                                            'tiene_opciones' => $hasOptions,
                                            'descripcion_html' => $descripcionHtml,
                                            'tiene_descripcion' => $tieneDescripcion,
                                            'caracteristicas' => $caracteristicas,
                                            'medidas' => $medidas,
                                            'sku' => $sku,
                                            'stock' => $stock
                                        ];
                                        $Negativo = "No";
                                        $marca = Productos_marcas::where('codigo_prma', 'PLMA15skNEwqK2uXFVPa')->first()->id; // BGS
                                        if(!$marca){ return redirect()->back()->with('danger', '¡Revise la marca que se encuentre registrada!');}
                                        $categorias = Productos_categorias::where('nombre_prca', $subCategoryName)->first();
                                        if(!$categorias){
                                            $permitted_chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
                                            $tokenCategoria = "PLCA" . substr(str_shuffle($permitted_chars), 0, 16);
                                            $categoriaNueva = new Productos_categorias();
                                            $categoriaNueva->codigo_prca = $tokenCategoria;
                                            $categoriaNueva->nombre_prca = $subCategoryName;
                                            $categoriaNueva->estatus_prca = 'Activo';
                                            $categoriaNueva->save();
                                        }
                                        $categorias = Productos_categorias::where('nombre_prca', $subCategoryName)->first();
                                        $subcategorias = Productos_subcategorias::where('nombre_prsu', $subcategoriaName)->first();
                                        if(!$subcategorias){
                                            $permitted_chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
                                            $tokenSubCategoria = "PLCA" . substr(str_shuffle($permitted_chars), 0, 16);
                                            $categoriaNueva = new Productos_subcategorias();
                                            $categoriaNueva->codigo_prsu = $tokenSubCategoria;
                                            $categoriaNueva->nombre_prsu = $subcategoriaName;
                                            $categoriaNueva->estatus_prsu = 'Activo';
                                            $categoriaNueva->save();
                                        }
                                        $subcategorias = Productos_subcategorias::where('nombre_prsu', $subcategoriaName)->first();
                                        $caracteres = Array("$",","," ");
                                        $productos = Productos::where('codigo_prod', $productId)->first();
                                        if(!$productos){
                                            $producto = new Productos();
                                            $producto->codigo_prod = $productId;
                                            $producto->sku_prod = $sku;
                                            $producto->nombre_prod = $title;
                                            $producto->descripcion_corta_prod = $descripcionHtml;
                                            $producto->venta_prod = str_replace($caracteres,"",$price);
                                            $producto->stock_prod = $stock;
                                            $producto->marca_prod = $marca;
                                            $producto->categoria_prod = $categorias->id;
                                            $producto->subcategoria_prod = $subcategorias->id;
                                            $producto->linea_prod = $Negativo;
                                            $producto->ofertas_prod = $Negativo;
                                            $producto->nuevo_prod = $Negativo;
                                            $producto->estatus_prod = 'Activo';
                                            $producto->save();
                                        }else{
                                            $producto = Productos::where('codigo_prod', $productId)->first();
                                            $producto->sku_prod = $sku;
                                            $producto->nombre_prod = $title;
                                            $producto->descripcion_corta_prod = $descripcionHtml;
                                            $producto->venta_prod = str_replace($caracteres,"",$price);
                                            $producto->stock_prod = $stock;
                                            $producto->marca_prod = $marca;
                                            $producto->categoria_prod = $categorias->id;
                                            $producto->subcategoria_prod = $subcategorias->id;
                                            $producto->save();
                                        }
                                        $response = Http::timeout(30)->get($imageUrl);
                                        $imagenContenido = $response->body();
                                        $nombreArchivo =  $productId . ".jpg";
                                        $rutaDirectorio = public_path("assets/img/productos/");
                                        // Crear el directorio si no existe
                                        if (!is_dir($rutaDirectorio)) {
                                            if (!mkdir($rutaDirectorio, 0777, true)) {
                                                throw new Exception("No se pudo crear el directorio: $rutaDirectorio");
                                            }
                                        }
                                        // Guardar la imagen en el sistema
                                        $ruta = $rutaDirectorio . '/' . $nombreArchivo;
                                        if (!file_put_contents($ruta, $imagenContenido)) {
                                            throw new Exception("No se pudo guardar la imagen en: $ruta");
                                        }
                                        $imgProducto = Productos::where('codigo_prod', $productId)->first();
                                        $imgProducto->imagen_principal_prod = $nombreArchivo;
                                        $imgProducto->save();
                                        $productosEnPagina++;
                                        $productosTotales++;
                                    } catch (\Exception $e) {
                                        Log::error("Error al procesar producto en {$subcategoriaName}: " . $e->getMessage());
                                    }
                                });
                                // Verificar si hay más páginas
                                $nextPage = null;
                                $nextLink = $crawlerListProd->filter('div.page_c a.next');
                                if ($nextLink->count() > 0) {
                                    $pageNum++;
                                    // Solo para evitar bucles infinitos, limitamos a 20 páginas por categoría
                                    if ($pageNum > 20) {
                                        $procesarPaginas = false;
                                    }
                                } else {
                                    $procesarPaginas = false;
                                }
                                // Si no se encontraron productos en esta página, terminar
                                if ($productosEnPagina == 0) {
                                    $procesarPaginas = false;
                                }
                                // Pequeña pausa para no sobrecargar el servidor
                                if ($procesarPaginas) {
                                    sleep(1);
                                }
                            }
                        } catch (\Exception $e) {
                            Log::error("Error al procesar categoría {$subcategoriaName}: " . $e->getMessage());
                        }
                    });
                }
            });
        });
    }
}
