<?php

namespace App\Http\Controllers;

use App\Models\Productos;
use Illuminate\Http\Request;
use App\Models\Productos_marcas;
use Illuminate\Support\Facades\Validator;

class ProductosMarcasController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    public function index()
    {
        $carts = session()->get('cart', []);
        $cart = array_slice($carts, 0, 4);
        $favoritos = session()->get('favoritos', []);
        $favoritos = array_slice($favoritos, 0, 4);
        if($cart){ $totalProducts = count($cart); }else{ $totalProducts = ""; }
        if($favoritos){ $totalFavoritos = count($favoritos); }else{ $totalFavoritos = ""; }
        $datos = Productos_marcas::where('estatus_prma', '<>', 'Eliminado')->get();
        return view('marcas/index', compact('datos', 'totalProducts', 'cart', 'favoritos', 'totalFavoritos'));
    }
    public function store(Request $request)
    {
        $permitted_chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $token = "PLCA" . substr(str_shuffle($permitted_chars), 0, 16);
        $rules = [
            'nombre' => 'required|string|max:255',
        ];
        $validator = Validator::make($request->all(), $rules);
        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }
        $datos = new Productos_marcas();
        $datos->codigo_prma = $token;
        $datos->nombre_prma = $request->post('nombre');
        $datos->estatus_prma = 'Activo';
        $datos->save();
        return redirect()->back()->with('success', '¡Registrado existosamente!');
    }
    public function update(Request $request, Productos_marcas $productos_marcas, $id)
    {
        $datos = Productos_marcas::where('codigo_prma', $id)->first();
        $datos->nombre_prma = $request->post('nombre');
        $datos->save();
        return redirect()->back()->with('success', '¡Actualizado existosamente!');
    }
    public function activate(Request $request, $id)
    {
        $datos = Productos_marcas::where('codigo_prma', $id)->first();
        $datos->estatus_prma = 'Activo';
        $datos->save();
        return redirect()->back()->with('success', '¡Activado existosamente!');
    }
    public function inactivate(Request $request, $id)
    {
        $datos = Productos_marcas::where('codigo_prma', $id)->first();
        $datos->estatus_prma = 'Inactivo';
        $datos->save();
        return redirect()->back()->with('success', '¡Inactivado existosamente!');
    }
    public function delete(Request $request, $id)
    {
        $datos = Productos_marcas::where('codigo_prma', $id)->first();
        $datos->estatus_prma = 'Eliminado';
        $datos->save();
        return redirect()->back()->with('success', '¡Eliminado existosamente!');
    }
}
