<?php

namespace App\Http\Controllers;

use App\Models\Productos_subcategorias;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class ProductosSubcategoriasController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    public function index()
    {
        $carts = session()->get('cart', []);
        $cart = array_slice($carts, 0, 4);
        $favoritos = session()->get('favoritos', []);
        $favoritos = array_slice($favoritos, 0, 4);
        if($cart){ $totalProducts = count($cart); }else{ $totalProducts = ""; }
        if($favoritos){ $totalFavoritos = count($favoritos); }else{ $totalFavoritos = ""; }
        $datos = Productos_subcategorias::where('estatus_prsu', '<>', 'Eliminado')->get();
        return view('subcategorias/index', compact('datos', 'totalProducts', 'cart', 'favoritos', 'totalFavoritos'));
    }
    public function store(Request $request)
    {
        $permitted_chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $token = "PLSU" . substr(str_shuffle($permitted_chars), 0, 16);
        $rules = ['nombre' => 'required|string|max:255'];
        $validator = Validator::make($request->all(), $rules);
        if ($validator->fails()) { return redirect()->back()->withErrors($validator)->withInput();}
        $datos = new Productos_subcategorias();
        $datos->codigo_prsu = $token;
        $datos->nombre_prsu = $request->post('nombre');
        $datos->estatus_prsu = 'Activo';
        $datos->save();
        return redirect()->back()->with('success', '¡Registrado existosamente!');
    }
    public function update(Request $request, Productos_subcategorias $productos_subcategorias, $id)
    {
        $datos = Productos_subcategorias::where('codigo_prsu', $id)->first();
        $datos->nombre_prsu = $request->post('nombre');
        $datos->save();
        return redirect()->back()->with('success', '¡Actualizado existosamente!');
    }
    public function activate(Request $request, $id)
    {
        $datos = Productos_subcategorias::where('codigo_prsu', $id)->first();
        $datos->estatus_prsu = 'Activo';
        $datos->save();
        return redirect()->back()->with('success', '¡Activado existosamente!');
    }
    public function inactivate(Request $request, $id)
    {
        $datos = Productos_subcategorias::where('codigo_prsu', $id)->first();
        $datos->estatus_prsu = 'Inactivo';
        $datos->save();
        return redirect()->back()->with('success', '¡Inactivado existosamente!');
    }
    public function delete(Request $request, $id)
    {
        $datos = Productos_subcategorias::where('codigo_prsu', $id)->first();
        $datos->estatus_prsu = 'Eliminado';
        $datos->save();
        return redirect()->back()->with('success', '¡Eliminado existosamente!');
    }
}
