<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
class RolesController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    public function index()
    {
        $carts = session()->get('cart', []);
        $cart = array_slice($carts, 0, 4);
        $favoritos = session()->get('favoritos', []);
        $favoritos = array_slice($favoritos, 0, 4);
        if($cart){ $totalProducts = count($cart); }else{ $totalProducts = ""; }
        if($favoritos){ $totalFavoritos = count($favoritos); }else{ $totalFavoritos = ""; }
        $roles = Role::all();
        $permissions = Permission::orderBy('name', 'asc')->get();
        $datos = Role::orderBy('name', 'asc')->with(['permissions' => function ($query) {
                $query->orderBy('name', 'asc');
        }])->get();
        return view('roles/index', compact('datos', 'permissions', 'roles', 'totalProducts', 'cart', 'favoritos', 'totalFavoritos'));
    }
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|unique:roles,name',
            'permissions' => 'required|array',
        ]);
        $role = Role::create(['name' => $request->name]);
        $role->syncPermissions($request->permissions);
        return redirect()->route('roles.index')->with('success', '¡Agregado exitosamente!');
    }
    public function update(Request $request, Role $role)
    {
        $request->validate([
            'permissions' => 'array',
        ]);
        $role->syncPermissions($request->permissions);
        return redirect()->route('roles.index')->with('success', '¡Actualizado exitosamente!');
    }
}
