<?php

namespace App\Http\Controllers;

use App\Models\Suscritos;
use Illuminate\Http\Request;

class SuscritosController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    public function index()
    {
        $carts = session()->get('cart', []);
        $cart = array_slice($carts, 0, 4);
        $favoritos = session()->get('favoritos', []);
        $favoritos = array_slice($favoritos, 0, 4);
        if($cart){ $totalProducts = count($cart); }else{ $totalProducts = ""; }
        if($favoritos){ $totalFavoritos = count($favoritos); }else{ $totalFavoritos = ""; }
        $datos = Suscritos::where('estatus_susc', '<>', 'Eliminado')->get();
        return view('suscripciones/index', compact('datos', 'totalProducts', 'cart', 'totalFavoritos', 'favoritos'));
    }
}
