<?php
namespace App\Http\Controllers;
use App\Models\User;
use App\Models\Banners;
use App\Models\Compras;
use App\Models\Cupones;
use App\Models\Eventos;
use App\Models\Pedidos;
use App\Models\Clientes;
use App\Models\Productos;
use App\Models\Suscritos;
use App\Models\Direcciones;
use Illuminate\Http\Request;
use App\Mail\envioAvisoCompra;
use App\Models\Calificaciones;
use App\Models\Datos_empresas;
use App\Models\Eventos_ventas;
use Illuminate\Support\Carbon;
use App\Models\Eventos_boletos;
use App\Models\Productos_marcas;
use App\Mail\envioCorreoContacto;
use App\Models\Correos_contactos;
use App\Models\Estados_republica;
use App\Models\Productos_colores;
use App\Mail\envioComprobantePago;
use App\Models\Pagos_comprobantes;
use App\Models\Productos_imagenes;
use Illuminate\Support\Facades\DB;
use MercadoPago\MercadoPagoConfig;
use MercadoPago\Client\Payment\PaymentClient;
use Spatie\Permission\Models\Role;
use Illuminate\Support\Facades\Log;
use App\Models\Productos_categorias;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Mail;
use App\Mail\envioAvisoCompraBoletos;
use App\Mail\envioCorreoCompraBoleto;
use App\Models\Productos_subcategorias;
use Illuminate\Support\Facades\Validator;
use Barryvdh\DomPDF\Facade\Pdf as FacadePdf;
use MercadoPago\Client\Preference\PreferenceClient;
use Endroid\QrCode\QrCode;
use Endroid\QrCode\Writer\PngWriter;

class TiendaController extends Controller
{
    public function index()
    {
        $cart = session()->get('cart');
        $cupon = session()->get('cupon');
        $favoritos = session()->get('favoritos');
        if($cupon){ $datosCupon  = Cupones::where('codigo_cupo', $cupon)->first(); }else{ $datosCupon = ""; }
        if($cart){ $totalProducts = count($cart); }else{ $totalProducts = ""; }
        if($favoritos){ $totalFavoritos = count($favoritos); }else{ $totalFavoritos = ""; }
        $productosOfertas =  Productos::select('productos.imagen_principal_prod', 'productos.codigo_prod', 'productos.nombre_prod', 'venta_prod')
        ->where('estatus_prod', '=', 'Activo')
        ->where('ofertas_prod', '=', 'Si')
        ->groupBy('productos.id', 'productos.imagen_principal_prod', 'productos.codigo_prod', 'productos.nombre_prod', 'venta_prod')->take(6)
        ->get();
        $productosNuevos =  Productos::select('productos.imagen_principal_prod', 'productos.codigo_prod', 'productos.nombre_prod', 'venta_prod')
        ->where('estatus_prod', '=', 'Activo')
        ->where('nuevo_prod', '=', 'Si')
        ->groupBy('productos.id', 'productos.imagen_principal_prod', 'productos.codigo_prod', 'productos.nombre_prod', 'venta_prod')->take(6)
        ->get();
        $categorias = Productos_categorias::select('codigo_prca', 'nombre_prca', 'imagen_prca', DB::raw('COUNT(productos.id) as total_productos'))
        ->leftjoin('productos', 'productos.categoria_prod', '=', 'productos_categorias.id')
        ->where('estatus_prod', '=', 'Activo')
        ->where('productos_categorias.estatus_prca', '=', 'Activo')
        ->groupBy('codigo_prca', 'nombre_prca', 'imagen_prca')
        ->get();
        $subcategorias =  Productos_subcategorias::select('codigo_prsu', 'nombre_prsu')->join('productos', 'productos.subcategoria_prod', '=', 'productos_subcategorias.id')
        ->where('estatus_prod', '=', 'Activo')->where('estatus_prsu', '=', 'Activo')->groupBy('codigo_prsu', 'nombre_prsu')->get();
        $banners = Banners::get();
        return view('tienda.index', compact('categorias' ,'subcategorias', 'productosOfertas', 'productosNuevos', 'totalProducts', 'cart', 'datosCupon', 'totalFavoritos', 'banners'));
    }
    public function empresa()
    {
        $data = Datos_empresas::first();
        return response()->json($data);
    }
    public function catalogo(Request $request)
    {
        $cart = session()->get('cart');
        $cupon = session()->get('cupon');
        $favoritos = session()->get('favoritos');
        if($cupon){ $datosCupon  = Cupones::where('codigo_cupo', $cupon)->first(); }else{ $datosCupon = ""; }
        if($cart){ $totalProducts = count($cart); }else{ $totalProducts = ""; }
        if($favoritos){ $totalFavoritos = count($favoritos); }else{ $totalFavoritos = ""; }
        $categorias = Productos_categorias::select('codigo_prca', 'nombre_prca', 'imagen_prca', DB::raw('COUNT(productos.id) as total_productos'))
        ->join('productos', 'productos.categoria_prod', '=', 'productos_categorias.id')
        ->where('productos.estatus_prod', '=', 'Activo')->where('productos.linea_prod', '=', 'Si')
        ->where('productos_categorias.estatus_prca', '=', 'Activo')
        ->groupBy('codigo_prca', 'nombre_prca', 'imagen_prca')
        ->orderBy('nombre_prca', 'asc')
        ->get();
        $subcategorias = Productos_subcategorias::select('codigo_prsu', 'nombre_prsu', DB::raw('COUNT(productos.id) as total_productos'))
        ->join('productos', 'productos.subcategoria_prod', '=', 'productos_subcategorias.id')
        ->where('productos.estatus_prod', '=', 'Activo')->where('productos.linea_prod', '=', 'Si')
        ->where('productos_subcategorias.estatus_prsu', '=', 'Activo')
        ->groupBy('codigo_prsu', 'nombre_prsu')
        ->orderBy('nombre_prsu', 'asc')
        ->get();
        $productos = Productos::select('productos.imagen_principal_prod', 'productos.codigo_prod', 'productos.nombre_prod', 'venta_prod')
        ->where('productos.estatus_prod', '=', 'Activo')->where('productos.linea_prod', '=', 'Si')
        ->groupBy('productos.id', 'productos.imagen_principal_prod', 'productos.codigo_prod', 'productos.nombre_prod', 'venta_prod')
        ->paginate(12);
        $marcas = Productos::select('codigo_prma', 'nombre_prma', DB::raw('COUNT(productos.id) as total_productos'))
        ->join('productos_marcas', 'productos_marcas.id', '=', 'productos.marca_prod')
        ->where('productos.estatus_prod', '=', 'Activo')->where('productos.linea_prod', '=', 'Si')
        ->where('productos_marcas.estatus_prma', '=', 'Activo')
        ->groupBy('codigo_prma', 'nombre_prma')
        ->orderBy('nombre_prma', 'asc')
        ->get();
        $categoria = "";
        $subcategoria = "";
        $marca = "";
        $precio_min = "";
        $precio_max = "";
        $buscar = "";
        return view('tienda/tiendas', ['categoriaSelecconado'=>$categoria, 'subcategoriaSelecconado'=>$subcategoria, 'marcaSelecconado'=>$marca,
        'buscar'=>$buscar, 'precio_minSeleccionado'=>$precio_min, 'precio_maxSeleccionado'=>$precio_max], compact('categorias' ,'subcategorias', 'productos', 'totalProducts',
        'cart', 'datosCupon', 'totalFavoritos', 'marcas'));
    }
    public function filtro(Request $request){
        $cart = session()->get('cart');
        $cupon = session()->get('cupon');
        $favoritos = session()->get('favoritos');
        if($cupon){ $datosCupon  = Cupones::where('codigo_cupo', $cupon)->first(); }else{ $datosCupon = ""; }
        if($cart){ $totalProducts = count($cart); }else{ $totalProducts = ""; }
        if($favoritos){ $totalFavoritos = count($favoritos); }else{ $totalFavoritos = ""; }
        $categorias = Productos_categorias::select('codigo_prca', 'nombre_prca', 'imagen_prca', DB::raw('COUNT(productos.id) as total_productos'))
        ->join('productos', 'productos.categoria_prod', '=', 'productos_categorias.id')
        ->where('productos.estatus_prod', '=', 'Activo')->where('productos.linea_prod', '=', 'Si')
        ->where('productos_categorias.estatus_prca', '=', 'Activo')
        ->groupBy('codigo_prca', 'nombre_prca', 'imagen_prca')
        ->orderBy('nombre_prca', 'asc')
        ->get();
        $subcategorias = Productos_subcategorias::select('codigo_prsu', 'nombre_prsu', DB::raw('COUNT(productos.id) as total_productos'))
        ->join('productos', 'productos.subcategoria_prod', '=', 'productos_subcategorias.id')
        ->where('productos.estatus_prod', '=', 'Activo')->where('productos.linea_prod', '=', 'Si')
        ->where('productos_subcategorias.estatus_prsu', '=', 'Activo')
        ->groupBy('codigo_prsu', 'nombre_prsu')
        ->orderBy('nombre_prsu', 'asc')
        ->get();
        $marcas = Productos::select('codigo_prma', 'nombre_prma', DB::raw('COUNT(productos.id) as total_productos'))
        ->join('productos_marcas', 'productos_marcas.id', '=', 'productos.marca_prod')
        ->where('productos.estatus_prod', '=', 'Activo')->where('productos.linea_prod', '=', 'Si')
        ->where('productos_marcas.estatus_prma', '=', 'Activo')
        ->groupBy('codigo_prma', 'nombre_prma')
        ->orderBy('nombre_prma', 'asc')
        ->get();
        $rules = [ 'precio_min' => ['nullable', 'numeric'], 'precio_max' => ['nullable', 'numeric'], 'buscar' => ['nullable', 'string']];
        $messages = [
            'precio_min.string' => 'El precio minimo contiene caracteres desconocidos.',
            'precio_max.string' => 'El precio maximo  contiene caracteres desconocidos.',
            'buscar.string' => 'El buscador contiene caracteres desconocidos.',
        ];
        $validator = Validator::make($request->all(), $rules, $messages);
        if ($validator->fails()) {$errors = $validator->errors()->all(); return redirect()->back()->with('danger', implode(', ', $errors)); }
        $sanitizedData = $validator->validated();
        $precio_min = $request->has('precio_min') ? $sanitizedData['precio_min'] : null;
        $precio_max = $request->has('precio_max') ? $sanitizedData['precio_max'] : null;
        $buscar = $request->has('buscar') ? $sanitizedData['buscar'] : null;
        $categoria = $request->input('categoria');
        $subcategoria = $request->input('subcategoria');
        $marca = $request->input('marca');
        $productos = DB::table("productos")
            ->select('productos.imagen_principal_prod', 'productos.codigo_prod', 'productos.nombre_prod', 'venta_prod')
            ->join('productos_categorias', 'productos_categorias.id', '=', 'productos.categoria_prod')
            ->join('productos_subcategorias', 'productos_subcategorias.id', '=', 'productos.subcategoria_prod')
            ->join('productos_marcas', 'productos_marcas.id', '=', 'productos.marca_prod')
            ->where('estatus_prod', '=', 'Activo')->where('productos.linea_prod', '=', 'Si');
        if (is_array($marca) && count($marca) > 0) {
            $productos->whereIn('codigo_prma', $marca);
        }
        if (is_array($categoria) && count($categoria) > 0) {
            $productos->whereIn('codigo_prca', $categoria);
        }
        if (is_array($subcategoria) && count($subcategoria) > 0) {
            $productos->whereIn('codigo_prsu', $subcategoria);
        }
        $productos->when($precio_min != "", function ($query) use ($precio_min) {
            return $query->where('venta_prod', '>=', $precio_min);
        });
        $productos->when($precio_max != "", function ($query) use ($precio_max) {
            return $query->where('venta_prod', '<=', $precio_max);
        });
        $productos->when($buscar != "", function ($query) use ($buscar) {
            $buscarMinusculas = strtolower($buscar);
            return $query->where(function ($query) use ($buscarMinusculas) {
                $query->whereRaw('LOWER(nombre_prod) LIKE ?', ['%' . $buscarMinusculas . '%'])
                    ->orWhereRaw('LOWER(sku_prod) LIKE ?', ['%' . $buscarMinusculas . '%']);
            });
        });
        $productos = $productos->groupBy('productos.id', 'productos.imagen_principal_prod', 'productos.codigo_prod', 'productos.nombre_prod', 'venta_prod');
        $orden = $request->input('period', 'asc');
        // dd($orden); // Descomentar esta línea para depurar el valor de $orden
        // Aplicar ordenamiento según la selección del usuario
        switch ($orden) {
            case 'asc':
                $productos->orderBy('nombre_prod', 'asc');
                break;
            case 'desc':
                $productos->orderBy('nombre_prod', 'desc');
                break;
            case 'mayorPrecio':
                $productos->orderBy('venta_prod', 'desc');
                break;
            case 'menorPrecio':
                $productos->orderBy('venta_prod', 'asc');
                break;
            default:
                $productos->orderBy('nombre_prod', 'asc');
                break;
        }
        $productos = $productos->paginate(12);
        //dd($productos);
        return view('tienda/tiendas', ['categoriaSelecconado'=>$categoria, 'subcategoriaSelecconado'=>$subcategoria, 'marcaSelecconado'=>$marca,
        'buscar'=>$buscar, 'precio_minSeleccionado'=>$precio_min, 'precio_maxSeleccionado'=>$precio_max], compact('categorias' ,'subcategorias', 'productos', 'totalProducts',
        'cart', 'datosCupon', 'totalFavoritos', 'marcas'));
    }
    public function detalleProducto($id)
    {
        $cart = session()->get('cart');
        $cupon = session()->get('cupon');
        $favoritos = session()->get('favoritos');
        if($cupon){ $datosCupon  = Cupones::where('codigo_cupo', $cupon)->first(); }else{ $datosCupon = ""; }
        if($cart){ $totalProducts = count($cart); }else{ $totalProducts = ""; }
        if($favoritos){ $totalFavoritos = count($favoritos); }else{ $totalFavoritos = ""; }
        $producto =Productos::select('categoria_prod', 'productos.id as idProducto', 'imagen_principal_prod', 'codigo_prod', 'nombre_prod','descripcion_corta_prod', 'descripcion_larga_prod', 'venta_prod')
        ->where('productos.estatus_prod', '=', 'Activo')->where('codigo_prod', '=', $id)->first();
        $colores = Productos_colores::where('estatus_prco', '=', 'Activo')->where('producto_prco', '=', $producto->idProducto)->get();
        $coloresConteo = Productos_colores::where('estatus_prco', '=', 'Activo')->where('producto_prco', '=', $producto->idProducto)->count();
        $imagenes = Productos_imagenes::select('imagen_prim')->where('estatus_prim', '=', 'Activo')->where('producto_prim', '=', $producto->idProducto)->get();
        $imagenesConteo = Productos_imagenes::where('estatus_prim', '=', 'Activo')->where('producto_prim', '=', $producto->idProducto)->count();
        $categorias = Productos_categorias::select('codigo_prca', 'nombre_prca', 'imagen_prca', DB::raw('COUNT(productos.id) as total_productos'))
        ->join('productos', 'productos.categoria_prod', '=', 'productos_categorias.id')
        ->where('productos.estatus_prod', '=', 'Activo')
        ->where('productos_categorias.estatus_prca', '=', 'Activo')
        ->groupBy('codigo_prca', 'nombre_prca', 'imagen_prca')
        ->orderBy('nombre_prca', 'asc')
        ->get();
        $subcategorias = Productos_subcategorias::select('codigo_prsu', 'nombre_prsu', DB::raw('COUNT(productos.id) as total_productos'))
        ->join('productos', 'productos.subcategoria_prod', '=', 'productos_subcategorias.id')
        ->where('productos.estatus_prod', '=', 'Activo')
        ->where('productos_subcategorias.estatus_prsu', '=', 'Activo')
        ->groupBy('codigo_prsu', 'nombre_prsu')
        ->orderBy('nombre_prsu', 'asc')
        ->get();
        $productosSimilares = Productos::select('productos.id as idProducto', 'productos.imagen_principal_prod', 'productos.codigo_prod', 'productos.nombre_prod')
        ->groupBy('productos.id', 'productos.imagen_principal_prod', 'productos.codigo_prod', 'productos.nombre_prod')
        ->where('productos.linea_prod', '=', 'Si')
        ->where('productos.estatus_prod', '=', 'Activo')
        ->where('productos.id', '<>', $producto->idProducto)
        ->where('productos.categoria_prod', '=', $producto->categoria_prod)->take(10)
        ->get();
        $comentarios = Calificaciones::select('codigo_calif', 'name', 'calificacion_calif', 'resena_calif', 'fecha_calif', 'estatus_calif')->join('users', 'users.id', '=', 'usuario_calif')->where('estatus_calif', 'Aprobado')->where('producto_calif', '=', $producto->idProducto)->orderBy('calificaciones.id', 'desc')->take(10)->get();
        $comentariosConteo = Calificaciones::where('estatus_calif', 'Aprobado')->where('producto_calif', '=', $producto->idProducto)->count();
        return view('tienda.detalle_producto', compact('producto', 'colores', 'coloresConteo','imagenes', 'productosSimilares', 'imagenesConteo','categorias' ,'subcategorias', 'totalProducts', 'cart', 'datosCupon', 'totalFavoritos', 'comentarios', 'comentariosConteo'));
    }
    public function carrito()
    {
        $cart = session()->get('cart');
        $cupon = session()->get('cupon');
        $favoritos = session()->get('favoritos');
        if($cupon){ $datosCupon  = Cupones::where('codigo_cupo', $cupon)->first(); }else{ $datosCupon = ""; }
        if($cart){ $totalProducts = count($cart); }else{ $totalProducts = ""; }
        if($favoritos){ $totalFavoritos = count($favoritos); }else{ $totalFavoritos = ""; }
        $categorias = Productos_categorias::select('codigo_prca', 'nombre_prca', 'imagen_prca', DB::raw('COUNT(productos.id) as total_productos'))
        ->join('productos', 'productos.categoria_prod', '=', 'productos_categorias.id')
        ->where('productos.estatus_prod', '=', 'Activo')
        ->where('productos_categorias.estatus_prca', '=', 'Activo')
        ->groupBy('codigo_prca', 'nombre_prca', 'imagen_prca')
        ->orderBy('nombre_prca', 'asc')
        ->get();
        $subcategorias = Productos_subcategorias::select('codigo_prsu', 'nombre_prsu', DB::raw('COUNT(productos.id) as total_productos'))
        ->join('productos', 'productos.subcategoria_prod', '=', 'productos_subcategorias.id')
        ->where('productos.estatus_prod', '=', 'Activo')
        ->where('productos_subcategorias.estatus_prsu', '=', 'Activo')
        ->groupBy('codigo_prsu', 'nombre_prsu')
        ->orderBy('nombre_prsu', 'asc')
        ->get();
        $empresas = Datos_empresas::first();
        return view('tienda.carrito', compact('totalProducts', 'cart', 'datosCupon', 'totalFavoritos','categorias' ,'subcategorias' ,'empresas'));
    }
    public function agregarCarrito(Request $request, $id)
    {
        $rules = [
            'color' => 'nullable|string',
            'cantidad' => 'required|numeric',
        ];
        $validator = Validator::make($request->all(), $rules);
        if ($validator->fails()) { $errors = $validator->errors()->all(); return redirect()->back()->with('danger', implode(', ', $errors)); }
        $sanitizedData = $validator->validated();
        $producto =Productos::select('categoria_prod', 'subcategoria_prod', 'productos.id as idProducto', 'imagen_principal_prod', 'codigo_prod', 'nombre_prod', 'descripcion_corta_prod', 'descripcion_larga_prod', 'venta_prod', 'nombre_prca', 'nombre_prsu')
        ->join('productos_categorias', 'productos_categorias.id', '=', 'productos.categoria_prod')
        ->join('productos_subcategorias', 'productos_subcategorias.id', '=', 'productos.subcategoria_prod')
        ->where('productos.estatus_prod', '=', 'Activo')
        ->where('codigo_prod', '=', $id)->first();
        $colorSeleccionado = "";
        $color = $request->has('color') ? $sanitizedData['color'] : null;
        $cantidad = $request->has('cantidad') ? $sanitizedData['cantidad'] : null;
        if($color){
            $colores = Productos_colores::select('color_prco')->where('estatus_prco', '=', 'Activo')->where('codigo_prco', '=', $color)->first();
            $colorSeleccionado = $colores->color_prco;
        }
        $costo = $producto->venta_prod;
        $permitted_chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $tokIz = "TKIZ" . substr(str_shuffle($permitted_chars), 0, 16);
        $cart = session()->get('cart', []);
        $cart[$tokIz] = [
            'token' =>  $tokIz,
            'product' =>  $id,
            'idColor' =>  $color,
            'color' => $colorSeleccionado,
            'imagenProduct' => $producto->imagen_principal_prod,
            'nombreProduct' => $producto->nombre_prod,
            'descripcion' => $producto->descripcion_corta_prod,
            'idCategoria' => $producto->categoria_prod,
            'categoria' => $producto->nombre_prca,
            'idSubcategoria' => $producto->subcategoria_prod,
            'subcategoria' => $producto->nombre_prsu,
            'costo' => $costo,
            'cantidad' => $cantidad,
            'total' => $cantidad  * $costo,
        ];
        session()->put('cart', $cart);
        $cart = session()->get('cart');
        if($cart){ $totalProducts = count($cart); }else{ $totalProducts = ""; }
        session()->put('cart', $cart);
        return response()->json(['message' => 'Producto agregado al carrito correctamente', 'totaNuevo'=>$totalProducts, 'totalProds'=>$totalProducts] );
    }
    public function actualizarCarrito(Request $request, $id, $number)
    {
        $cart = session()->get('cart', []);
        if (isset($cart[$id])) {
            $cart[$id]['cantidad'] = $number;
            $cart[$id]['total'] = $number * $cart[$id]['costo'] ;
            session()->put('cart', $cart);
        }
        $nuevoSubtotal = 0;
        $nuevototal = 0;
        $cupon = session()->get('cupon');
        $nuevoDescuento = 0;
        if($cupon){
            $datosCupon  = Cupones::where('codigo_cupo', $cupon)->first();
            $descuento = $datosCupon->descuento_cupo;
            foreach ($cart as $item) { $nuevoSubtotal += $item['total']; }
            if ($datosCupon->tipo_cupo == 'Porcentaje'){
                $nuevototal = $nuevoSubtotal - ($nuevoSubtotal * ($descuento / 100 ));
                $nuevoDescuento = ($nuevoSubtotal * ($descuento / 100 ));
            }
            if ($datosCupon->tipo_cupo == 'Monetario'){
                $nuevototal = $nuevoSubtotal - $descuento;
                $nuevoDescuento = $descuento;
            }
        }else{ foreach ($cart as $item) { $nuevoSubtotal += $item['total']; $nuevototal += $item['total'];} }
        return response()->json(['subtotalProducto' => $number * $cart[$id]['costo'], 'nuevoDescuento'=>$nuevoDescuento,'nuevoSubtotal'=> $nuevoSubtotal, 'nuevototal'=> $nuevototal]);
    }
    public function eliminarCarrito(Request $request, $id)
    {
        $cart = session()->get('cart');
        unset($cart[$id]);
        session(['cart' => $cart]);
        $cart = session()->get('cart');
        if($cart){ $totalProducts = count($cart); }else{ $totalProducts = ""; }
        session()->flash('totalProducts', $totalProducts);
        return redirect()->back()->with('success', '¡Producto eliminado del carrito!');
    }
    public function favoritos(Request $request)
    {
        $cart = session()->get('cart');
        $cupon = session()->get('cupon');
        $favoritos = session()->get('favoritos');
        if($cupon){ $datosCupon  = Cupones::where('codigo_cupo', $cupon)->first(); }else{ $datosCupon = ""; }
        if($cart){ $totalProducts = count($cart); }else{ $totalProducts = ""; }
        if($favoritos){ $totalFavoritos = count($favoritos); }else{ $totalFavoritos = ""; }
        $categorias = Productos_categorias::select('codigo_prca', 'nombre_prca', 'imagen_prca', DB::raw('COUNT(productos.id) as total_productos'))
        ->join('productos', 'productos.categoria_prod', '=', 'productos_categorias.id')
        ->where('productos.estatus_prod', '=', 'Activo')
        ->where('productos_categorias.estatus_prca', '=', 'Activo')
        ->groupBy('codigo_prca', 'nombre_prca', 'imagen_prca')
        ->get();
        $subcategorias =  Productos_subcategorias::select('codigo_prsu', 'nombre_prsu')->join('productos', 'productos.subcategoria_prod', '=', 'productos_subcategorias.id')
        ->where('estatus_prod', '=', 'Activo')->where('estatus_prsu', '=', 'Activo')->groupBy('codigo_prsu', 'nombre_prsu')->get();
        return view('tienda.favoritos', compact('totalProducts', 'datosCupon', 'totalFavoritos', 'favoritos', 'categorias', 'subcategorias'));
    }
    public function agregarFavoritos(Request $request, $id)
    {
        $producto = Productos::select('*', 'productos.id as idProducto')
        ->join('productos_categorias', 'productos_categorias.id', '=', 'productos.categoria_prod')
        ->join('productos_subcategorias', 'productos_subcategorias.id', '=', 'productos.subcategoria_prod')
        ->where('codigo_prod', '=', $id)->first();
        $favoritos = session()->get('favoritos', []);
        $permitted_chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $token = "TKNFAV" . substr(str_shuffle($permitted_chars), 0, 16);
        $favoritos[$token] = [ 'token' =>  $token, 'product' =>  $id,
        'nombre' =>  $producto->nombre_prod, 'imagen' =>  $producto->imagen_principal_prod, 'sku' =>  $producto->sku_prod,
        'categoria' =>  $producto->nombre_prca,
        'subcategoria' =>  $producto->nombre_prsu
        ];
        session()->put('favoritos', $favoritos);
        return redirect()->back()->with('success', '¡Producto agregado a favoritos!');
    }
    public function eliminarFavoritos(Request $request, $id)
    {
        $favoritos = session()->get('favoritos');
        unset($favoritos[$id]);
        session(['favoritos' => $favoritos]);
        $favoritos = session()->get('favoritos');
        if($favoritos){ $totalFavoritos = count($favoritos); }else{ $totalFavoritos = 0; }
        session()->flash('totalFavoritos', $totalFavoritos);
        return redirect()->back()->with('success', '¡Producto eliminado del carrito!');
    }
    public function cupon(Request $request)
    {
        $rules = ['cupon' => 'required|string'];
        $messages = ['cupon.string' => 'El cupón contiene caracteres desconocidos.', 'cupon.required' => 'El cupón es obligatorio.'];
        $validator = Validator::make($request->all(), $rules, $messages);
        if ($validator->fails()) { $errors = $validator->errors()->all(); return redirect()->back()->with('danger', implode(', ', $errors));}
        $sanitizedData = $validator->validated();
        $cupon = $sanitizedData['cupon'];
        $cuponBuscar  = Cupones::where('codigo_cupo', $cupon)->first();
        if ($cuponBuscar) {
            $fechaHoy = Carbon::now()->toDateString();
            $cuponValido = DB::table('cupones')
            ->where('codigo_cupo', $cupon)
            ->where('estatus_cupo', 'Activo')
            ->whereDate('fecha_inicio_cupo', '<=', $fechaHoy)
            ->whereDate('fecha_vencimiento_cupo', '>=', $fechaHoy)
            ->exists();
            if ($cuponValido) {
                session(['cupon' => $cupon]);
                return redirect()->back()->with('success', '¡Cupón aplicado exitosamente!');
            }else{ return redirect()->back()->with('warning', '¡Cupón no es válido para hoy!'); }
        } else { return redirect()->back()->with('warning', '¡Cupón no encontrado!'); }
    }
    public function procesar()
    {
        $cart = session()->get('cart');
        if($cart){ $totalProducts = count($cart); }else{ $totalProducts = ""; }
        $cupon = session()->get('cupon');
        $favoritos = session()->get('favoritos');
        if($favoritos){ $totalFavoritos = count($favoritos); }else{ $totalFavoritos = ""; }
        if($cupon){
            $datosCupon  = Cupones::where('codigo_cupo', $cupon)->first();
            $descuento = $datosCupon->descuento_cupo;
        }else{ $datosCupon = ""; }
        $estadosRepublica = Estados_republica::get();
        $empresas = Datos_empresas::first();
        $categorias = Productos_categorias::select('codigo_prca', 'nombre_prca', 'imagen_prca', DB::raw('COUNT(productos.id) as total_productos'))
        ->join('productos', 'productos.categoria_prod', '=', 'productos_categorias.id')
        ->where('productos.estatus_prod', '=', 'Activo')
        ->where('productos_categorias.estatus_prca', '=', 'Activo')
        ->groupBy('codigo_prca', 'nombre_prca', 'imagen_prca')
        ->get();
        $subcategorias =  Productos_subcategorias::select('codigo_prsu', 'nombre_prsu')->join('productos', 'productos.subcategoria_prod', '=', 'productos_subcategorias.id')
        ->where('estatus_prod', '=', 'Activo')->where('estatus_prsu', '=', 'Activo')->groupBy('codigo_prsu', 'nombre_prsu')->get();
        if(Auth::check()){
            $direcciones = Direcciones::join('estados_republica','estados_republica.id', '=', 'direcciones.estado_dire')->where('usuario_dire', '=', Auth::user()->id)->where('estatus_dire', '=', "Activo")->take(4)->orderby('estados_republica.id', 'desc')->get();
            $usuario = Clientes::select('codigo_clie','telefono_clie','pais_clie','ciudad_clie','estado_clie','direccion_clie','codigo_postal_clie','nombre_facturacion_clie', 'referencia_clie',
            'rfc_facturacion_clie','codigo_postal_facturacion_clie','name as nombre_cliente','email', 'estadoCliente.nombre_edo as nombreEstado', 'uso_facturacion_clie', 'regimen_facturacion_clie' )
            ->join('users', 'users.id', '=', 'clientes.usuario_clie')
            ->leftjoin('estados_republica as estadoCliente', 'estadoCliente.id', '=', 'clientes.estado_clie' )
            ->where('users.id', '=', Auth::user()->id)->first();
            return view('tienda.procesarCompra', compact('totalProducts', 'cart', 'cupon', 'estadosRepublica', 'usuario', 'datosCupon', 'direcciones', 'empresas','favoritos' ,'totalFavoritos','categorias' ,'subcategorias'));
        }else{
            return view('tienda.procesarCompra', compact('totalProducts', 'cart', 'cupon', 'estadosRepublica', 'datosCupon', 'empresas','favoritos' ,'totalFavoritos','categorias' ,'subcategorias'));
        }
    }
    public function suscribir(Request $request){
        $rules = ['email' => ['required', 'email']];
        $messages = ['email.required' => 'El correo electrónico es obligatorio.', 'email.email' => 'El correo electrónico no contiene el formato adecuado.'];
        $validator = Validator::make($request->all(), $rules, $messages);
        if ($validator->fails()) { return response()->json(['errors' => $validator->errors()], 422); }
        $sanitizedData = $validator->validated();
        $email = $sanitizedData['email'];
        $fechaActual = Carbon::now('America/Mexico_City');
        $permitted_chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $valCorreo = Suscritos::where('email_susc', '=', $email)->first();
        if(!$valCorreo){
            $token = "SUSC" . substr(str_shuffle($permitted_chars), 0, 16);
            $datos = new Suscritos();
            $datos->codigo_susc = $token;
            $datos->email_susc = $email;
            $datos->fecha_susc = $fechaActual;
            $datos->estatus_susc = "Activo";
            $datos->save();
        }
        return response()->json(['success' => '¡Gracias por suscribirte!']);
    }
    public function contacto()
    {
        $cart = session()->get('cart');
        $cupon = session()->get('cupon');
        $favoritos = session()->get('favoritos');
        if($cupon){ $datosCupon  = Cupones::where('codigo_cupo', $cupon)->first(); }else{ $datosCupon = ""; }
        if($cart){ $totalProducts = count($cart); }else{ $totalProducts = ""; }
        if($favoritos){ $totalFavoritos = count($favoritos); }else{ $totalFavoritos = ""; }
        $categorias = Productos_categorias::select('codigo_prca', 'nombre_prca', 'imagen_prca', DB::raw('COUNT(productos.id) as total_productos'))
        ->join('productos', 'productos.categoria_prod', '=', 'productos_categorias.id')
        ->where('productos.estatus_prod', '=', 'Activo')
        ->where('productos_categorias.estatus_prca', '=', 'Activo')
        ->groupBy('codigo_prca', 'nombre_prca', 'imagen_prca')
        ->orderBy('nombre_prca', 'asc')
        ->get();
        $subcategorias = Productos_subcategorias::select('codigo_prsu', 'nombre_prsu', DB::raw('COUNT(productos.id) as total_productos'))
        ->join('productos', 'productos.subcategoria_prod', '=', 'productos_subcategorias.id')
        ->where('productos.estatus_prod', '=', 'Activo')
        ->where('productos_subcategorias.estatus_prsu', '=', 'Activo')
        ->groupBy('codigo_prsu', 'nombre_prsu')
        ->orderBy('nombre_prsu', 'asc')
        ->get();
        return view('tienda.contacto', compact('totalProducts', 'cart','favoritos' ,'totalFavoritos', 'categorias', 'subcategorias' ));
    }
    public function contactoEnvioCorreo(Request $request){
        $rules = [
            'name' => ['required', 'string','regex:/^[A-Za-z0-9\s]+$/', 'max:100'],
            'email' => ['required', 'email'],
            'phone' => ['required', 'string','regex:/^[A-Za-z0-9\s]+$/', 'max:20'],
            'subject' => ['required', 'string','regex:/^[A-Za-z0-9\s]+$/', 'max:25'],
            'messagess' => ['required', 'string','regex:/^[A-Za-z0-9\s]+$/', 'max:250'],
        ];
        $messages = [
            'name.string' => 'El nombre contiene caracteres desconocidos.',
            'name.required' => 'El nombre es obligatorio.',
            'email.required' => 'El correo electrónico es obligatorio.',
            'phone.required' => 'El teléfono es obligatorio.',
            'subject.required' => 'El asunto es obligatorio.',
            'messagess.required' => 'El mensaje es obligatorio.',
            'email.email' => 'El correo electrónico no contiene el formato adecuado.',
            'phone.string' => 'El teléfono contiene caracteres desconocidos.',
            'subject.string' => 'El asunto contiene caracteres desconocidos.',
            'messagess.string' => 'El mensaje contiene caracteres desconocidos.',
        ];
        $validator = Validator::make($request->all(), $rules, $messages);
        if ($validator->fails()) { $errors = $validator->errors()->all(); return redirect()->back()->with('danger', implode(', ', $errors));}
        $sanitizedData = $validator->validated();
        $name = $request->has('name') ? $sanitizedData['name'] : null;
        $email = $request->has('email') ? $sanitizedData['email'] : null;
        $phone = $request->has('phone') ? $sanitizedData['phone'] : null;
        $subject = $request->has('subject') ? $sanitizedData['subject'] : null;
        $messagess = $request->has('messagess') ? $sanitizedData['messagess'] : null;
        $rolAdministrador = Role::where('name', 'Administrador')->first();
        $fechaActual = Carbon::now('America/Mexico_City');
        $permitted_chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $token = "COCO" . substr(str_shuffle($permitted_chars), 0, 16);
        $datos = new Correos_contactos();
        $datos->codigo_coco = $token;
        $datos->nombre_coco = $name;
        $datos->correo_coco = $email;
        $datos->telefono_coco = $phone;
        $datos->asunto_coco = $subject;
        $datos->comentario_coco = $messagess;
        $datos->fecha_coco = $fechaActual;
        $datos->estatus_coco = "Activo";
        $datos->save();
        $empresas = Datos_empresas::first();
        $empresaCorreo = $empresas->empresa_config;
        $empresaImg = $empresas->logo_config;
        $empresaColor = $empresas->color_pricipal_config;
        $administradores = User::where('status', 'Activo')->whereHas('roles', function ($query) use ($rolAdministrador) {
        $query->where('role_id', $rolAdministrador->id);
        })->orderBy('name', 'asc')->get();
        foreach ($administradores as $administrador) {
            $emailAdmin = $administrador->email;
            $correoContacto = new envioCorreoContacto($name, $email, $phone ,$subject ,$messagess, $empresaCorreo, $empresaImg, $empresaColor);
            Mail::to($emailAdmin)->send($correoContacto);
        }
        return redirect()->back()->with('success', '¡Correo enviado, pronto nos cominicaremos con usted!');
    }
    public function pagarMercadoPago(Request $request)
    {
        $cart = session()->get('cart');
        if($cart){ $totalProducts = count($cart); }else{ $totalProducts = ""; }
        $rules = [
            'nombre' => 'required|string',
            'telefono' => 'required|string',
            'email' => 'required|email',
            'addDirecciones' => 'boolean',
            'requiereFact' => 'boolean',
        ];
        $messages = [
            'nombre.required' => 'El nombre es requerido.',
            'nombre.string' => 'El nombre debe ser una cadena de caracteres.',
            'telefono.required' => 'El teléfono es requerido.',
            'telefono.string' => 'El teléfono debe ser una cadena de caracteres.',
            'email.required' => 'El correo electrónico es requerido.',
            'email.email' => 'El correo electrónico debe ser una dirección de correo válida.',
        ];
        $validator = Validator::make($request->all(), $rules, $messages);
        if ($validator->fails()) {
            $errors = $validator->errors()->all();
            return response()->json(implode(', ', $errors));
        }
        $sanitizedData = $validator->validated();
        $nombre = $request->has('nombre') ? $sanitizedData['nombre'] : null;
        $telefono = $request->has('telefono') ? $sanitizedData['telefono'] : null;
        $email = $request->has('email') ? $sanitizedData['email'] : null;
        $requiereFact = $request->has('requiereFact') ? $sanitizedData['requiereFact'] : null;
        $addDirecciones = $request->has('addDirecciones') ? $sanitizedData['addDirecciones'] : null;
        if ($addDirecciones) {
            $rules = ['direccionSeleccionada' => 'nullable|string'];
            $messages = ['direccionSeleccionada.string' => 'La dirección debe ser una cadena de caracteres.'];
        } else {
            $rules = [
                'pais' => 'required|string',
                'ciudad' => 'required|string',
                'direccion' => 'required|string',
                'referencia' => 'required|string',
                'estado' => 'required|numeric',
                'cp' => 'required|digits:5',
            ];
            $messages = [
                'pais.required' => 'El país es requerido.',
                'pais.string' => 'El país debe ser una cadena de caracteres.',
                'ciudad.required' => 'La ciudad es requerida.',
                'ciudad.string' => 'La ciudad debe ser una cadena de caracteres.',
                'direccion.required' => 'La dirección es requerida.',
                'direccion.string' => 'La dirección debe ser una cadena de caracteres.',
                'referencia.string' => 'La referencia contiene caracteres desconocidos.',
                'referencia.required' => 'La referencia es obligatoria.',
                'estado.required' => 'El estado es requerido.',
                'estado.numeric' => 'El estado debe ser un carácter numérico.',
                'cp.required' => 'El código postal es requerido.',
                'cp.digits' => 'El código postal debe tener exactamente 5 dígitos.',
            ];
        }
        $validator = Validator::make($request->all(), $rules, $messages);
        if ($validator->fails()) {
            $errors = $validator->errors()->all();
            return response()->json(implode(', ', $errors));
        }
        $sanitizedData = $validator->validated();
        $cp = "";
        $idDirecc = null;
        $pais = null;
        $ciudad = null;
        $direccion = null;
        $referencia = null;
        $estado = null;
        if ($addDirecciones) {
            $direccionSeleccionada = $request->has('direccionSeleccionada') ? $sanitizedData['direccionSeleccionada'] : null;
            $direccionSelec  = Direcciones::where('codigo_dire', $direccionSeleccionada)->first();
            $cp = $direccionSelec->codigo_postal_dire;
            $idDirecc = $direccionSelec->id;;
        } else {
            $pais = $request->has('pais') ? $sanitizedData['pais'] : null;
            $ciudad = $request->has('ciudad') ? $sanitizedData['ciudad'] : null;
            $direccion = $request->has('direccion') ? $sanitizedData['direccion'] : null;
            $referencia = $request->has('referencia') ? $sanitizedData['referencia'] : null;
            $estado = $request->has('estado') ? $sanitizedData['estado'] : null;
            $cp = $request->has('cp') ? $sanitizedData['cp'] : null;
        }
        $permitted_chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $tokenCompras = "COMP" . substr(str_shuffle($permitted_chars), 0, 16);
        $compras = new Compras();
        $compras->codigo_comp = $tokenCompras;
        if(Auth::check()){ $compras->usuario_comp = Auth::user()->id; }
        $compras->nombre_comp = $nombre;
        $compras->telefono_comp = $telefono;
        $compras->email_comp = $email;
        $compras->pais_comp = $pais;
        $compras->ciudad_comp = $ciudad;
        $compras->direccion_comp = $direccion;
        $compras->referencia_comp = $referencia;
        $compras->estado_comp = $estado;
        $compras->cp_comp = $cp;
        $compras->addDirecciones_comp = $addDirecciones;
        $compras->direccionSeleccionada = $idDirecc;
        if($requiereFact){
            $rules = [
                'nombre_fact' => 'required|string',
                'rfc_fact' => 'required|string',
                'uso_fact' => 'required|string',
                'regime_fact' => 'required|string',
                'cp_fact' => 'required|numeric'
            ];
            $messages = [
                'nombre_fact.required' => 'El nombre o nombre de la empresa es requerido.',
                'nombre_fact.string' => 'El nombre o nombre de la empresa debe ser una cadena de caracteres.',
                'rfc_fact.required' => 'El RFC es requerido.',
                'rfc_fact.string' => 'El RFC debe ser una cadena de caracteres.',
                'uso_fact.required' => 'El us de la factura es requerido.',
                'uso_fact.email' => 'El us de la factura debe ser una dirección de correo válida.',
                'regime_fact.required' => 'El réfimen fiscal es requerido.',
                'regime_fact.string' => 'El réfimen fiscal debe ser una cadena de caracteres.',
                'cp_fact.required' => 'El codigo postal es requerido.',
                'cp_fact.string' => 'El codigo postal debe ser de caracteres numéricos.',
            ];
            $validator = Validator::make($request->all(), $rules, $messages);
            if ($validator->fails()) { $errors = $validator->errors()->all(); return redirect()->back()->with('danger', implode(', ', $errors));}
            $sanitizedData = $validator->validated();
            $nombre_fact = $request->has('nombre_fact') ? $sanitizedData['nombre_fact'] : null;
            $rfc_fact = $request->has('rfc_fact') ? $sanitizedData['rfc_fact'] : null;
            $uso_fact = $request->has('uso_fact') ? $sanitizedData['uso_fact'] : null;
            $regime_fact = $request->has('regime_fact') ? $sanitizedData['regime_fact'] : null;
            $cp_fact = $request->has('cp_fact') ? $sanitizedData['cp_fact'] : null;
            $requiereFact = true;
            $compras->requiereFact = $requiereFact;
            $compras->nombre_fact_comp = $nombre_fact;
            $compras->rfc_fact_comp = $rfc_fact;
            $compras->uso_fact_comp = $uso_fact;
            $compras->regime_fact_comp = $regime_fact;
            $compras->cp_fact_comp = $cp_fact;
        }
        $envio = 0;
        $empresas = Datos_empresas::first();
        if($empresas->envio_config == 'Por Paqueteria'){
            $rules = [ 'codigoServicio' => 'string' ];
            $messages = [ 'codigoServicio.string' => 'La campo selectivo de envío es incorrecto.' ];
            $validator = Validator::make($request->all(), $rules, $messages);
            if ($validator->fails()) { $errors = $validator->errors()->all(); return response()->json(implode(', ', $errors)); }
            $sanitizedData = $validator->validated();
            $codigoServicio = $request->has('codigoServicio') ? $sanitizedData['codigoServicio'] : null;
            $response = Http::withHeaders([
                'Authorization' => 'Token token=' . env('APISKYDROPX'),
                'Content-Type' => 'application/json',
            ])->post('https://api.skydropx.com/v1/quotations', [
                'zip_from' => $empresas->codigo_postal_config,
                'zip_to' => $cp,
                'parcel' => [
                    'weight' => $empresas->weight_config, // peso
                    'height' => $empresas->height_config, // altura
                    'width' => $empresas->width_config, // ancho
                    'length' => $empresas->length_config, // longitud
                ],
                'carriers' => [
                    ['name' => $empresas->paqueteria_envio_config],
                ],
            ]);
            if ($response->successful()) {
                $datosEnvio = $response->json();
                foreach ($datosEnvio as $datoEnvio) {
                    if ($datoEnvio['service_level_code'] == $codigoServicio) {
                        $envio = $datoEnvio['total_pricing'];
                    }
                }
            } else {
                return response()->json(['error' => 'Error en la solicitud a Skydropx'], $response->status());
            }
        }else if($empresas->envio_config == 'Costo Fijo'){
            $envio = $empresas->costo_envio_config;
        }
        $cupon = session()->get('cupon');
        if($cupon){
            $datosCupon  = Cupones::where('codigo_cupo', $cupon)->first();
            $descuento = $datosCupon->descuento_cupo;
        }else{ $datosCupon = ""; }
        $totalCost = 0;
        $subt = 0;
        if ($cart) {
            foreach ($cart as $item) {
                $totalCost += $item['costo'] * $item['cantidad'];
                $subt += $item['costo'] * $item['cantidad'];
            }
        }
        if($datosCupon){
            if ($datosCupon->tipo_cupo == 'Porcentaje'){
                $descuento = $totalCost * ($datosCupon->descuento_cupo / 100 );
            }
            if ($datosCupon->tipo_cupo == 'Monetario'){
                $descuento =  $datosCupon->descuento_cupo;
            }
        }else{
            $descuento = 0;
        }
        $totalCost = ($totalCost - $descuento) + $envio;
        if(Auth::check()){ $compras->tipo_comp = "Interna"; }else{ $compras->tipo_comp = "Externa"; }
        $compras->sub_total_comp = $subt;
        if($cupon){ $compras->cupon_comp = $datosCupon->id; }
        $compras->descuento_comp = $descuento;
        $compras->envio_comp = $envio;
        $compras->total_comp = $totalCost;
        $compras->save();
        if ($cart) {
            foreach ($cart as $item) {
                $permitted_chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
                $prod  = Productos::where('codigo_prod', $item['product'])->first();
                $token = "PED" . substr(str_shuffle($permitted_chars), 0, 16);
                $pedidos = new Pedidos();
                $pedidos->codigo_pedi = $token;
                $pedidos->compra_pedi = $compras->id;
                $pedidos->producto_pedi = $prod->id;
                $pedidos->colorHtml_pedi = $item['color'];
                $pedidos->imagenProduct_pedi = $item['imagenProduct'];
                $pedidos->categoriaProduct_pedi = $item['idCategoria'];
                $pedidos->subcategoriaProduct_pedi = $item['idSubcategoria'];
                $pedidos->descripcion_pedi = $item['descripcion'];
                $pedidos->nombreProduct_pedi = $item['nombreProduct'];
                $pedidos->costoProduct_pedi = $item['costo'];
                $pedidos->cantidad_pedi = $item['cantidad'];
                $pedidos->total_pedi = $item['total'];
                $pedidos->save();
            }
        }
        // Agrega credenciales
        $nombreEmpresa = $empresas->nombre_config;
        $baseURLConfirmado = $request->root() . "/mercadopago/pago/confirmado/".$tokenCompras;
        $baseURLFallido = $request->root() . "/mercadopago/pago/fallido/".$tokenCompras;
        $baseURLPendiente = $request->root() . "/mercadopago/pago/pendiente/".$tokenCompras;
        MercadoPagoConfig::setAccessToken(env('MERCADOPAGO_ACCESS_TOKEN'));
        $pagoTotalTexto = number_format($totalCost, 2);
        // Convertir el precio formateado de texto a un número
        $pagoTotalNumero = floatval(str_replace(',', '', $pagoTotalTexto));
        $titulo = 'Compra ' . $nombreEmpresa;
        $client = new PreferenceClient();
        try {
            $preference = $client->create([
                "items" => [
                    [
                        "title" => $titulo,
                        "quantity" => 1,
                        "unit_price" => $pagoTotalNumero,
                        "currency_id" => "MXN",
                        "id" => $tokenCompras, // Código del item (reemplaza con tu código real de producto)
                        "description" => "Compra en la tienda de El Blog Del Auto", // Descripción del item
                        "category_id" => "Tienda Virtual"
                    ]
                ],
                "payer" => [
                    "first_name" => $nombre, // Nombre del comprador (deberías obtenerlo de tus datos de usuario)
                    "last_name" => "" // Apellido del comprador (deberías obtenerlo de tus datos de usuario)
                ],
                "external_reference" => $token,
                "auto_return" => "approved",
                "back_urls" => [
                    "success" => $baseURLConfirmado,
                    "failure" => $baseURLFallido,
                    "pending" => $baseURLPendiente
                ],
                "notification_url" => "https://tienda.elblogdelauto.com/webhook/mercadopago/tienda",
                "payment_methods" => [
                    "excluded_payment_methods" => [], // No excluimos métodos específicos, solo tipos
                    "excluded_payment_types" => [
                        ["id" => "bank_transfer"], // Excluye transferencias bancarias
                        ["id" => "ticket"] // Excluye pagos en efectivo
                    ],
                    "installments" => 1 // Solo permite pagos en una sola exhibición
                ]
            ]);
            return response()->json($preference);
        } catch (\MercadoPago\Exceptions\MPApiException $e) {
            return response()->json([
                'status' => 'error',
                'message' => 'Error al procesar el pago: ' . $e->getMessage()
            ], 422);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 'error',
                'message' => 'Error interno del servidor: ' . $e->getMessage()
            ], 500);
        }
    }
    public function pagarPaypal(Request $request)
    {
        $cart = session()->get('cart');
        if($cart){ $totalProducts = count($cart); }else{ $totalProducts = ""; }
        $rules = [
            'nombre' => 'required|string',
            'telefono' => 'required|string',
            'email' => 'required|email',
            'addDirecciones' => 'boolean',
            'requiereFact' => 'boolean',
        ];
        $messages = [
            'nombre.required' => 'El nombre es requerido.',
            'nombre.string' => 'El nombre debe ser una cadena de caracteres.',
            'telefono.required' => 'El teléfono es requerido.',
            'telefono.string' => 'El teléfono debe ser una cadena de caracteres.',
            'email.required' => 'El correo electrónico es requerido.',
            'email.email' => 'El correo electrónico debe ser una dirección de correo válida.',
        ];
        $validator = Validator::make($request->all(), $rules, $messages);
        if ($validator->fails()) {
            $errors = $validator->errors()->all();
            return response()->json(implode(', ', $errors));
        }
        $sanitizedData = $validator->validated();
        $nombre = $request->has('nombre') ? $sanitizedData['nombre'] : null;
        $telefono = $request->has('telefono') ? $sanitizedData['telefono'] : null;
        $email = $request->has('email') ? $sanitizedData['email'] : null;
        $requiereFact = $request->has('requiereFact') ? $sanitizedData['requiereFact'] : null;
        $addDirecciones = $request->has('addDirecciones') ? $sanitizedData['addDirecciones'] : null;
        if ($addDirecciones) {
            $rules = ['direccionSeleccionada' => 'nullable|string'];
            $messages = ['direccionSeleccionada.string' => 'La dirección debe ser una cadena de caracteres.'];
        } else {
            $rules = [
                'pais' => 'required|string',
                'ciudad' => 'required|string',
                'direccion' => 'required|string',
                'referencia' => 'required|string',
                'estado' => 'required|numeric',
                'cp' => 'required|digits:5',
            ];
            $messages = [
                'pais.required' => 'El país es requerido.',
                'pais.string' => 'El país debe ser una cadena de caracteres.',
                'ciudad.required' => 'La ciudad es requerida.',
                'ciudad.string' => 'La ciudad debe ser una cadena de caracteres.',
                'direccion.required' => 'La dirección es requerida.',
                'direccion.string' => 'La dirección debe ser una cadena de caracteres.',
                'referencia.string' => 'La referencia contiene caracteres desconocidos.',
                'referencia.required' => 'La referencia es obligatoria.',
                'estado.required' => 'El estado es requerido.',
                'estado.numeric' => 'El estado debe ser un carácter numérico.',
                'cp.required' => 'El código postal es requerido.',
                'cp.digits' => 'El código postal debe tener exactamente 5 dígitos.',
            ];
        }
        $validator = Validator::make($request->all(), $rules, $messages);
        if ($validator->fails()) { $errors = $validator->errors()->all(); return response()->json(implode(', ', $errors));}
        $sanitizedData = $validator->validated();
        $cp = "";
        $idDirecc = null;
        $pais = null;
        $ciudad = null;
        $direccion = null;
        $referencia = null;
        $estado = null;
        if ($addDirecciones) {
            $direccionSeleccionada = $request->has('direccionSeleccionada') ? $sanitizedData['direccionSeleccionada'] : null;
            $direccionSelec  = Direcciones::where('codigo_dire', $direccionSeleccionada)->first();
            $cp = $direccionSelec->codigo_postal_dire;
            $idDirecc = $direccionSelec->id;;
        } else {
            $pais = $request->has('pais') ? $sanitizedData['pais'] : null;
            $ciudad = $request->has('ciudad') ? $sanitizedData['ciudad'] : null;
            $direccion = $request->has('direccion') ? $sanitizedData['direccion'] : null;
            $referencia = $request->has('referencia') ? $sanitizedData['referencia'] : null;
            $estado = $request->has('estado') ? $sanitizedData['estado'] : null;
            $cp = $request->has('cp') ? $sanitizedData['cp'] : null;
        }
        $permitted_chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $tokenCompras = "COMP" . substr(str_shuffle($permitted_chars), 0, 16);
        $compras = new Compras();
        $compras->codigo_comp = $tokenCompras;
        if(Auth::check()){ $compras->usuario_comp = Auth::user()->id; }
        $compras->nombre_comp = $nombre;
        $compras->telefono_comp = $telefono;
        $compras->email_comp = $email;
        $compras->pais_comp = $pais;
        $compras->ciudad_comp = $ciudad;
        $compras->direccion_comp = $direccion;
        $compras->referencia_comp = $referencia;
        $compras->estado_comp = $estado;
        $compras->cp_comp = $cp;
        $compras->addDirecciones_comp = $addDirecciones;
        $compras->direccionSeleccionada = $idDirecc;
        if($requiereFact){
            $rules = [
                'nombre_fact' => 'required|string',
                'rfc_fact' => 'required|string',
                'uso_fact' => 'required|string',
                'regime_fact' => 'required|string',
                'cp_fact' => 'required|digits:5'
            ];
            $messages = [
                'nombre_fact.required' => 'El nombre o nombre de la empresa es requerido.',
                'nombre_fact.string' => 'El nombre o nombre de la empresa debe ser una cadena de caracteres.',
                'rfc_fact.required' => 'El RFC es requerido.',
                'rfc_fact.string' => 'El RFC debe ser una cadena de caracteres.',
                'uso_fact.required' => 'El us de la factura es requerido.',
                'uso_fact.email' => 'El us de la factura debe ser una dirección de correo válida.',
                'regime_fact.required' => 'El réfimen fiscal es requerido.',
                'regime_fact.string' => 'El réfimen fiscal debe ser una cadena de caracteres.',
                'cp_fact.required' => 'El codigo postal es requerido.',
                'cp_fact.string' => 'El codigo postal debe ser de caracteres numéricos.',
            ];
            $validator = Validator::make($request->all(), $rules, $messages);
            if ($validator->fails()) { $errors = $validator->errors()->all(); return redirect()->back()->with('danger', implode(', ', $errors));}
            $sanitizedData = $validator->validated();
            $nombre_fact = $request->has('nombre_fact') ? $sanitizedData['nombre_fact'] : null;
            $rfc_fact = $request->has('rfc_fact') ? $sanitizedData['rfc_fact'] : null;
            $uso_fact = $request->has('uso_fact') ? $sanitizedData['uso_fact'] : null;
            $regime_fact = $request->has('regime_fact') ? $sanitizedData['regime_fact'] : null;
            $cp_fact = $request->has('cp_fact') ? $sanitizedData['cp_fact'] : null;
            $requiereFact = true;
            $compras->requiereFact = $requiereFact;
            $compras->nombre_fact_comp = $nombre_fact;
            $compras->rfc_fact_comp = $rfc_fact;
            $compras->uso_fact_comp = $uso_fact;
            $compras->regime_fact_comp = $regime_fact;
            $compras->cp_fact_comp = $cp_fact;
        }
        $envio = 0;
        $empresas = Datos_empresas::first();
        if($empresas->envio_config == 'Por Paqueteria'){
            //dd($request->has('codigoServicio'));
            $rules = [ 'codigoServicio' => 'string' ];
            $messages = [ 'codigoServicio.string' => 'La campo selectivo de envío es incorrecto.' ];
            $validator = Validator::make($request->all(), $rules, $messages);
            if ($validator->fails()) { $errors = $validator->errors()->all(); return response()->json(implode(', ', $errors)); }
            $sanitizedData = $validator->validated();
            $codigoServicio = $request->has('codigoServicio') ? $sanitizedData['codigoServicio'] : null;
            $response = Http::withHeaders([
                'Authorization' => 'Token token=' . env('APISKYDROPX'),
                'Content-Type' => 'application/json',
            ])->post('https://api.skydropx.com/v1/quotations', [
                'zip_from' => $empresas->codigo_postal_config,
                'zip_to' => $cp,
                'parcel' => [
                    'weight' => $empresas->weight_config, // peso
                    'height' => $empresas->height_config, // altura
                    'width' => $empresas->width_config, // ancho
                    'length' => $empresas->length_config, // longitud
                ],
                'carriers' => [
                    ['name' => $empresas->paqueteria_envio_config],
                ],
            ]);
            if ($response->successful()) {
                $datosEnvio = $response->json();
                foreach ($datosEnvio as $datoEnvio) {
                    if ($datoEnvio['service_level_code'] == $codigoServicio) {
                        $envio = $datoEnvio['total_pricing'];
                    }
                }
            } else {
                return response()->json(['error' => 'Error en la solicitud a Skydropx'], $response->status());
            }
        }else if($empresas->envio_config == 'Costo Fijo'){
            $envio = $empresas->costo_envio_config;
        }
        $cupon = session()->get('cupon');
        if($cupon){
            $datosCupon  = Cupones::where('codigo_cupo', $cupon)->first();
            $descuento = $datosCupon->descuento_cupo;
        }else{ $datosCupon = ""; }
        $totalCost = 0;
        $subt = 0;
        if ($cart) {
            foreach ($cart as $item) {
                $totalCost += $item['costo'] * $item['cantidad'];
                $subt += $item['costo'] * $item['cantidad'];
            }
        }
        if($datosCupon){
            if ($datosCupon->tipo_cupo == 'Porcentaje'){
                $descuento = $totalCost * ($datosCupon->descuento_cupo / 100 );
            }
            if ($datosCupon->tipo_cupo == 'Monetario'){
                $descuento =  $datosCupon->descuento_cupo;
            }
        }else{
            $descuento = 0;
        }
        $totalCost = ($totalCost - $descuento) + $envio;
        if(Auth::check()){ $compras->tipo_comp = "Interna"; }else{ $compras->tipo_comp = "Externa"; }
        $compras->sub_total_comp = $subt;
        if($cupon){ $compras->cupon_comp = $datosCupon->id; }
        $compras->descuento_comp = $descuento;
        $compras->envio_comp = $envio;
        $compras->total_comp = $totalCost;
        $compras->save();
        if ($cart) {
            foreach ($cart as $item) {
                $permitted_chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
                $prod  = Productos::where('codigo_prod', $item['product'])->first();
                $token = "PED" . substr(str_shuffle($permitted_chars), 0, 16);
                $pedidos = new Pedidos();
                $pedidos->codigo_pedi = $token;
                $pedidos->compra_pedi = $compras->id;
                $pedidos->producto_pedi = $prod->id;
                $pedidos->colorHtml_pedi = $item['color'];
                $pedidos->imagenProduct_pedi = $item['imagenProduct'];
                $pedidos->categoriaProduct_pedi = $item['idCategoria'];
                $pedidos->subcategoriaProduct_pedi = $item['idSubcategoria'];
                $pedidos->descripcion_pedi = $item['descripcion'];
                $pedidos->nombreProduct_pedi = $item['nombreProduct'];
                $pedidos->costoProduct_pedi = $item['costo'];
                $pedidos->cantidad_pedi = $item['cantidad'];
                $pedidos->total_pedi = $item['total'];
                $pedidos->save();
            }
        }
        return response()->json($compras);
    }
    public function estatusMercadoPago($estatus, $id, Request $request)
    {
        $cart = session()->get('cart');
        $cupon = session()->get('cupon');
        $favoritos = session()->get('favoritos');
        if($cupon){ $datosCupon  = Cupones::where('codigo_cupo', $cupon)->first(); }else{ $datosCupon = ""; }
        if($cart){ $totalProducts = count($cart); }else{ $totalProducts = ""; }
        if($favoritos){ $totalFavoritos = count($favoritos); }else{ $totalFavoritos = ""; }
        $categorias = Productos_categorias::select('codigo_prca', 'nombre_prca', 'imagen_prca', DB::raw('COUNT(productos.id) as total_productos'))
        ->join('productos', 'productos.categoria_prod', '=', 'productos_categorias.id')
        ->where('productos.estatus_prod', '=', 'Activo')
        ->where('productos_categorias.estatus_prca', '=', 'Activo')
        ->groupBy('codigo_prca', 'nombre_prca', 'imagen_prca')
        ->get();
        $subcategorias =  Productos_subcategorias::select('codigo_prsu', 'nombre_prsu')->join('productos', 'productos.subcategoria_prod', '=', 'productos_subcategorias.id')
        ->where('estatus_prod', '=', 'Activo')->where('estatus_prsu', '=', 'Activo')->groupBy('codigo_prsu', 'nombre_prsu')->get();
        if($estatus == "confirmado"){
            $fechaActual = Carbon::now('America/Mexico_City');
            $status = $request->get('status');
            $permitted_chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
            $token = substr(str_shuffle($permitted_chars), 0, 10);
            if($status == "approved"){
                $compra = Compras::select('compras.id as idPago', 'codigo_comp','nombre_comp', 'telefono_comp', 'referencia_comp'
                ,'email_comp', 'pais_comp', 'ciudad_comp', 'direccion_comp', 'edo.nombre_edo as nomEdo', 'cp_comp', 'addDirecciones_comp'
                ,'pais_dire', 'ciudad_dire', 'edoDire.nombre_edo as nomEdo_dire', 'direccion_dire', 'codigo_postal_dire'
                ,'requiereFact', 'nombre_fact_comp', 'rfc_fact_comp', 'uso_fact_comp', 'regime_fact_comp'
                ,'cp_fact_comp', 'sub_total_comp', 'codigo_cupo', 'descuento_comp', 'envio_comp', 'total_comp')
                ->leftjoin('cupones', 'cupones.id', '=', 'compras.cupon_comp')
                ->leftjoin('direcciones', 'direcciones.id', '=', 'compras.direccionSeleccionada')
                ->leftjoin('estados_republica as edoDire', 'edoDire.id', '=', 'direcciones.estado_dire')
                ->leftjoin('estados_republica as edo', 'edo.id', '=', 'compras.estado_comp')
                ->where('codigo_comp', $id)->first();
                $payment_id = $request->get('payment_id');
                $payment_type = $request->get('payment_type');
                $preference_id = $request->get('preference_id');
                $permitted_chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
                $token = "PACO" . substr(str_shuffle($permitted_chars), 0, 16);
                $comprobantes = Pagos_comprobantes::where('cod_pago_paco', $id)->first();
                if(!$comprobantes){
                    $ultimoRegistro = Pagos_comprobantes::latest()->first();
                    if($ultimoRegistro){
                        $idUltimo = $ultimoRegistro->id;
                        $ultimo = $idUltimo + 1;
                    }else{ $ultimo =  1; }
                    if(intval($ultimo) == 0 || intval($ultimo) <= 10){ $ultimaSolicitud = "OC-00000". + $ultimo;}
                    else if(intval($ultimo) >= 10 || intval($ultimo) <= 100){ $ultimaSolicitud = "OC-0000". + $ultimo;}
                    else if(intval($ultimo) >= 100  || intval($ultimo) <= 1000){ $ultimaSolicitud = "OC-000". + $ultimo;}
                    else if(intval($ultimo) >= 1000  || intval($ultimo) <= 10000){ $ultimaSolicitud = "OC-00". + $ultimo;}
                    else if(intval($ultimo) >= 10000  || intval($ultimo) <= 100000){ $ultimaSolicitud = "OC-0". + $ultimo;}
                    else if(intval($ultimo) >= 100000  || intval($ultimo) <= 1000000){ $ultimaSolicitud = "OC-". + $ultimo;}
                    $pedidos = Pedidos::select('nombreProduct_pedi')->join('productos', 'productos.id', '=', 'pedidos.producto_pedi')->where('compra_pedi', '=', $compra->idPago)->get();
                    $nombresProductos = $pedidos->pluck('nombreProduct_pedi')->toArray();
                    $contenido = implode(',', $nombresProductos);
                    $compania = "";
                    if($compra->nombre_fact_comp){ $compania = $compra->nombre_fact_comp; }else{ $compania = "Sin compañia"; }
                    $empresas = Datos_empresas::first();
                    $dataId = "";
                    if($empresas->envio_config == 'Por Paqueteria'){
                        $response = Http::withHeaders([
                            'Authorization' => 'Token token=' . env('APISKYDROPX'),
                            'Content-Type' => 'application/json',
                        ])->post('https://api.skydropx.com/v1/shipments', [
                            'address_from' => [
                                'province' => $empresas->provincia_config,
                                'city' =>  $empresas->ciudad_config,
                                'name' => $empresas->nombre_config,
                                'zip' => $empresas->codigo_postal_config,
                                'country' => 'MX',
                                'address1' => $empresas->direccion_config,
                                'company' => $empresas->empresa_config,
                                'phone' => $empresas->telefono_config,
                                'email' => $empresas->email_config,
                            ],
                            'parcels' => [
                                [
                                    'weight' => $empresas->weight_config,
                                    'distance_unit' => 'CM',
                                    'mass_unit' => 'KG',
                                    'height' => $empresas->height_config,
                                    'width' => $empresas->width_config,
                                    'length' => $empresas->length_config,
                                ],
                            ],
                            'address_to' => [
                                'province' =>  $compra->nomEdo,
                                'city' => $compra->ciudad_comp,
                                'name' => $compra->nombre_comp,
                                'zip' => strval($compra->cp_comp),
                                'country' => 'MX',
                                'address1' => $compra->direccion_comp,
                                'company' => $compania,
                                'phone' => $compra->telefono_comp,
                                'email' => $compra->email_comp,
                                'reference' => substr($compra->referencia_comp, 0, 25),
                                'contents' => $contenido,
                            ],
                            'consignment_note_class_code' => '51241100',
                            'consignment_note_packaging_code' => '4G',
                            'carriers' => [
                                ['name' => $empresas->paqueteria_envio_config],
                            ],
                        ]);
                        if ($response->successful()) {
                            // Si la solicitud fue exitosa, obtén los datos de la respuesta
                            $data = $response->json();
                            $dataId = $response['data']['id'];
                            //dd($data);
                        } else {
                            $error = $response->body();
                        }
                    }
                    $comprobantePagos = new Pagos_comprobantes();
                    $comprobantePagos->codigo_paco = $token;
                    $comprobantePagos->numero_pago = $ultimaSolicitud;
                    $comprobantePagos->pago_paco = $compra->idPago;
                    $comprobantePagos->cod_pago_paco = $compra->codigo_comp;
                    $comprobantePagos->payment_id_paco = $payment_id;
                    $comprobantePagos->payment_type_paco = $payment_type;
                    $comprobantePagos->preference_id_paco = $preference_id;
                    $comprobantePagos->id_envio_paqueteria_paco = $dataId;
                    $comprobantePagos->fecha_paco = $fechaActual;
                    $comprobantePagos->estatus_paco = "Pagado";
                    $comprobantePagos->save();
                    $productos = Pedidos::select('nombreProduct_pedi','producto_pedi',  'descripcion_pedi', 'costoProduct_pedi','cantidad_pedi','total_pedi','colorHtml_pedi',
                    )->join('compras', 'compras.id', '=', 'pedidos.compra_pedi')
                    ->where('compra_pedi', $compra->idPago)->get();
                    foreach($productos as $producto){
                        $listProducto = Productos::select('stock_prod')->where('productos.id', $producto->producto_pedi)->first();
                        $listProducto->stock_prod =  $listProducto->stock_prod - $producto->cantidad_pedi;
                        $listProducto->save();
                    }
                    $pdf = FacadePdf::loadView('tienda/comprobante_pago', compact('compra','productos', 'empresas', 'ultimaSolicitud'));
                    $pdf->getDomPDF()->setHttpContext(stream_context_create([ 'ssl' => [ 'allow_self_signed'=> TRUE, 'verify_peer' => FALSE, 'verify_peer_name' => FALSE]]));
                    $rutaPdf = public_path('/assets/pdf/comprobantes/comprobante_' . $token . '.pdf');
                    $pdf->save($rutaPdf);
                    $nombre = $compra->nombre_comp;
                    $numero = $ultimaSolicitud;
                    $subtotal = $compra->sub_total_comp;
                    $total = $compra->total_comp;
                    $correoReceptor = $compra->email_comp;
                    $empresaCorreo = $empresas->empresa_config;
                    $empresaImg = $empresas->logo_config;
                    $empresaColor = $empresas->color_pricipal_config;
                    $correoCliente = new envioComprobantePago($nombre, $numero ,$subtotal ,$total, $fechaActual, $empresaCorreo, $empresaImg, $empresaColor);
                    $correoCliente->attach($rutaPdf, [
                        'as' => 'Comprobante_' . substr(str_shuffle($permitted_chars), 0, 16) . '.pdf',
                        'mime' => 'application/pdf',
                    ]);
                    Mail::to($correoReceptor)->send($correoCliente);
                    $rolAdministrador = Role::where('name', 'Administrador')->first();
                    $administradores = User::where('status', 'Activo')->whereHas('roles', function ($query) use ($rolAdministrador) {
                    $query->where('role_id', $rolAdministrador->id);
                    })->orderBy('name', 'asc')->get();
                    foreach ($administradores as $administrador) {
                        $email = $administrador->email;
                        $correoAdministrador = new envioAvisoCompra($nombre, $numero ,$subtotal ,$total, $fechaActual, $empresaCorreo, $empresaImg, $empresaColor);
                        $correoAdministrador->attach($rutaPdf, [
                            'as' => 'Comprobante_' . substr(str_shuffle($permitted_chars), 0, 16) . '.pdf',
                            'mime' => 'application/pdf',
                        ]);
                        Mail::to($email)->send($correoAdministrador);
                    }
                }
                // return $pdf->setPaper('a4', 'portrait')->download('documento.pdf');
                // return $pdf->setPaper('a4', 'portrait')->stream('documento.pdf');
                if($cart){
                    foreach ($cart as $item) {
                        $cartDelete = session()->get('cart');
                        $id = $item['token'];
                        unset($cartDelete[$id]);
                        session()->put('cart', $cartDelete);
                    }
                }
                if($cupon){ session()->forget('cupon'); }
                if($favoritos){
                    foreach ($favoritos as $item) {
                        $favoritosDelete = session()->get('favoritos');
                        $id = $item['token'];
                        unset($favoritosDelete[$id]);
                        session()->put('favoritos', $favoritosDelete);
                    }
                }
                return view('tienda.compraConfirmada', compact('totalProducts','cart', 'cupon', 'favoritos',  'datosCupon', 'totalFavoritos', 'categorias', 'subcategorias'));
            }else{
                if($cart){
                    foreach ($cart as $item) {
                        $cartDelete = session()->get('cart');
                        $id = $item['token'];
                        unset($cartDelete[$id]);
                        session()->put('cart', $cartDelete);
                    }
                }
                if($cupon){ session()->forget('cupon'); }
                if($favoritos){
                    foreach ($favoritos as $item) {
                        $favoritosDelete = session()->get('favoritos');
                        $id = $item['token'];
                        unset($favoritosDelete[$id]);
                        session()->put('favoritos', $favoritosDelete);
                    }
                }
                return view('tienda.compraPediente',compact('totalProducts','cart', 'cupon', 'favoritos',  'datosCupon', 'totalFavoritos', 'categorias', 'subcategorias'));
            }
        }else if($estatus == "fallido"){
            if($cart){
                    foreach ($cart as $item) {
                        $cartDelete = session()->get('cart');
                        $id = $item['token'];
                        unset($cartDelete[$id]);
                        session()->put('cart', $cartDelete);
                    }
                }
                if($cupon){ session()->forget('cupon'); }
                if($favoritos){
                    foreach ($favoritos as $item) {
                        $favoritosDelete = session()->get('favoritos');
                        $id = $item['token'];
                        unset($favoritosDelete[$id]);
                        session()->put('favoritos', $favoritosDelete);
                    }
                }
                return view('tienda.compraFallido',compact('totalProducts','cart', 'cupon', 'favoritos',  'datosCupon', 'totalProducts',  'totalFavoritos', 'categorias', 'subcategorias'));
        }else if($estatus == "pendiente"){
            if($cart){
                    foreach ($cart as $item) {
                        $cartDelete = session()->get('cart');
                        $id = $item['token'];
                        unset($cartDelete[$id]);
                        session()->put('cart', $cartDelete);
                    }
                }
                if($cupon){ session()->forget('cupon'); }
                if($favoritos){
                    foreach ($favoritos as $item) {
                        $favoritosDelete = session()->get('favoritos');
                        $id = $item['token'];
                        unset($favoritosDelete[$id]);
                        session()->put('favoritos', $favoritosDelete);
                    }
                }
                return view('tienda.compraPediente',compact('totalProducts','cart', 'cupon', 'favoritos',  'datosCupon', 'totalFavoritos', 'categorias', 'subcategorias'));
        }else{
            if($cart){
                foreach ($cart as $item) {
                    $cartDelete = session()->get('cart');
                    $id = $item['token'];
                    unset($cartDelete[$id]);
                    session()->put('cart', $cartDelete);
                }
            }
            if($cupon){ session()->forget('cupon'); }
            if($favoritos){
                foreach ($favoritos as $item) {
                    $favoritosDelete = session()->get('favoritos');
                    $id = $item['token'];
                    unset($favoritosDelete[$id]);
                    session()->put('favoritos', $favoritosDelete);
                }
            }
            return view('tienda.compraPediente',compact('totalProducts','cart', 'cupon', 'favoritos',  'datosCupon', 'totalProducts',  'totalFavoritos',));
        }
    }
    public function estatusPaypal($estatus, $idCompra, $idPaypal, Request $request)
    {
        $cart = session()->get('cart');
        $cupon = session()->get('cupon');
        $favoritos = session()->get('favoritos');
        if($cupon){ $datosCupon  = Cupones::where('codigo_cupo', $cupon)->first(); }else{ $datosCupon = ""; }
        if($cart){ $totalProducts = count($cart); }else{ $totalProducts = ""; }
        if($favoritos){ $totalFavoritos = count($favoritos); }else{ $totalFavoritos = ""; }
        $fechaActual = Carbon::now('America/Mexico_City');
        $status = $request->get('status');
        $permitted_chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $token = substr(str_shuffle($permitted_chars), 0, 10);
        $compra = Compras::select('compras.id as idPago', 'codigo_comp', 'nombre_comp', 'telefono_comp', 'referencia_comp'
        ,'email_comp', 'pais_comp', 'ciudad_comp', 'direccion_comp', 'edo.nombre_edo as nomEdo', 'cp_comp', 'addDirecciones_comp'
        ,'pais_dire', 'ciudad_dire', 'edoDire.nombre_edo as nomEdo_dire', 'direccion_dire', 'codigo_postal_dire'
        ,'requiereFact', 'nombre_fact_comp', 'rfc_fact_comp', 'uso_fact_comp', 'regime_fact_comp'
        ,'cp_fact_comp', 'sub_total_comp', 'codigo_cupo', 'descuento_comp', 'envio_comp', 'total_comp')
        ->leftjoin('cupones', 'cupones.id', '=', 'compras.cupon_comp')
        ->leftjoin('direcciones', 'direcciones.id', '=', 'compras.direccionSeleccionada')
        ->leftjoin('estados_republica as edoDire', 'edoDire.id', '=', 'direcciones.estado_dire')
        ->leftjoin('estados_republica as edo', 'edo.id', '=', 'compras.estado_comp')
        ->where('codigo_comp', $idCompra)->first();
        $categorias = Productos_categorias::select('codigo_prca', 'nombre_prca', 'imagen_prca', DB::raw('COUNT(productos.id) as total_productos'))
        ->join('productos', 'productos.categoria_prod', '=', 'productos_categorias.id')
        ->where('productos.estatus_prod', '=', 'Activo')
        ->where('productos_categorias.estatus_prca', '=', 'Activo')
        ->groupBy('codigo_prca', 'nombre_prca', 'imagen_prca')
        ->get();
        $subcategorias =  Productos_subcategorias::select('codigo_prsu', 'nombre_prsu')->join('productos', 'productos.subcategoria_prod', '=', 'productos_subcategorias.id')
        ->where('estatus_prod', '=', 'Activo')->where('estatus_prsu', '=', 'Activo')->groupBy('codigo_prsu', 'nombre_prsu')->get();
        $payment_id = $idPaypal;
        $payment_type = "Paypal";
        $preference_id =  $idPaypal;
        $permitted_chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $token = "PACO" . substr(str_shuffle($permitted_chars), 0, 16);
        $comprobantes = Pagos_comprobantes::where('cod_pago_paco', $idCompra)->first();
        if(!$comprobantes){
            $ultimoRegistro = Pagos_comprobantes::latest()->first();
            if($ultimoRegistro){
                $idUltimo = $ultimoRegistro->id;
                $ultimo = $idUltimo + 1;
            }else{ $ultimo =  1; }
            if(intval($ultimo) == 0 || intval($ultimo) <= 10){ $ultimaSolicitud = "OC-00000". + $ultimo;}
            else if(intval($ultimo) >= 10 || intval($ultimo) <= 100){ $ultimaSolicitud = "OC-0000". + $ultimo;}
            else if(intval($ultimo) >= 100  || intval($ultimo) <= 1000){ $ultimaSolicitud = "OC-000". + $ultimo;}
            else if(intval($ultimo) >= 1000  || intval($ultimo) <= 10000){ $ultimaSolicitud = "OC-00". + $ultimo;}
            else if(intval($ultimo) >= 10000  || intval($ultimo) <= 100000){ $ultimaSolicitud = "OC-0". + $ultimo;}
            else if(intval($ultimo) >= 100000  || intval($ultimo) <= 1000000){ $ultimaSolicitud = "OC-". + $ultimo;}
            $pedidos = Pedidos::select('nombreProduct_pedi')->join('productos', 'productos.id', '=', 'pedidos.producto_pedi')->where('compra_pedi', '=', $compra->idPago)->get();
            $nombresProductos = $pedidos->pluck('nombreProduct_pedi')->toArray();
            $contenido = implode(',', $nombresProductos);
            $compania = "";
            if($compra->nombre_fact_comp){ $compania = $compra->nombre_fact_comp; }else{ $compania = "Sin compañia"; }
            $empresas = Datos_empresas::first();
            $dataId = "";
            if($empresas->envio_config == 'Por Paqueteria'){
                $response = Http::withHeaders([
                    'Authorization' => 'Token token=' . env('APISKYDROPX'),
                    'Content-Type' => 'application/json',
                ])->post('https://api.skydropx.com/v1/shipments', [
                    'address_from' => [
                        'province' => $empresas->provincia_config,
                        'city' =>  $empresas->ciudad_config,
                        'name' => $empresas->nombre_config,
                        'zip' => $empresas->codigo_postal_config,
                        'country' => 'MX',
                        'address1' => $empresas->direccion_config,
                        'company' => $empresas->empresa_config,
                        'phone' => $empresas->telefono_config,
                        'email' => $empresas->email_config,
                    ],
                    'parcels' => [
                        [
                            'weight' => $empresas->weight_config,
                            'distance_unit' => 'CM',
                            'mass_unit' => 'KG',
                            'height' => $empresas->height_config,
                            'width' => $empresas->width_config,
                            'length' => $empresas->length_config,
                        ],
                    ],
                    'address_to' => [
                        'province' =>  $compra->nomEdo,
                        'city' => $compra->ciudad_comp,
                        'name' => $compra->nombre_comp,
                        'zip' => strval($compra->cp_comp),
                        'country' => 'MX',
                        'address1' => $compra->direccion_comp,
                        'company' => $compania,
                        'phone' => $compra->telefono_comp,
                        'email' => $compra->email_comp,
                        'reference' => substr($compra->referencia_comp, 0, 25),
                        'contents' => $contenido,
                    ],
                    'consignment_note_class_code' => '51241100',
                    'consignment_note_packaging_code' => '4G',
                    'carriers' => [
                        ['name' => $empresas->paqueteria_envio_config],
                    ],
                ]);
                if ($response->successful()) {
                    // Si la solicitud fue exitosa, obtén los datos de la respuesta
                    $data = $response->json();
                    $dataId = $response['data']['id'];
                    //dd($data);
                } else {
                    $error = $response->body();
                }
            }
            $comprobantePagos = new Pagos_comprobantes();
            $comprobantePagos->codigo_paco = $token;
            $comprobantePagos->numero_pago = $ultimaSolicitud;
            $comprobantePagos->pago_paco = $compra->idPago;
            $comprobantePagos->cod_pago_paco = $compra->codigo_comp;
            $comprobantePagos->payment_id_paco = $payment_id;
            $comprobantePagos->payment_type_paco = $payment_type;
            $comprobantePagos->preference_id_paco = $preference_id;
            $comprobantePagos->id_envio_paqueteria_paco = $dataId;
            $comprobantePagos->fecha_paco = $fechaActual;
            $comprobantePagos->estatus_paco = "Pagado";
            $comprobantePagos->save();
            $productos = Pedidos::select('nombreProduct_pedi','producto_pedi', 'descripcion_pedi', 'costoProduct_pedi','cantidad_pedi','total_pedi','colorHtml_pedi')
            ->join('compras', 'compras.id', '=', 'pedidos.compra_pedi')
            ->where('compra_pedi', $compra->idPago)->get();
            foreach($productos as $producto){
                $listProducto = Productos::where('id', $producto->producto_pedi)->first();
                $listProducto->stock_prod =  $listProducto->stock_prod - $producto->cantidad_pedi;
                $listProducto->save();
            }
            $pdf = FacadePdf::loadView('tienda/comprobante_pago', compact('compra', 'productos', 'empresas', 'ultimaSolicitud'));
            $pdf->getDomPDF()->setHttpContext( stream_context_create([ 'ssl' => [ 'allow_self_signed'=> TRUE, 'verify_peer' => FALSE, 'verify_peer_name' => FALSE, ]]));
            $rutaPdf = public_path('/assets/pdf/comprobantes/comprobante_' . $token . '.pdf');
            $pdf->save($rutaPdf);
            $nombre = $compra->nombre_comp;
            $numero = $ultimaSolicitud;
            $subtotal = $compra->sub_total_comp;
            $total = $compra->total_comp;
            $correoReceptor = $compra->email_comp;
            $empresaCorreo = $empresas->empresa_config;
            $empresaImg = $empresas->logo_config;
            $empresaColor = $empresas->color_pricipal_config;
            $correoCliente = new envioComprobantePago($nombre, $numero ,$subtotal ,$total, $fechaActual, $empresaCorreo, $empresaImg, $empresaColor);
            $correoCliente->attach($rutaPdf, [ 'as' => 'Comprobante_' . substr(str_shuffle($permitted_chars), 0, 16) . '.pdf', 'mime' => 'application/pdf' ]);
            Mail::to($correoReceptor)->send($correoCliente);
            $rolAdministrador = Role::where('name', 'Administrador')->first();
            $administradores = User::where('status', 'Activo')->whereHas('roles', function ($query) use ($rolAdministrador) {
            $query->where('role_id', $rolAdministrador->id);
            })->orderBy('name', 'asc')->get();
            foreach ($administradores as $administrador) {
                $email = $administrador->email;
                $correoAdministrador = new envioAvisoCompra($nombre, $numero ,$subtotal ,$total, $fechaActual, $empresaCorreo, $empresaImg, $empresaColor);
                $correoAdministrador->attach($rutaPdf, [ 'as' => 'Comprobante_' . substr(str_shuffle($permitted_chars), 0, 16) . '.pdf', 'mime' => 'application/pdf']);
                Mail::to($email)->send($correoAdministrador);
            }
        }
        // return $pdf->setPaper('a4', 'portrait')->download('documento.pdf');
        // return $pdf->setPaper('a4', 'portrait')->stream('documento.pdf');
        if($cart){
            foreach ($cart as $item) {
                $cartDelete = session()->get('cart');
                $id = $item['token'];
                unset($cartDelete[$id]);
                session()->put('cart', $cartDelete);
            }
        }
        if($cupon){ session()->forget('cupon'); }
        if($favoritos){
            foreach ($favoritos as $item) {
                $favoritosDelete = session()->get('favoritos');
                $id = $item['token'];
                unset($favoritosDelete[$id]);
                session()->put('favoritos', $favoritosDelete);
            }
        }
        return view('tienda.compraConfirmada', compact('totalProducts','cart', 'cupon', 'favoritos',  'datosCupon',  'totalFavoritos', 'categorias', 'subcategorias'));
    }
    public function skydropx($cp){
        $empresas = Datos_empresas::first();
        $response = Http::withHeaders([
            'Authorization' => 'Token token='. env('APISKYDROPX'),
            'Content-Type' => 'application/json',
        ])->post('https://api.skydropx.com/v1/quotations', [
            'zip_from' => $empresas->codigo_postal_config,
            'zip_to' => $cp,
            'parcel' => [
                'weight' => $empresas->weight_config, // peso
                'height' => $empresas->height_config, // altura
                'width' => $empresas->width_config, // ancho
                'length' => $empresas->length_config, // longitud
            ],
            'carriers' => [
                ['name' => $empresas->paqueteria_envio_config],
            ],
        ]);
        if ($response->successful()) { return $response->json(); } else { return $response->body(); }
    }
    public function terminosCondiciones(){
        $cart = session()->get('cart');
        $favoritos = session()->get('favoritos');
        $cupon = session()->get('cupon');
        if($cupon){ $datosCupon  = Cupones::where('codigo_cupo', $cupon)->first(); }else{ $datosCupon = ""; }
        if($cart){ $totalProducts = count($cart); }else{ $totalProducts = ""; }
        if($favoritos){ $totalFavoritos = count($favoritos); }else{ $totalFavoritos = ""; }
        $categorias = Productos_categorias::select('codigo_prca', 'nombre_prca', 'imagen_prca', DB::raw('COUNT(productos.id) as total_productos'))
        ->join('productos', 'productos.categoria_prod', '=', 'productos_categorias.id')
        ->where('productos.estatus_prod', '=', 'Activo')
        ->where('productos_categorias.estatus_prca', '=', 'Activo')
        ->groupBy('codigo_prca', 'nombre_prca', 'imagen_prca')
        ->get();
        $subcategorias =  Productos_subcategorias::select('codigo_prsu', 'nombre_prsu')->join('productos', 'productos.subcategoria_prod', '=', 'productos_subcategorias.id')
        ->where('estatus_prod', '=', 'Activo')->where('estatus_prsu', '=', 'Activo')->groupBy('codigo_prsu', 'nombre_prsu')->get();
        return view('tienda.compraConfirmada', compact('totalProducts','cart', 'cupon', 'favoritos',  'datosCupon',  'totalFavoritos', 'categorias', 'subcategorias'));
    }
    public function politicasVentasEntregas(){
        $cart = session()->get('cart');
        $favoritos = session()->get('favoritos');
        if($cart){ $totalProducts = count($cart); }else{ $totalProducts = ""; }
        if($favoritos){ $totalFavoritos = count($favoritos); }else{ $totalFavoritos = ""; }
        return view('tienda.ventasEntregas', compact('totalFavoritos', 'totalProducts', 'condicionesVisualesMenu', 'tiemposUsosMenu', 'marcasMenu', 'laboratoriosMenu', 'generosMenu'));
    }
    public function politicasCancelacionesDevoluciones(){$cart = session()->get('cart');
        $favoritos = session()->get('favoritos');
        if($cart){ $totalProducts = count($cart); }else{ $totalProducts = ""; }
        if($favoritos){ $totalFavoritos = count($favoritos); }else{ $totalFavoritos = ""; }
        $condicionesVisualesMenu = Productos::select('codigo_prcv', 'nombre_prcv', 'codigo_prti')
        ->join('productos_condiciones_visuales', 'productos_condiciones_visuales.id', '=', 'condicion_visual_prod')->where('estatus_prod', '=', 'Activo')
        ->join('productos_tipos', 'productos_tipos.id', '=', 'productos.tipo_prod')->where('estatus_prcv', '=', 'Activo')->where('linea_prod', '=', 'Si')
        ->groupBy('codigo_prcv', 'nombre_prcv', 'codigo_prti')
        ->get();
        $tiemposUsosMenu = Productos::select('codigo_prtu','nombre_prtu', 'codigo_prti')
        ->join('productos_tiempos_usos', 'productos_tiempos_usos.id', '=', 'uso_prod')->where('estatus_prod', '=', 'Activo')
        ->join('productos_tipos', 'productos_tipos.id', '=', 'productos.tipo_prod')->where('estatus_prtu', '=', 'Activo')->where('linea_prod', '=', 'Si')
        ->groupBy('codigo_prtu', 'nombre_prtu', 'codigo_prti')->get();
        $marcasMenu = Productos::select('codigo_prma', 'nombre_prma', 'codigo_prti')
        ->join('productos_marcas', 'productos_marcas.id', '=', 'marca_prod')->where('estatus_prod', '=', 'Activo')
        ->join('productos_tipos', 'productos_tipos.id', '=', 'productos.tipo_prod')->where('estatus_prma', '=', 'Activo')->where('linea_prod', '=', 'Si')
        ->groupBy('codigo_prma', 'nombre_prma', 'codigo_prti')
        ->get();
        $laboratoriosMenu = Productos::select('codigo_prla','nombre_prla', 'codigo_prti')
        ->join('productos_laboratorios', 'productos_laboratorios.id', '=', 'laboratorio_prod')->where('estatus_prod', '=', 'Activo')
        ->join('productos_tipos', 'productos_tipos.id', '=', 'productos.tipo_prod')->where('estatus_prla', '=', 'Activo')->where('linea_prod', '=', 'Si')
        ->groupBy('codigo_prla','nombre_prla', 'codigo_prti')
        ->get();
        $generosMenu = Productos::select('genero_prod', 'codigo_prti')->where('estatus_prod', '=', 'Activo')->join('productos_tipos', 'productos_tipos.id', '=', 'productos.tipo_prod')->where('estatus_prti', '=', 'Activo')->groupBy('genero_prod', 'codigo_prti')->get();
        return view('tienda.cancelacionesDevoluciones', compact('totalFavoritos', 'totalProducts', 'condicionesVisualesMenu', 'tiemposUsosMenu', 'marcasMenu', 'laboratoriosMenu', 'generosMenu'));
    }
    public function avisoPrivacidad(){
        $cart = session()->get('cart');
        $favoritos = session()->get('favoritos');
        if($cart){ $totalProducts = count($cart); }else{ $totalProducts = ""; }
        if($favoritos){ $totalFavoritos = count($favoritos); }else{ $totalFavoritos = ""; }
        $condicionesVisualesMenu = Productos::select('codigo_prcv', 'nombre_prcv', 'codigo_prti')
        ->join('productos_condiciones_visuales', 'productos_condiciones_visuales.id', '=', 'condicion_visual_prod')->where('estatus_prod', '=', 'Activo')
        ->join('productos_tipos', 'productos_tipos.id', '=', 'productos.tipo_prod')->where('estatus_prcv', '=', 'Activo')->where('linea_prod', '=', 'Si')
        ->groupBy('codigo_prcv', 'nombre_prcv', 'codigo_prti')
        ->get();
        $tiemposUsosMenu = Productos::select('codigo_prtu','nombre_prtu', 'codigo_prti')
        ->join('productos_tiempos_usos', 'productos_tiempos_usos.id', '=', 'uso_prod')->where('estatus_prod', '=', 'Activo')
        ->join('productos_tipos', 'productos_tipos.id', '=', 'productos.tipo_prod')->where('estatus_prtu', '=', 'Activo')->where('linea_prod', '=', 'Si')
        ->groupBy('codigo_prtu', 'nombre_prtu', 'codigo_prti')->get();
        $marcasMenu = Productos::select('codigo_prma', 'nombre_prma', 'codigo_prti')
        ->join('productos_marcas', 'productos_marcas.id', '=', 'marca_prod')->where('estatus_prod', '=', 'Activo')
        ->join('productos_tipos', 'productos_tipos.id', '=', 'productos.tipo_prod')->where('estatus_prma', '=', 'Activo')->where('linea_prod', '=', 'Si')
        ->groupBy('codigo_prma', 'nombre_prma', 'codigo_prti')
        ->get();
        $laboratoriosMenu = Productos::select('codigo_prla','nombre_prla', 'codigo_prti')
        ->join('productos_laboratorios', 'productos_laboratorios.id', '=', 'laboratorio_prod')->where('estatus_prod', '=', 'Activo')
        ->join('productos_tipos', 'productos_tipos.id', '=', 'productos.tipo_prod')->where('estatus_prla', '=', 'Activo')->where('linea_prod', '=', 'Si')
        ->groupBy('codigo_prla','nombre_prla', 'codigo_prti')
        ->get();
        $generosMenu = Productos::select('genero_prod', 'codigo_prti')->where('estatus_prod', '=', 'Activo')->join('productos_tipos', 'productos_tipos.id', '=', 'productos.tipo_prod')->where('estatus_prti', '=', 'Activo')->groupBy('genero_prod', 'codigo_prti')->get();
        return view('tienda.avisoPrivacidad', compact('totalFavoritos', 'totalProducts', 'condicionesVisualesMenu', 'tiemposUsosMenu', 'marcasMenu', 'laboratoriosMenu', 'generosMenu'));
    }
    public function skydropxApi($cp){
        $response = Http::withHeaders([
            'Authorization' => 'Token token=' . env('APISKYDROPX'),
            'Content-Type' => 'application/json',
        ])->post('https://api.skydropx.com/v1/quotations', [
            'zip_from' => '02900',
            'zip_to' => '44100',
            'parcel' => [
                'weight' => '1',
                'height' => '10',
                'width' => '10',
                'length' => '10',
            ],
            'carriers' => [
                ['name' => 'DHL'],
                ['name' => 'Fedex'],
                ['name' => 'Estafeta'],
                ['name' => 'Redpack'],
                ['name' => 'Paqueteexpress'],
                ['name' => 'Sendex'],
                ['name' => 'Quiken'],
                ['name' => 'Tracusa'],
                ['name' => 'Dostavista'],
                ['name' => 'Ninetynineminutes'],
                ['name' => 'Ivoy'],
                ['name' => 'Jtexpress'],
            ],
        ]);
        if ($response->successful()) { $data = $response->json(); } else { $error = $response->body(); }
    }
    public function skydropxAddDireccion($codigo){
        $direccionSelec  = Direcciones::where('codigo_dire', $codigo)->first();
        $cp = $direccionSelec->codigo_postal_dire;
        $empresas = Datos_empresas::first();
        $response = Http::withHeaders([
            'Authorization' => 'Token token='. env('APISKYDROPX'),
            'Content-Type' => 'application/json',
        ])->post('https://api.skydropx.com/v1/quotations', [
            'zip_from' => $empresas->codigo_postal_config,
            'zip_to' => $cp,
            'parcel' => [
                'weight' => $empresas->weight_config, // peso
                'height' => $empresas->height_config, // altura
                'width' => $empresas->width_config, // ancho
                'length' => $empresas->length_config, // longitud
            ],
            'carriers' => [
                ['name' => $empresas->paqueteria_envio_config],
            ],
        ]);
        if ($response->successful()) { return $response->json(); } else { return $response->body(); }
    }
    public function eventos()
    {
        $cart = session()->get('cart');
        $cupon = session()->get('cupon');
        $favoritos = session()->get('favoritos');
        if($cupon){ $datosCupon  = Cupones::where('codigo_cupo', $cupon)->first(); }else{ $datosCupon = ""; }
        if($cart){ $totalProducts = count($cart); }else{ $totalProducts = ""; }
        if($favoritos){ $totalFavoritos = count($favoritos); }else{ $totalFavoritos = ""; }
        $categorias = Productos_categorias::select('codigo_prca', 'nombre_prca', 'imagen_prca', DB::raw('COUNT(productos.id) as total_productos'))
        ->leftjoin('productos', 'productos.categoria_prod', '=', 'productos_categorias.id')
        ->where('estatus_prod', '=', 'Activo')
        ->where('productos_categorias.estatus_prca', '=', 'Activo')
        ->groupBy('codigo_prca', 'nombre_prca', 'imagen_prca')
        ->get();
        $subcategorias =  Productos_subcategorias::select('codigo_prsu', 'nombre_prsu')->join('productos', 'productos.subcategoria_prod', '=', 'productos_subcategorias.id')
        ->where('estatus_prod', '=', 'Activo')->where('estatus_prsu', '=', 'Activo')->groupBy('codigo_prsu', 'nombre_prsu')->get();
        $banners = Banners::get();
        $eventos = Eventos::where('estatus_even', 'Activo')->get();
        return view('tienda.eventos', compact('categorias' ,'subcategorias', 'totalProducts', 'cart', 'datosCupon', 'totalFavoritos',  'eventos'));
    }
    public function eventosDatos($id)
    {
        $cart = session()->get('cart');
        $cupon = session()->get('cupon');
        $favoritos = session()->get('favoritos');
        if($cupon){ $datosCupon  = Cupones::where('codigo_cupo', $cupon)->first(); }else{ $datosCupon = ""; }
        if($cart){ $totalProducts = count($cart); }else{ $totalProducts = ""; }
        if($favoritos){ $totalFavoritos = count($favoritos); }else{ $totalFavoritos = ""; }
        $categorias = Productos_categorias::select('codigo_prca', 'nombre_prca', 'imagen_prca', DB::raw('COUNT(productos.id) as total_productos'))
        ->leftjoin('productos', 'productos.categoria_prod', '=', 'productos_categorias.id')
        ->where('estatus_prod', '=', 'Activo')
        ->where('productos_categorias.estatus_prca', '=', 'Activo')
        ->groupBy('codigo_prca', 'nombre_prca', 'imagen_prca')
        ->get();
        $subcategorias =  Productos_subcategorias::select('codigo_prsu', 'nombre_prsu')->join('productos', 'productos.subcategoria_prod', '=', 'productos_subcategorias.id')
        ->where('estatus_prod', '=', 'Activo')->where('estatus_prsu', '=', 'Activo')->groupBy('codigo_prsu', 'nombre_prsu')->get();
        $evento = Eventos::where('codigo_even', $id)->first();
        $boletos = Eventos_boletos::where('estatus_enbo', 'Activo')->where('evento_enbo', $evento->id)->get();
        return view('tienda.eventosDatos', compact('categorias' ,'subcategorias', 'totalProducts', 'cart', 'datosCupon', 'totalFavoritos', 'evento', 'boletos'));
    }
    public function pagarMercadoPagoBoletos(Request $request)
    {
        $rules = [
            'nombre' => 'required|string',
            'telefono' => 'required|string',
            'email' => 'required|email',
            'codigo' => 'required|string',
            'cantidad' => 'required|numeric|min:1',
        ];
        $messages = [
            'codigo.required' => 'El código es requerido.',
            'codigo.string' => 'El código debe ser una cadena de caracteres.',
            'nombre.required' => 'El nombre es requerido.',
            'nombre.string' => 'El nombre debe ser una cadena de caracteres.',
            'telefono.required' => 'El teléfono es requerido.',
            'telefono.string' => 'El teléfono debe ser una cadena de caracteres.',
            'email.required' => 'El correo electrónico es requerido.',
            'email.email' => 'El correo electrónico debe ser una dirección de correo válida.',
            'cantidad.required' => 'La cantidad es requerida.',
            'cantidad.numeric' => 'La cantidad debe ser un valor numérico.',
            'cantidad.min' => 'La cantidad debe ser mínimo 1.',
        ];
        $validator = Validator::make($request->all(), $rules, $messages);
        if ($validator->fails()) {
            $errors = $validator->errors()->all();
            return response()->json([
                'status' => 'error',
                'message' => implode(', ', $errors)
            ], 422);
        }
        $sanitizedData = $validator->validated();
        $nombre     = $sanitizedData['nombre'];
        $telefono   = $request->has('telefono') ? $sanitizedData['telefono'] : null;
        $email      = $sanitizedData['email'];
        $cantidad   = $sanitizedData['cantidad'];
        $codigo     = $sanitizedData['codigo'];
        $permitted_chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $tokenCompras = "EBVE" . substr(str_shuffle($permitted_chars), 0, 16);
        // Buscar boleto por código
        $boletos = Eventos_boletos::where('codigo_enbo', $codigo)->first();
        if (!$boletos) {
            return response()->json([
                'status' => 'error',
                'message' => 'Boleto no encontrado'
            ], 404);
        }
        // Verificar stock si es necesario
        if ($boletos->stock_enbo == 1 && $boletos->nro_boletos_enbo < $cantidad) {
            return response()->json([
                'status' => 'error',
                'message' => 'No hay suficientes boletos disponibles'
            ], 422);
        }
        $totalCost = 0;
        for ($i = 1; $i <= $cantidad; $i++) {
            $tokenVenta = "VENT" . substr(str_shuffle($permitted_chars), 0, 16);
            $compras = new Eventos_ventas();
            $compras->codigo_ebven = $tokenCompras;
            $compras->codigo_compra_ebven = $tokenVenta;
            if(Auth::check()){ $compras->usuario_ebven = Auth::user()->id; }
            $compras->boleto_ebven = $boletos->id;
            $compras->evento_ebven = $boletos->evento_enbo;
            $compras->precio_ebven = $boletos->precio_enbo;
            $compras->nombre_ebven = $nombre;
            $compras->telefono_ebven = $telefono;
            $compras->email_ebven = $email;
            $compras->estatus_ebven = 'Pendiente';
            $compras->save();
            $totalCost = $totalCost + $boletos->precio_enbo;
        }
        $evento = Eventos::where('id', $boletos->evento_enbo)->first()->nombre_even;
        $baseURLConfirmado = $request->root() . "/mercadopago/pago/boleto/confirmado/".$tokenCompras;
        $baseURLFallido = $request->root() . "/mercadopago/pago/boleto/fallido/".$tokenCompras;
        $baseURLPendiente = $request->root() . "/mercadopago/pago/boleto/pendiente/".$tokenCompras;
        MercadoPagoConfig::setAccessToken(env('MERCADOPAGO_ACCESS_TOKEN'));
        // Convertir el precio formateado de texto a un número
        $pagoTotalNumero = (float)$totalCost;
        $titulo = 'Compra de boleto(s) para el evento: ' . $evento;
        $client = new PreferenceClient();
        try {
            $preference = $client->create([
                "items" => [
                    [
                        "title" => $titulo,
                        "quantity" => 1,
                        "unit_price" => $pagoTotalNumero,
                        "currency_id" => "MXN",
                        "id" => $tokenCompras, // Código del item (reemplaza con tu código real de producto)
                        "description" => "Compra de boleto para eventos", // Descripción del item
                        "category_id" => "Tienda Virtual"
                    ]
                ],
                "payer" => [
                    "first_name" => $nombre, // Nombre del comprador (deberías obtenerlo de tus datos de usuario)
                    "last_name" => "" // Apellido del comprador (deberías obtenerlo de tus datos de usuario)
                ],
                "external_reference" => $tokenCompras,
                "auto_return" => "approved",
                "back_urls" => [
                    "success" => $baseURLConfirmado,
                    "failure" => $baseURLFallido,
                    "pending" => $baseURLPendiente
                ],
                "notification_url" => "https://tienda.elblogdelauto.com/webhook/mercadopago/tienda",
                "payment_methods" => [
                    "excluded_payment_methods" => [], // No excluimos métodos específicos, solo tipos
                    "excluded_payment_types" => [
                        ["id" => "bank_transfer"], // Excluye transferencias bancarias
                        ["id" => "ticket"] // Excluye pagos en efectivo
                    ],
                    "installments" => 1 // Solo permite pagos en una sola exhibición
                ]
            ]);
            return response()->json($preference);
        } catch (\MercadoPago\Exceptions\MPApiException $e) {
            return response()->json([
                'status' => 'error',
                'message' => 'Error al procesar el pago: ' . $e->getMessage()
            ], 422);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 'error',
                'message' => 'Error interno del servidor: ' . $e->getMessage()
            ], 500);
        }
    }
    public function estatusMercadoPagoBoletos($estatus, $id, Request $request)
    {
        $cart = session()->get('cart');
        $cupon = session()->get('cupon');
        $favoritos = session()->get('favoritos');
        if($cupon){ $datosCupon  = Cupones::where('codigo_cupo', $cupon)->first(); }else{ $datosCupon = ""; }
        if($cart){ $totalProducts = count($cart); }else{ $totalProducts = ""; }
        if($favoritos){ $totalFavoritos = count($favoritos); }else{ $totalFavoritos = ""; }
        $categorias = Productos_categorias::select('codigo_prca', 'nombre_prca', 'imagen_prca', DB::raw('COUNT(productos.id) as total_productos'))
        ->join('productos', 'productos.categoria_prod', '=', 'productos_categorias.id')
        ->where('productos.estatus_prod', '=', 'Activo')
        ->where('productos_categorias.estatus_prca', '=', 'Activo')
        ->groupBy('codigo_prca', 'nombre_prca', 'imagen_prca')
        ->get();
        $subcategorias =  Productos_subcategorias::select('codigo_prsu', 'nombre_prsu')->join('prductos', 'productos.subcategoria_prod', '=', 'productos_subcategorias.id')
        ->where('estatus_prod', '=', 'Activo')->where('estatus_prsu', '=', 'Activo')->groupBy('codigo_prsu', 'nombre_prsu')->get();
        if($estatus == "confirmado"){
            $fechaActual = Carbon::now('America/Mexico_City');
            $status = $request->get('status');
            $permitted_chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
            $token = substr(str_shuffle($permitted_chars), 0, 10);
            if($status == "approved"){
                $empresas = Datos_empresas::first();
                $payment_id = $request->get('payment_id');
                $payment_type = $request->get('payment_type');
                $preference_id = $request->get('preference_id');
                $compras = Eventos_ventas::where('codigo_ebven', $id)->get();
                foreach($compras as $compra){
                    $this->generarCodigoQR($compra->codigo_compra_ebven, $compra->codigo_compra_ebven.'.png');
                    $compra->qr_ebven = $compra->codigo_compra_ebven.'.png';
                    $compra->payment_id_ebven = $payment_id;
                    $compra->payment_type_ebven = $payment_type;
                    $compra->preference_id_ebven = $preference_id;
                    $compra->estatus_ebven = 'Pagado';
                    $compra->save();
                    $boletos = Eventos_boletos::where('id', $compra->boleto_ebven)->first();
                    if($boletos->stock_enbo == 1){
                        $boletos->nro_boletos_enbo = $boletos->nro_boletos_enbo - 1;
                        $boletos->save();
                    }
                }
                $ventas = Eventos_ventas::where('codigo_ebven', $id)->first();
                $nombre = $ventas->nombre_ebven;
                $total = Eventos_ventas::where('codigo_ebven', $id)->sum('precio_ebven');
                $evento = Eventos::where('id', $ventas->evento_ebven)->first()->nombre_even;
                $correoReceptor = $ventas->email_ebven;
                $empresaCorreo = $empresas->empresa_config;
                $empresaImg = $empresas->logo_config;
                $empresaColor = $empresas->color_pricipal_config;
                $correoContacto = new envioCorreoCompraBoleto($nombre, $evento,  $total, $fechaActual, $empresaCorreo, $empresaImg, $empresaColor, $compras);
                Mail::to($correoReceptor)->send($correoContacto);
                $rolAdministrador = Role::where('name', 'Administrador')->first();
                $administradores = User::where('status', 'Activo')->whereHas('roles', function ($query) use ($rolAdministrador) {
                $query->where('role_id', $rolAdministrador->id);
                })->orderBy('name', 'asc')->get();
                foreach ($administradores as $administrador) {
                    $email = $administrador->email;
                    $correoAdministrador = new envioAvisoCompraBoletos($nombre, $evento, $total, $fechaActual, $empresaCorreo, $empresaImg, $empresaColor);
                    Mail::to($email)->send($correoAdministrador);
                }
                return view('tienda.compraConfirmada', compact('totalProducts','cart', 'cupon', 'favoritos',  'datosCupon', 'totalFavoritos', 'categorias', 'subcategorias'));
            }else{
                return view('tienda.compraPediente',compact('totalProducts','cart', 'cupon', 'favoritos',  'datosCupon', 'totalFavoritos', 'categorias', 'subcategorias'));
            }
        }else if($estatus == "fallido"){
                return view('tienda.compraFallido',compact('totalProducts','cart', 'cupon', 'favoritos',  'datosCupon', 'totalProducts',  'totalFavoritos', 'categorias', 'subcategorias'));
        }else if($estatus == "pendiente"){
                return view('tienda.compraPediente',compact('totalProducts','cart', 'cupon', 'favoritos',  'datosCupon', 'totalFavoritos', 'categorias', 'subcategorias'));
        }else{
                return view('tienda.compraPediente',compact('totalProducts','cart', 'cupon', 'favoritos',  'datosCupon', 'totalProducts',  'totalFavoritos',));
        }
    }
    public function tokenComprastoken(Request $request)
    {
        Log::channel('mercadopago_log')->info('Inicia Mercado Pago');
        // Procesa el evento
        $data = $request->all();
        Log::channel('mercadopago_log')->info('Datos recibidos: ' . json_encode($data));
        $eventType = $data['type'] ?? null;
        switch ($eventType) {
            case 'payment':
                $paymentId = $data['data']['id'] ?? null;
                Log::channel('mercadopago_log')->info("ID Pago: {$paymentId}");
                if (!$paymentId) {
                    Log::channel('mercadopago_log')->error('ID de pago faltante en la notificación.');
                    return response()->json(['error' => 'Missing payment ID'], 400);
                }
                try {
                    MercadoPagoConfig::setAccessToken(env('MERCADOPAGO_ACCESS_TOKEN'));
                    $client = new PaymentClient();
                    $payment = $client->get($paymentId);
                    $tokenCompras = $payment->external_reference ?? null;
                    Log::channel('mercadopago_log')->info("ID Pago Encotrado: {$tokenCompras}");
                    Log::channel('mercadopago_log')->info("Estatus Del Pago Encotrado: {$payment->status}");
                    if (!$tokenCompras) {
                        Log::channel('mercadopago_log')->error('Referencia externa faltante en el pago.');
                        return response()->json(['error' => 'Missing external reference'], 400);
                    }
                    if ($payment->status === 'approved') {
                        Log::channel('mercadopago_log')->info("ID pago Servicio Pagado: {$tokenCompras}");
                        $compras = Eventos_ventas::where('codigo_ebven', $tokenCompras)->get();
                        foreach ($compras as $compraBoletos) {
                            Log::channel('mercadopago_log')->info("ID Pago Aprobado Boletos: {$compraBoletos->codigo_compra_ebven}");
                            $compraBoletos = Eventos_ventas::where('id', $compraBoletos->id)->first();
                            $compraBoletos->estatus_ebven = 'Pagado';
                            $compraBoletos->payment_id_ebven = $payment->id;
                            $compraBoletos->payment_type_ebven = $payment->payment_type_id;
                            $compraBoletos->preference_id_ebven = $payment->preference_id ?? null;
                            // Generar el código QR
                            $this->generarCodigoQR($compraBoletos->codigo_compra_ebven, $compraBoletos->codigo_compra_ebven . '.png');
                            $compraBoletos->qr_ebven = $compraBoletos->codigo_compra_ebven . '.png';
                            $compraBoletos->save();
                            $boletos = Eventos_boletos::where('id', $compraBoletos->boleto_ebven)->first();
                            Log::channel('mercadopago_log')->info("Boletos: {$boletos}");
                            if($boletos->stock_enbo == 1){
                                $boletos->nro_boletos_enbo = $boletos->nro_boletos_enbo - 1;
                                $boletos->save();
                            }
                        }
                        /// PAGO DE PRODUCTOS EN TIENDA
                        $permitted_chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
                        $ultimoRegistro = Pagos_comprobantes::latest()->first();
                        if($ultimoRegistro){
                            $idUltimo = $ultimoRegistro->id;
                            $ultimo = $idUltimo + 1;
                        }else{ $ultimo =  1; }
                        if(intval($ultimo) == 0 || intval($ultimo) <= 10){ $ultimaSolicitud = "OC-00000". + $ultimo;}
                        else if(intval($ultimo) >= 10 || intval($ultimo) <= 100){ $ultimaSolicitud = "OC-0000". + $ultimo;}
                        else if(intval($ultimo) >= 100  || intval($ultimo) <= 1000){ $ultimaSolicitud = "OC-000". + $ultimo;}
                        else if(intval($ultimo) >= 1000  || intval($ultimo) <= 10000){ $ultimaSolicitud = "OC-00". + $ultimo;}
                        else if(intval($ultimo) >= 10000  || intval($ultimo) <= 100000){ $ultimaSolicitud = "OC-0". + $ultimo;}
                        else if(intval($ultimo) >= 100000  || intval($ultimo) <= 1000000){ $ultimaSolicitud = "OC-". + $ultimo;}
                        $compra = Compras::where('codigo_comp', $tokenCompras)->first();
                        if($compra){
                            $pago = Pagos_comprobantes::where('cod_pago_paco', $compra->codigo_comp)->first();
                            $pago->payment_id_paco = $payment->id;
                            $pago->payment_type_paco = $payment->payment_type_id;
                            $pago->preference_id_paco = $payment->preference_id ?? null;
                            $pago->estatus_paco = 'Pagado';
                            $pago->save();
                            $tokenPago = "PACO" . substr(str_shuffle($permitted_chars), 0, 16);
                            $comprobantePagos = new Pagos_comprobantes();
                            $comprobantePagos->codigo_paco = $tokenPago;
                            $comprobantePagos->numero_pago = $ultimaSolicitud;
                            $comprobantePagos->pago_paco = $compra->id;
                            $comprobantePagos->cod_pago_paco = $compra->codigo_comp;
                            $comprobantePagos->payment_id_paco = $payment->id;
                            $comprobantePagos->payment_type_paco = $payment->payment_type_id;
                            $comprobantePagos->preference_id_paco =  $payment->preference_id ?? null;;
                            $comprobantePagos->id_envio_paqueteria_paco = null;
                            $comprobantePagos->fecha_paco = Carbon::now('America/Mexico_City');
                            $comprobantePagos->estatus_paco = "Pagado";
                            $comprobantePagos->save();
                        }
                        Log::channel('mercadopago_log')->info('Pago aprobado', [
                            'tokenCompras' => $tokenCompras,
                            'paymentId' => $paymentId
                        ]);
                    } elseif (in_array($payment->status, ['rejected', 'cancelled'])) {
                        Log::channel('mercadopago_log')->info("ID pago Servicio Rechazado: {$tokenCompras}");
                        $comprasboletos = Eventos_ventas::where('codigo_ebven', $tokenCompras)->get();
                        foreach ($comprasboletos as $compraBoletos) {
                            Log::channel('mercadopago_log')->info("ID Pago Aprobado Boletos Rechazado: {$compraBoletos->codigo_compra_ebven}");
                            $compraBoletos->estatus_ebven = 'Rechazado';
                            $compraBoletos->payment_id_ebven = $payment->id ?? null;
                            $compraBoletos->payment_type_ebven = $payment->payment_type_id ?? null;
                            $compraBoletos->preference_id_ebven = $payment->preference_id ?? null;
                            $compraBoletos->save();
                        }
                        $codigoCompra = Compras::where('codigo_comp', $tokenCompras)->first()->codigo_comp;
                        $comprasTienda = Pagos_comprobantes::where('cod_pago_paco', $codigoCompra)->first();
                        if($comprasTienda){
                            Log::channel('mercadopago_log')->info("ID Pago Aprobado Tienda Rechazado: {$comprasTienda->numero_pago}");
                            $comprasTienda->payment_id_paco = $payment->id ?? null;
                            $comprasTienda->payment_type_paco = $payment->payment_type_id ?? null;
                            $comprasTienda->preference_id_paco = $payment->preference_id ?? null;
                            $compraBoletos->estatus_paco = 'Rechazado';
                            $comprasTienda->save();
                        }
                        Log::channel('mercadopago_log')->info('Pago rechazado o cancelado', [
                            'tokenCompras' => $tokenCompras,
                            'status' => $payment->status
                        ]);
                    }
                    return response()->json(['status' => 'success']);
                } catch (\Throwable $e) {
                    Log::channel('mercadopago_log')->error('Error procesando webhook', [
                        'error' => $e->getMessage(),
                        'trace' => $e->getTraceAsString()
                    ]);
                    return response()->json(['error' => 'Internal Server Error'], 500);
                }
            default:
                Log::channel('mercadopago_log')->warning("Evento no manejado: {$eventType}");
                return response()->json(['success' => true]);
        }
    }
    private function generarCodigoQR($texto, $nombreArchivo)
    {
        try {
            $rutaCarpeta = public_path('assets/img/qrs');
            if (!file_exists($rutaCarpeta)) {
                mkdir($rutaCarpeta, 0755, true);
            }
            $qrCode = new QrCode($texto);
            $writer = new PngWriter();
            $result = $writer->write($qrCode);
            $rutaCompleta = $rutaCarpeta . '/' . $nombreArchivo;
            file_put_contents($rutaCompleta, $result->getString());
            return $nombreArchivo;
        } catch (\Exception $e) {
            Log::channel('mercadopago_log')->error("Error al generar QR: " . $e->getMessage());
            return null;
        }
    }
}
