<?php

namespace App\Http\Middleware;


use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class CheckEstatus
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
      //  return $next($request);
      $user = Auth::user();

        if ($user && isset($user->status) && $user->status !== 'Activo') {
            Auth::logout(); // Desconectar al usuario inactivo
            return redirect()->route('login')->with('error', 'Tu cuenta está inactiva');
        }

        return $next($request);
    }
}
