<?php
namespace App\Http\Middleware;
use Closure;
use Illuminate\Http\Request;
use Google\Cloud\RecaptchaEnterprise\V1\Client\RecaptchaEnterpriseServiceClient;
use Google\Cloud\RecaptchaEnterprise\V1\CreateAssessmentRequest;
use Google\Cloud\RecaptchaEnterprise\V1\Event;
use Google\Cloud\RecaptchaEnterprise\V1\Assessment;
class VerifyRecaptcha
{
    public function handle(Request $request, Closure $next)
    {
        $token = $request->input('g-recaptcha-response');
        if (!$token) {
            return redirect()->back()->withErrors(['error' => 'Por favor, completa el reCAPTCHA.']);
        }
        // Inicializa el cliente de reCAPTCHA Enterprise
        $client = new RecaptchaEnterpriseServiceClient();
        // Define el nombre del proyecto (reemplaza 'TU_PROJECT_ID' con tu ID de proyecto de Google Cloud)
        $projectName = $client->projectName('TU_PROJECT_ID');
        // Crea un evento para la evaluación
        $event = (new Event())
            ->setSiteKey(config('services.recaptcha_enterprise.site_key'))
            ->setToken($token);
        // Crea una evaluación
        $assessment = (new Assessment())
            ->setEvent($event);
        // Crea la solicitud de evaluación
        $createAssessmentRequest = (new CreateAssessmentRequest())
            ->setParent($projectName)
            ->setAssessment($assessment);
        try {
            // Realiza la evaluación
            $response = $client->createAssessment($createAssessmentRequest);
            // Verifica si el token es válido
            if ($response->getTokenProperties()->getValid() === false) {
                return redirect()->back()->withErrors(['error' => 'Token de reCAPTCHA inválido.']);
            }
            // Verifica la puntuación (ajusta el umbral según tus necesidades)
            if ($response->getRiskAnalysis()->getScore() < 0.5) {
                return redirect()->back()->withErrors(['error' => 'Actividad sospechosa detectada.']);
            }
        } catch (\Exception $e) {
            return redirect()->back()->withErrors(['error' => 'Error al validar reCAPTCHA: ' . $e->getMessage()]);
        }
        return $next($request);
    }
}
