<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class envioCambioEstatus extends Mailable
{
    use Queueable, SerializesModels;
    public $empresa;
    public $logo;
    public $nombre;
    public $numero;
    public $estatus;

    /**
     * Create a new message instance.
     */
    public function __construct($empresa, $logo, $nombre, $numero, $estatus)
    {
        $this->empresa = $empresa;
        $this->logo = $logo;
        $this->nombre = $nombre;
        $this->numero = $numero;
        $this->estatus = $estatus;

    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Estatus de su producto No. '. $this->numero . '',
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        return new Content(
            view: 'pedidos.correoCambioEstatus',
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
}
