<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('productos', function (Blueprint $table) {
            $table->id();
            $table->string('codigo_prod');
            $table->string('nombre_prod');
            $table->text('descripcion_prod');
            $table->decimal('precio_compra_prod', 19, 2);
            $table->decimal('precio_venta_prod', 19, 2);
            $table->decimal('descuento_prod', 19, 2)->nullable();
            $table->integer('stock_prod');
            $table->integer('categoria_prod');
            $table->integer('subcategoria_prod');
            $table->string('marca_prod')->nullable();
            $table->string('estatus_prod');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('productos');
    }
};
