<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('clientes', function (Blueprint $table) {
            $table->id();
            $table->string('codigo_clie');
            $table->integer('usuario_clie');
            $table->string('telefono_clie')->nullable();
            $table->string('compania_clie')->nullable();
            $table->string('pais_clie')->nullable();
            $table->string('ciudad_clie')->nullable();
            $table->string('estado_clie')->nullable();
            $table->string('direccion_clie')->nullable();
            $table->integer('codigo_postal_clie')->nullable();
            $table->string('nombre_facturacion_clie')->nullable();
            $table->string('rfc_facturacion_clie')->nullable();
            $table->string('email_facturacion_clie')->nullable();
            $table->string('uso_facturacion_clie')->nullable();
            $table->string('regimen_facturacion_clie')->nullable();
            $table->string('constancia_facturacion_clie')->nullable();
            $table->integer('codigo_postal_facturacion_clie')->nullable();
            $table->string('estatus_clie');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('clientes');
    }
};
