<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pedidos', function (Blueprint $table) {
            $table->id();
            $table->string('codigo_pedi');
            $table->integer('compra_dire');
            $table->integer('producto_dire');
            $table->string('colorHtml_pedi')->nullable();
            $table->string('imagenProduct_pedi')->nullable();
            $table->string('categoriaProduct_pedi')->nullable();
            $table->string('subcategoriaProduct_pedi')->nullable();
            $table->text('descripcion_pedi')->nullable();
            $table->string('nombreProduct_pedi')->nullable();
            $table->string('costoProduct_pedi')->nullable();
            $table->integer('cantidad_pedi')->nullable();
            $table->decimal('total_pedi',19, 2);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pedidos');
    }
};
