<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('compras', function (Blueprint $table) {
            $table->id();
            $table->string('codigo_comp');
            $table->string('numero_comp');
            $table->integer('usuario_comp')->nullable();
            $table->string('nombre_comp')->nullable();
            $table->string('telefono_comp')->nullable();
            $table->string('email_comp')->nullable();
            $table->string('pais_comp')->nullable();
            $table->string('ciudad_comp')->nullable();
            $table->string('direccion_comp')->nullable();
            $table->integer('estado_comp')->nullable();
            $table->integer('cp_comp')->nullable();
            $table->boolean('addDirecciones_comp')->nullable();
            $table->boolean('direccionSeleccionada')->nullable();
            $table->string('requiereFact')->nullable();
            $table->string('nombre_fact_comp')->nullable();
            $table->string('rfc_fact_comp')->nullable();
            $table->string('uso_fact_comp')->nullable();
            $table->string('email_fact_comp')->nullable();
            $table->string('regime_fact_comp')->nullable();
            $table->integer('cp_fact_comp')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('compras');
    }
};
