<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('eventos_boletos', function (Blueprint $table) {
            $table->id();
            $table->string('codigo_enbo');
            $table->integer('evento_enbo');
            $table->string('nombre_enbo');
            $table->decimal('precio_enbo', 19, 2);
            $table->string('estatus_enbo');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('eventos_boletos');
    }
};
