<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('eventos_ventas', function (Blueprint $table) {
            $table->id();
            $table->string('codigo_ebven');
            $table->integer('evento_ebven');
            $table->decimal('precio_ebven', 19, 2);
            $table->string('nombre_ebven');
            $table->string('telefono_ebven');
            $table->string('email_ebven');
            $table->string('qr_ebven');
            $table->string('payment_id_ebven')->nullable();
            $table->string('payment_type_ebven')->nullable();
            $table->string('preference_id_ebven')->nullable();
            $table->string('estatus_ebven');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('eventos_ventas');
    }
};
