    <!DOCTYPE html>
    <html lang="en">
    <head>
    <meta charset="utf-8">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <title class="nombre_empresa"></title>
    <meta content="" name="description">
    <meta content="" name="keywords">
    <!-- Favicons -->
    <link href="{!! asset('assets/img/favicon.png') !!}" rel="icon">
    <link href="{!! asset('assets/img/apple-touch-icon.png') !!}" rel="apple-touch-icon">
    <!-- Google Fonts -->
    <link href="https://fonts.gstatic.com" rel="preconnect">
    <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">
    <!-- Vendor CSS Files -->
    <link href="{!! asset('assets/vendor/bootstrap/css/bootstrap.min.css') !!}" rel="stylesheet">
    <link href="{!! asset('assets/vendor/bootstrap-icons/bootstrap-icons.css') !!}" rel="stylesheet">
    <link href="{!! asset('assets/vendor/boxicons/css/boxicons.min.css') !!}" rel="stylesheet">
    <link href="{!! asset('assets/vendor/quill/quill.snow.css') !!}" rel="stylesheet">
    <link href="{!! asset('assets/vendor/quill/quill.bubble.css') !!}" rel="stylesheet">
    <link href="{!! asset('assets/vendor/remixicon/remixicon.css') !!}" rel="stylesheet">
    <link href="{!! asset('assets/vendor/simple-datatables/style.css') !!}" rel="stylesheet">
    <!-- Template Main CSS File -->
    <link href="{!! asset('assets/css/style.css') !!}" rel="stylesheet">
    </head>
    <body>
    <main>
        <div class="container">
        <section class="section register min-vh-100 d-flex flex-column align-items-center justify-content-center py-4">
            <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-4 col-md-6 d-flex flex-column align-items-center justify-content-center">
                <div class="d-flex justify-content-center py-4">
                    <a href="index.html" class="logo d-flex align-items-center w-auto">
                    <img  class="logo_empresa" alt="logo">
                    <span class="d-none d-lg-block"></span>
                    </a>
                </div><!-- End Logo -->
                <div class="card mb-3">
                    <div class="card-body">
                    <div class="pt-4 pb-2">
                        <h5 class="card-title text-center pb-0 fs-4">Crear cuenta</h5>
                        <p class="text-center small">Customer Relationship Management</p>
                    </div>
                    <form class="row g-3" method="POST" action="{{ route('register') }}" novalidate>
                        @csrf
                        <div class="col-12">
                        <label for="yourName" class="form-label">Nombre completo</label>
                        <input type="text" name="name" class="form-control @error('name') is-invalid @enderror" value="{{ old('name') }}" id="yourName">
                        @error('name')
                        <h6 class="text-center text-danger">{{ $message }}</h6>
                        @enderror
                        </div>
                        <div class="col-12">
                        <label for="yourEmail" class="form-label">Correo electrónico</label>
                            <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">@</span>
                            <input type="text" name="email" class="form-control @error('email') is-invalid @enderror" id="yourEmail" value="{{ old('email') }}">
                            </div>
                            @error('email')
                            <h6 class="text-center text-danger">{{ $message }}</h6>
                            @enderror
                        </div>
                        <div class="col-12">
                            <label for="yourPassword" class="form-label">Contraseña</label>
                            <input type="password" name="password" class="form-control @error('password') is-invalid @enderror" id="yourPassword" value="{{ old('password') }}">
                            @error('password')
                                <h6 class="text-center text-danger">{{ $message }}</h6>
                            @enderror
                        </div>
                        <div class="col-12">
                        <label for="yourPasswords" class="form-label">Confirmar contraseña</label>
                        <input type="password" name="password_confirmation" class="form-control" id="yourPasswords">
                        </div>
                        <div class="col-12">
                        <div class="form-check">
                            <input class="form-check-input" name="terms" type="checkbox" id="acceptTerms">
                            <label class="form-check-label" for="acceptTerms">Acepto los <a href="#">terminos y condiciones</a></label>
                            @if ($errors->has('terms'))
                                    @foreach ($errors->get('terms') as $error)
                                        <h6 class="text-center text-danger">{{ $error }}</h6>
                                    @endforeach
                                @endif
                            </div>
                        </div>
                        <div class="col-12">
                        <button class="btn btn-primary w-100" type="submit">Crear cuenta</button>
                        </div>
                        <div class="col-12">
                        <p class="small mb-0">¿Ya tienes una cuenta? <a href="{{ route('login') }}">Acceder</a></p>
                        </div>
                    </form>
                    </div>
                </div>
                <div class="credits">
                    Desarrollado por  <a href="">Corporativo Loruna</a>
                    </div>
                </div>
            </div>
            </div>
        </section>
        </div>
    </main><!-- End #main -->
    <a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>
    <!-- Vendor JS Files -->
    <script src="{!! asset('assets/vendor/apexcharts/apexcharts.min.js') !!}"></script>
    <script src="{!! asset('assets/vendor/bootstrap/js/bootstrap.bundle.min.js') !!}"></script>
    <script src="{!! asset('assets/vendor/chart.js/chart.umd.js') !!}"></script>
    <script src="{!! asset('assets/vendor/echarts/echarts.min.js') !!}"></script>
    <script src="{!! asset('assets/vendor/quill/quill.min.js') !!}"></script>
    <script src="{!! asset('assets/vendor/simple-datatables/simple-datatables.js') !!}"></script>
    <script src="{!! asset('assets/vendor/tinymce/tinymce.min.js') !!}"></script>
    <script src="{!! asset('assets/vendor/php-email-form/validate.js') !!}"></script>
    <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
    <!-- Template Main JS File -->
    <script src="{!! asset('assets/js/main.js') !!}"></script>
    <script>
        const termsCheckbox = document.getElementById('acceptTerms');
        const submitButton = document.getElementById('submitButton');
        termsCheckbox.addEventListener('change', () => {
        submitButton.disabled = !termsCheckbox.checked;
        });
        $(document).ready(function() {
                $.ajax({
                    url: '{{ route('empresa') }}', // URL de la ruta
                    type: 'GET',
                    success: function(response) {
                        var nombreEmpresa = response.empresa_config;
                        $('.nombre_empresa').text(nombreEmpresa)
                        var logo = response.logo_config;
                        if (typeof logo !== 'undefined' && logo) {
                            var src = "{!! asset('assets/img/logos/') !!}/" + logo;
                            $('.logo_empresa').attr('src', src);
                        } else {
                            var src = "{!! asset('assets/img/logos/logo.png') !!}";
                            $('.logo_empresa').attr('src', src);
                        }
                    },
                    error: function(xhr) {
                        console.error('Error:', xhr);
                    }
                });
            });
    </script>
</body>
</html>
