@php
$VerEditor = auth()->user()->can('Calificaciones - Visor') || auth()->user()->can('Calificaciones - Editor')
@endphp
@if($VerEditor)
@extends('layouts/app')
@section('tituloModulo', 'CALIFICACIONES')
@section('contenido')
<div class="card">
    <div class="card-body">
        <div class="datatable-wrapper datatable-loading no-footer sortable searchable fixed-columns">
            <div class="datatable-container">
                <table class="table datatable datatable-table">
                    <thead>
                        <tr class="text">
                            <th data-sortable="true" scope="col">USUARIO</th>
                            <th data-sortable="true" scope="col">PRODUCTO</th>
                            <th data-sortable="true" scope="col">RESEÑA</th>
                            <th data-sortable="true" scope="col">CALIFICACIÓN</th>
                            <th data-sortable="true" scope="col">FECHA</th>
                            <th data-sortable="true" scope="col">ESTATUS</th>
                            <th data-sortable="true" scope="col">ACCIÓN</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($datos as $item)
                        <tr>
                            <td data-title="USUARIO">{{ $item->name }}</td>
                            <td data-title="PRODUCTO"><a href="{{ route('detalle.producto', $item->codigo_prod)}}">{{ $item->nombre_prod }}</a></td>
                            <td data-title="RESEÑA">{{ $item->resena_calif }}</td>
                            <td data-title="CALIFICACIÓN">
                            @php
                            $filledStars = $item->calificacion_calif;
                            $emptyStars = 5 - $filledStars;
                            @endphp
                            @for ($i = 0; $i < $filledStars; $i++)
                            <i class="fas fa-star" style="color: #EABE3F;"></i>
                            @endfor
                            @for ($i = 0; $i < $emptyStars; $i++)
                                <i class="far fa-star" style="color: #EABE3F;"></i>
                            @endfor
                            </td>
                            <td data-title="FECHA">{{ date("d/m/Y", strtotime($item->fecha_calif)) }}</td>
                            <td data-title="ESTATUS">
                                @if($item->estatus_calif == 'Aprobado')
                                    <span class="badge bg-success">{{$item->estatus_calif}}</span>
                                @endif
                                @if ($item->estatus_calif == 'Pendiente por aprobar')
                                    <span class="badge bg-warning">{{$item->estatus_calif}}</span>
                                @endif
                            </td>
                            @can('Calificaciones - Editor')
                            <td data-title="ACCIÓN">
                                <div class="btn-group">
                                    <button type="button" class="btn btn-outline-primary dropdown-toggle btnTabla"
                                        data-bs-toggle="dropdown" aria-expanded="false">Acción <i
                                            class="mdi mdi-chevron-down"></i></button>
                                    <div class="dropdown-menu">
                                        <form action="{{ route('calificaciones.aprobar', $item->codigo_calif) }}">
                                            @csrf
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx bx-check-circle"></i> Aprobar
                                            </button>
                                        </form>
                                        <form action="{{ route('calificaciones.pendiente', $item->codigo_calif) }}">
                                            @csrf
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx bx-x-circle"></i> Pendiente por aprobar
                                            </button>
                                        </form>
                                        <form action="{{ route('calificaciones.delete', $item->codigo_calif) }}" class="form-delete">
                                            @csrf
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx  bxs-trash"></i> Eliminar
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </td>
                            @endcan
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <div class="datatable-bottom">
                <nav class="datatable-pagination">
                    <ul class="datatable-pagination-list"></ul>
                </nav>
            </div>
        </div>
    </div>
</div>
@endsection
@endif

