@php
$VerEditor = auth()->user()->can('Productos / Categorías - Visor') || auth()->user()->can('Productos / Categorías - Editor')
@endphp
@if($VerEditor)
@extends('layouts/app')
@section('tituloModulo', 'CATEGORÍAS')
@section('contenido')
<div class="card">
    <div class="card-body">
        @can('Productos / Categorías - Editor')
        <button type="button" class="btn btn-success mt-3" data-bs-toggle="modal" data-bs-target="#crear">
            <i class="bx bxs-folder-plus"></i> Agregar categoría
        </button>
        <div class="modal fade" id="crear" tabindex="-1">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Agregar categoría</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form action="{{ route('categorias.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                    <div class="modal-body">
                        <label class="control-label is-required">Nombre</label>
                        <input class="form-control" type="text" name="nombre" required>
                        <label class="control-label">Imagen en tienda</label>
                        <input class="form-control" type="file" name="imagen" required>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success"><i class="bx bx-save"></i> Guardar</button>
                        <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="bx  bxs-x-circle"></i> Cerrar</button>
                    </div>
                    </form>
                </div>
            </div>
        </div>
        @endcan
        <div class="datatable-wrapper datatable-loading no-footer sortable searchable fixed-columns">
            <div class="datatable-container">
                <table class="table datatable datatable-table">
                    <thead>
                        <tr class="text">
                            <th data-sortable="true" scope="col">IMAGEN</th>
                            <th data-sortable="true" scope="col">NOMBRE</th>
                            <th data-sortable="true" scope="col">ESTATUS</th>
                            @can('Productos / Categorías - Editor')
                            <th data-sortable="true" scope="col">ACCIÓN</th>
                            @endcan
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($datos as $item)
                        <tr>
                            <td data-title="IMAGEN">
                                @if ($item->imagen_prca)
                                <img class="img-fluid" src="{!! asset('assets/img/categorias/' . $item->imagen_prca ) !!}" alt="" style="width: 50px;">
                                @else
                                <img class="img-fluid" src="{!! asset('assets/img/sinimagen.png' ) !!}" alt="" style="width: 50px;">
                                @endif
                            </td>
                            <td data-title="NOMBRE">{{ $item->nombre_prca }}</td>
                            <td data-title="ESTATUS">
                                @if($item->estatus_prca == 'Activo')
                                    <span class="badge bg-success">{{$item->estatus_prca}}</span>
                                @endif
                                @if ($item->estatus_prca == 'Inactivo')
                                    <span class="badge bg-danger">{{$item->estatus_prca}}</span>
                                @endif
                            </td>
                            @can('Productos / Categorías - Editor')
                            <td data-title="ACCIÓN">
                                <div class="btn-group">
                                    <button type="button" class="btn btn-outline-primary dropdown-toggle btnTabla"
                                        data-bs-toggle="dropdown" aria-expanded="false">Acción <i
                                            class="mdi mdi-chevron-down"></i></button>
                                    <div class="dropdown-menu">
                                        <button type="button" class="btn btn-outline-success mt-2 dropdown-item" data-bs-toggle="modal" data-bs-target="#editar{{  $item->codigo_prca }}">
                                            <i class="bx bxs-edit"></i> Editar
                                        </button>
                                        <form action="{{ route('categorias.activate', $item->codigo_prca) }}" method="POST" enctype="multipart/form-data" class="form-activar">
                                            @csrf
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx bx-check-circle"></i> Activar
                                            </button>
                                        </form>
                                        <form action="{{ route('categorias.inactivate', $item->codigo_prca) }}" method="POST" enctype="multipart/form-data" class="form-inactivar">
                                            @csrf
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx bx-x-circle"></i> Inactivar
                                            </button>
                                        </form>
                                        <form action="{{ route('categorias.delete', $item->codigo_prca) }}" method="POST" enctype="multipart/form-data" class="form-delete">
                                            @csrf
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx  bxs-trash"></i> Eliminar
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </td>
                            @endcan
                        </tr>
                        @can('Productos / Categorías - Editor')
                        <div class="modal fade" id="editar{{  $item->codigo_prca }}" tabindex="-1">
                            <div class="modal-dialog modal-lg">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title">Editar categoría</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <form action="{{ route('categorias.update',  $item->codigo_prca) }}" method="POST" enctype="multipart/form-data">
                                        @csrf
                                    <div class="modal-body">
                                        <div class="row">
                                            <div class="col-md-12 col-12 text-center">
                                                @if ($item->imagen_prca)
                                                <img class="img-fluid" src="{!! asset('assets/img/categorias/' . $item->imagen_prca ) !!}" alt="" style="width: 250px;">
                                                @else
                                                <img class="img-fluid" src="{!! asset('assets/img/sinimagen.png' ) !!}" alt="" style="width: 250px;"
                                                @endif
                                            </div>
                                            <div class="col-md-12 col-12">
                                                <label class="control-label is-required">Nombre</label>
                                                <input class="form-control" value="{{ $item->nombre_prca }}" type="text" name="nombre" required>
                                            </div>
                                            <div class="col-md-12 col-12">
                                                <label class="control-label">Imagen en tienda</label>
                                                <input class="form-control" type="file" name="imagen">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="submit" class="btn btn-success"><i class="bx bx-save"></i> Actualizar</button>
                                        <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="bx  bxs-x-circle"></i> Cerrar</button>
                                    </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        @endcan
                        @endforeach
                    </tbody>
                </table>
            </div>
            <div class="datatable-bottom">
                <nav class="datatable-pagination">
                    <ul class="datatable-pagination-list"></ul>
                </nav>
            </div>
        </div>
    </div>
</div>
@endsection
@endif

