@php
$VerEditor = auth()->user()->can('Cupones - Visor') || auth()->user()->can('Cupones - Editor')
@endphp
@if($VerEditor)
@extends('layouts/app')
@section('tituloModulo', 'CUPONES')
@section('contenido')
<div class="card">
    <div class="card-body">
        @can('Cupones - Editor')
        <button type="button" class="btn btn-success mt-3" data-bs-toggle="modal" data-bs-target="#crear">
            <i class="bx bxs-folder-plus"></i> Agregar cupón
        </button>
        <div class="modal fade" id="crear" tabindex="-1">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Agregar cupón</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form action="{{ route('cupones.store') }}" method="POST">
                        @csrf
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6 col-12">
                                <label class="control-label is-required">Fecha de inicio</label>
                                <input class="form-control" type="date" name="fecha_inicio" required>
                            </div>
                            <div class="col-md-6 col-12">
                                <label class="control-label is-required">Fecha de vencimiento</label>
                                <input class="form-control" type="date" name="fecha_fin" required>
                            </div>
                            <div class="col-md-6 col-12">
                                <label class="control-label is-required">Cantidad en % o $</label>
                                <input id="input-currency" class="form-control input-mask text-left importe"
                                data-inputmask="'alias': 'numeric', 'groupSeparator': ',', 'digits': 2, 'digitsOptional': false, 'prefix': '', 'placeholder': '0'"
                                name="cantidad"  required>
                            </div>
                            <div class="col-md-6 col-12">
                                <label class="control-label is-required">Tipo de cupón</label>
                                <select class="form-select" name="tipo" required>
                                    <option value="">Seleccione el tipo de cupón</option>
                                    <option value="Porcentaje">Descuento por porcentaje</option>
                                    <option value="Monetario">Descuento por moneda</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success"><i class="bx bx-save"></i> Guardar</button>
                        <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="bx  bxs-x-circle"></i> Cerrar</button>
                    </div>
                    </form>
                </div>
            </div>
        </div>
        @endcan
        <div class="datatable-wrapper datatable-loading no-footer sortable searchable fixed-columns">
            <div class="datatable-container">
                <table class="table datatable datatable-table">
                    <thead>
                        <tr class="text">
                            <th data-sortable="true" scope="col">CÓDIGO</th>
                            <th data-sortable="true" scope="col">FECHA DE INICIO</th>
                            <th data-sortable="true" scope="col">FECHA DE VENCIMIENTO</th>
                            <th data-sortable="true" scope="col">DESCUENTO EN % O $</th>
                            <th data-sortable="true" scope="col">TIPO DE DESCUENTO</th>
                            <th data-sortable="true" scope="col">ESTATUS</th>
                            @can('Cupones - Editor')
                            <th data-sortable="true" scope="col">ACCIÓN</th>
                            @endcan
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($datos as $item)
                        <tr>
                            <td data-title="CÓDIGO">{{ $item->codigo_cupo }}</td>
                            <td data-title="FECHA DE INICIO">{{ date("d/m/Y", strtotime($item->fecha_inicio_cupo)) }}</td>
                            <td data-title="FECHA DE VENCIMIENTO">{{ date("d/m/Y", strtotime($item->fecha_vencimiento_cupo)) }}</td>
                            @if ($item->tipo_cupo == "Porcentaje")
                            <td data-title="DESCUENTO EN % O $">{{ number_format($item->descuento_cupo, 2) . "%" }}</td>
                            @endif
                            @if ($item->tipo_cupo == "Monetario")
                            <td data-title="DESCUENTO EN % O $">{{ "$" . number_format($item->descuento_cupo, 2) }}</td>
                            @endif
                            <td data-title="TIPO DE DESCUENTO">{{ $item->tipo_cupo }}</td>
                            <td data-title="ESTATUS">
                                @if($item->estatus_cupo == 'Activo')
                                    <span class="badge bg-success">{{$item->estatus_cupo}}</span>
                                @endif
                                @if ($item->estatus_cupo == 'Inactivo')
                                    <span class="badge bg-danger">{{$item->estatus_cupo}}</span>
                                @endif
                            </td>
                            @can('Cupones - Editor')
                            <td data-title="ACCIÓN">
                                <div class="btn-group">
                                    <button type="button" class="btn btn-outline-primary dropdown-toggle btnTabla"
                                        data-bs-toggle="dropdown" aria-expanded="false">Acción <i
                                            class="mdi mdi-chevron-down"></i></button>
                                    <div class="dropdown-menu">
                                        <button type="button" class="btn btn-outline-success mt-2 dropdown-item" data-bs-toggle="modal" data-bs-target="#editar{{  $item->codigo_cupo }}">
                                            <i class="bx bxs-edit"></i> Editar
                                        </button>
                                        <form action="{{ route('cupones.activate', $item->codigo_cupo) }}" method="POST" enctype="multipart/form-data" class="form-activar">
                                            @csrf
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx bx-check-circle"></i> Activar
                                            </button>
                                        </form>
                                        <form action="{{ route('cupones.inactivate', $item->codigo_cupo) }}" method="POST" enctype="multipart/form-data" class="form-inactivar">
                                            @csrf
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx bx-x-circle"></i> Inactivar
                                            </button>
                                        </form>
                                        <form action="{{ route('cupones.delete', $item->codigo_cupo) }}" method="POST" enctype="multipart/form-data" class="form-delete">
                                            @csrf
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx  bxs-trash"></i> Eliminar
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </td>
                            @endcan
                        </tr>
                        @can('Cupones - Editor')
                        <div class="modal fade" id="editar{{  $item->codigo_cupo }}" tabindex="-1">
                            <div class="modal-dialog modal-lg">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title">Editar marca</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <form action="{{ route('cupones.update',  $item->codigo_cupo) }}" method="POST">
                                        @csrf
                                    <div class="modal-body">
                                        <div class="row">
                                            <div class="col-md-6 col-12">
                                                <label class="control-label is-required">Fecha de inicio</label>
                                                <input class="form-control" type="date" name="fecha_inicio" value="{{ $item->fecha_inicio_cupo }}" required>
                                            </div>
                                            <div class="col-md-6 col-12">
                                                <label class="control-label is-required">Fecha de vencimiento</label>
                                                <input class="form-control" type="date" name="fecha_fin" value="{{ $item->fecha_vencimiento_cupo }}" required>
                                            </div>
                                            <div class="col-md-6 col-12">
                                                <label class="control-label is-required">Cantidad en % o $</label>
                                                <input id="input-currency" class="form-control input-mask text-left importe"
                                                data-inputmask="'alias': 'numeric', 'groupSeparator': ',', 'digits': 2, 'digitsOptional': false, 'prefix': '', 'placeholder': '0'"
                                                name="cantidad" value="{{ $item->descuento_cupo }}"  required>
                                            </div>
                                            <div class="col-md-6 col-12">
                                                <label class="control-label is-required">Tipo de cupón</label>
                                                <select class="form-select" name="tipo" required>
                                                    @if ($item->tipo_cupo == "Porcentaje")
                                                    <option value="{{ $item->tipo_cupo }}">Descuento por porcentaje</option>
                                                    @endif
                                                    @if ($item->tipo_cupo == "Monetario")
                                                    <option value="{{ $item->tipo_cupo }}">Descuento por moneda</option>
                                                    @endif
                                                    <option value="Porcentaje">Descuento por porcentaje</option>
                                                    <option value="Monetario">Descuento por moneda</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="submit" class="btn btn-success"><i class="bx bx-save"></i> Actualizar</button>
                                        <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="bx  bxs-x-circle"></i> Cerrar</button>
                                    </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        @endcan
                        @endforeach
                    </tbody>
                </table>
            </div>
            <div class="datatable-bottom">
                <nav class="datatable-pagination">
                    <ul class="datatable-pagination-list"></ul>
                </nav>
            </div>
        </div>
    </div>
</div>
@endsection
@endif

