@php
$VerEditor = auth()->user()->can('Direcciones - Visor') || auth()->user()->can('Direcciones - Editor')
@endphp
@if($VerEditor)
@extends('layouts/app')
@section('tituloModulo', 'DIRECCIONES ADICIONALES')
@section('contenido')
<div class="card">
    <div class="card-body">
        @can('Direcciones - Editor')
            @role('Cliente')
            <button type="button" class="btn btn-success mt-3" data-bs-toggle="modal" data-bs-target="#crear">
                <i class="bx bxs-folder-plus"></i> Agregar dirección
            </button>
            <div class="modal fade" id="crear" tabindex="-1">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Agregar dirección</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <form action="{{ route('direcciones.store') }}" method="POST">
                            @csrf
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-md-12 col-12">
                                    <label class="control-label is-required">Dirección</label>
                                    <input class="form-control" type="text" name="direccion" required>
                                </div>
                                <div class="col-md-12 col-12">
                                    <label class="control-label is-required">Referencia</label>
                                    <textarea name="referencia" class="form-control" required></textarea>
                                </div>
                                <div class="col-md-6 col-12">
                                    <label class="control-label is-required">Estado</label>
                                    <select class="form-select" aria-label="Default select example" name="estado" required>
                                        <option value="">Seleccione une Estado</option>
                                        @foreach ($estadosRepublica as $estadoRepublica)
                                        <option value="{{ $estadoRepublica->id }}">{{ $estadoRepublica->nombre_edo }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-6 col-12">
                                    <label class="control-label is-required">Ciudad</label>
                                    <input class="form-control" type="text" name="ciudad" required>
                                </div>
                                <div class="col-md-6 col-12">
                                    <label class="control-label is-required">Código Postal</label>
                                    <input class="form-control" type="text" name="cp" required>
                                </div>
                                <div class="col-md-6 col-12">
                                    <label class="control-label is-required">País</label>
                                    <input class="form-control" type="text" name="pais" required>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-success"><i class="bx bx-save"></i> Guardar</button>
                            <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="bx  bxs-x-circle"></i> Cerrar</button>
                        </div>
                        </form>
                    </div>
                </div>
            </div>
            @endrole
        @endcan
        <div class="datatable-wrapper datatable-loading no-footer sortable searchable fixed-columns">
            <div class="datatable-container">
                <table class="table datatable datatable-table">
                    <thead>
                        <tr class="text">
                            @role('Administrador')
                            <th data-sortable="true" scope="col">CLIENTE</th>
                            @endrole
                            <th data-sortable="true" scope="col">DIRECCIÓN</th>
                            <th data-sortable="true" scope="col">REFERENCÍA</th>
                            <th data-sortable="true" scope="col">CIUDAD</th>
                            <th data-sortable="true" scope="col">ESTADO</th>
                            <th data-sortable="true" scope="col">PAÍS</th>
                            <th data-sortable="true" scope="col">CÓDIGO POSTAL</th>
                            @can('Direcciones - Editor')
                                @role('Cliente')
                            <th data-sortable="true" scope="col">ACCIÓN</th>
                                @endrole
                            @endcan
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($datos as $item)
                        <tr>
                            @role('Administrador')
                            <td data-title="CLIENTE">{{ $item->name }}</td>
                            @endrole
                            <td data-title="DIRECCIÓN">{{ $item->direccion_dire }}</td>
                            <td data-title="REFERENCÍA">{{ $item->referencia_dire }}</td>
                            <td data-title="CIUDAD">{{ $item->ciudad_dire }}</td>
                            <td data-title="ESTADO">{{ $item->nombre_edo }}</td>
                            <td data-title="ESTPAÍSADO">{{ $item->pais_dire }}</td>
                            <td data-title="CÓDIGO POSTAL">{{ $item->codigo_postal_dire }}</td>
                            </td>
                            @can('Direcciones - Editor')
                                @role('Cliente')
                            <td data-title="ACCIÓN">
                                <div class="btn-group">
                                    <button type="button" class="btn btn-outline-primary dropdown-toggle btnTabla"
                                        data-bs-toggle="dropdown" aria-expanded="false">Acción <i
                                            class="mdi mdi-chevron-down"></i></button>
                                    <div class="dropdown-menu">
                                        <button type="button" class="btn btn-outline-success mt-2 dropdown-item" data-bs-toggle="modal" data-bs-target="#editar{{  $item->codigo_dire }}">
                                            <i class="bx bxs-edit"></i> Editar
                                        </button>
                                        <form action="{{ route('direcciones.delete', $item->codigo_dire) }}" method="POST" enctype="multipart/form-data" class="form-delete">
                                            @csrf
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx  bxs-trash"></i> Eliminar
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </td>
                                @endrole
                            @endcan
                        </tr>
                        @can('Direcciones - Editor')
                        <div class="modal fade" id="editar{{  $item->codigo_dire }}" tabindex="-1">
                            <div class="modal-dialog modal-lg">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title">Editar dirección</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <form action="{{ route('direcciones.update',  $item->codigo_dire) }}" method="POST">
                                        @csrf
                                    <div class="modal-body">
                                        <div class="row">
                                            <div class="col-md-12 col-12">
                                                <label class="control-label is-required">Dirección</label>
                                                <input class="form-control" type="text" value="{{ $item->direccion_dire }}" name="direccion" required>
                                            </div>
                                            <div class="col-md-12 col-12">
                                                <label class="control-label is-required">Referencia</label>
                                                <textarea name="referencia" class="form-control" required> {{ $item->referencia_dire }}</textarea>
                                            </div>
                                            <div class="col-md-6 col-12">
                                                <label class="control-label is-required">Estado</label>
                                                <select class="form-select" aria-label="Default select example" name="estado" required>
                                                    <option value="{{ $item->estado_dire }}">{{ $item->nombre_edo }}</option>
                                                    @foreach ($estadosRepublica as $estadoRepublica)
                                                    <option value="{{ $estadoRepublica->id }}">{{ $estadoRepublica->nombre_edo }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                            <div class="col-md-6 col-12">
                                                <label class="control-label is-required">Ciudad</label>
                                                <input class="form-control" type="text" value="{{ $item->ciudad_dire }}" name="ciudad" required>
                                            </div>
                                            <div class="col-md-6 col-12">
                                                <label class="control-label is-required">Código Postal</label>
                                                <input class="form-control" type="text" value="{{ $item->codigo_postal_dire }}" name="cp" required>
                                            </div>
                                            <div class="col-md-6 col-12">
                                                <label class="control-label is-required">País</label>
                                                <input class="form-control" type="text" value="{{ $item->pais_dire }}" name="pais" required>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="submit" class="btn btn-success"><i class="bx bx-save"></i> Actualizar</button>
                                        <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="bx  bxs-x-circle"></i> Cerrar</button>
                                    </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        @endcan
                        @endforeach
                    </tbody>
                </table>
            </div>
            <div class="datatable-bottom">
                <nav class="datatable-pagination">
                    <ul class="datatable-pagination-list"></ul>
                </nav>
            </div>
        </div>
    </div>
</div>
@endsection
@endif
