@php
$VerEditor = auth()->user()->can('Eventos - Editor')
@endphp
@if($VerEditor)
@extends('layouts/app')
@section('tituloModulo', 'DATOS DEL EVENTO')
@section('contenido')
<div class="card">
    <div class="card-body">
        <form action="{{ route('eventos.update', $datos->codigo_even) }}" method="POST"  enctype="multipart/form-data">
            @csrf
            <div class="row mt-2">
                <div class="col-md-12 col-12 text-center">
                    @if ($datos->imagen_even)
                    <img src="{{ asset('assets/img/eventos/' . $datos->imagen_even) }}" alt="Evento" width="150" >
                    @else
                    <img src="{!! asset('assets/img/eventos/eventos.png') !!}" alt="Evento" width="150" height="150" >
                    @endif
                </div>
                <div class="col-md-12 col-12">
                    <label class="control-label">Imagen principal</label>
                    <input class="form-control" name="imagenPrincipal"  type="file">
                </div>
                <div class="col-md-12 col-12">
                    <label class="control-label is-required">Nombre</label>
                    <input class="form-control" name="nombre" value="{{ $datos->nombre_even }}"type="text" required>
                </div>
                <div class="col-md-12 col-12">
                    <label class="control-label is-required">Descripción larga</label>
                    <div id="descripcion">{!! $datos->decripcion_even !!}</div>
                    <textarea name="descripcion" style="display:none">{!! $datos->decripcion_even !!}</textarea>
                    <script>
                        ClassicEditor
                            .create( document.querySelector( '#descripcion' ) )
                            .then( descripcion => {
                                descripcion.model.document.on('change:data', () => {
                                    document.querySelector('textarea[name="descripcion"]').value = descripcion.getData();
                                });
                            })
                            .catch( error => {
                                console.error( error );
                            } );
                    </script>
                </div>
                <label class="control-label">Banner del Evento</label>
                <div class="col-md-12 col-12 text-center">
                    @if ($datos->banner_even)
                    <img src="{{ asset('assets/img/eventos/' . $datos->banner_even) }}" alt="Banner" width="450" >
                    @else
                    <img src="{!! asset('assets/img/eventos/eventosBanner.png') !!}" alt="Banner" width="250" height="250" >
                    @endif
                </div>
                <div class="col-md-12 col-12 mt-2">
                    <input class="form-control" name="banner"  type="file">
                </div>
            </div>
            <button type="submit" class="btn btn-success mt-3" data-bs-toggle="modal" data-bs-target="#crear">
                <i class="bx  bxs-save"></i> Guardar
            </button>
        </form>
    </div>
</div>
<div class="card">
    <div class="card-body">
        <h5 class="card-title">Boletos</h5>
        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#crearBoleto{{  $datos->codigo_even }}">
            <i class="bx bxs-folder-plus"></i> Agregar boleto
        </button>
        <div class="datatable-wrapper datatable-loading no-footer sortable searchable fixed-columns">
            <div class="datatable-container">
                <table class="table datatable datatable-table">
                    <thead>
                        <tr class="text">
                            <th data-sortable="true" scope="col">NOMBRE</th>
                            <th data-sortable="true" scope="col">PRECIO</th>
                            <th data-sortable="true" scope="col">¿LLEVA STOCK?</th>
                            <th data-sortable="true" scope="col">NO. DE BOLETOS</th>
                            <th data-sortable="true" scope="col">ACCIÓN</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($boletos as $boleto)
                        <tr>
                            <td data-title="NOMBRE">{{ $boleto->nombre_enbo  }}</td>
                            <td data-title="PRECIO">{{ "$" . number_format($boleto->precio_enbo, 2)  }}</td>
                            <td data-title="¿LLEVA STOCK?">@if ($boleto->stock_enbo == 1) SI @else NO @endif</td>
                            <td data-title="NO. DE BOLETOS">{{ $boleto->nro_boletos_enbo  }}</td>
                            <td data-title="ACCIÓN">
                                <div class="btn-group">
                                    <button type="button" class="btn btn-outline-primary dropdown-toggle btnTabla"
                                        data-bs-toggle="dropdown" aria-expanded="false">Acción <i
                                            class="mdi mdi-chevron-down"></i></button>
                                    <div class="dropdown-menu">
                                        <button type="button" class="btn btn-outline-success mt-2 dropdown-item" data-bs-toggle="modal" data-bs-target="#editar{{  $boleto->codigo_enbo }}">
                                            <i class="bx bxs-edit"></i> Editar
                                        </button>
                                        <form action="{{ route('eventos.delete.boletos', $boleto->codigo_enbo) }}" method="POST"  class="form-delete">
                                            @csrf
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx  bxs-trash"></i> Eliminar
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <div class="modal fade" id="editar{{ $boleto->codigo_enbo }}" tabindex="-1">
                            <div class="modal-dialog modal-lg">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title">Editar Boleto</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <form action="{{ route('eventos.update.boletos', $boleto->codigo_enbo) }}" method="POST">
                                        @csrf
                                        <div class="modal-body">
                                            <div class="form-group">
                                                <div class="row">
                                                    <div class="col-md-12 col-12">
                                                        <label class="control-label is-required">Nombre</label>
                                                        <input class="form-control" name="nombre" value="{{ $boleto->nombre_enbo }}" type="text" required>
                                                    </div>
                                                    <div class="col-md-12 col-12">
                                                        <label class="control-label">Precio de venta</label>
                                                        <input id="input-currency" class="form-control input-mask text-left"
                                                            data-inputmask="'alias': 'numeric', 'groupSeparator': '', 'digits': 0, 'digitsOptional': false, 'prefix': '$ ', 'placeholder': '0'"
                                                            name="precio" value="{{ $boleto->precio_enbo }}">
                                                    </div>
                                                    <div class="col-md-12 col-12">
                                                        <label class="control-label">Limitar a un número de boletos</label>
                                                        <div>
                                                            <input type="radio" name="limitarStock" id="limitarStockSi{{ $boleto->codigo_enbo }}" value="1" {{ $boleto->nro_boletos_enbo ? 'checked' : '' }}> Sí
                                                            <input type="radio" name="limitarStock" id="limitarStockNo{{ $boleto->codigo_enbo }}" value="0" {{ !$boleto->nro_boletos_enbo ? 'checked' : '' }}> No
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12 col-12" id="numeroBoletosContainer{{ $boleto->codigo_enbo }}" style="display: {{ $boleto->nro_boletos_enbo ? 'block' : 'none' }};">
                                                        <label class="control-label">Número de boletos</label>
                                                        <input class="form-control" name="numeroBoletos" id="numeroBoletos{{ $boleto->codigo_enbo }}" value="{{ $boleto->nro_boletos_enbo }}" type="number" min="1">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="submit" class="btn btn-success"><i class="bx bx-save"></i> Actualizar</button>
                                            <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="bx  bxs-x-circle"></i> Cerrar</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                        <script>
                            document.addEventListener('DOMContentLoaded', function() {
                                const limitarStockSi = document.getElementById('limitarStockSi{{ $boleto->codigo_enbo }}');
                                const limitarStockNo = document.getElementById('limitarStockNo{{ $boleto->codigo_enbo }}');
                                const numeroBoletosContainer = document.getElementById('numeroBoletosContainer{{ $boleto->codigo_enbo }}');

                                if (limitarStockSi && limitarStockNo && numeroBoletosContainer) {
                                    limitarStockSi.addEventListener('change', function() {
                                        if (this.checked) {
                                            numeroBoletosContainer.style.display = 'block';
                                        }
                                    });

                                    limitarStockNo.addEventListener('change', function() {
                                        if (this.checked) {
                                            numeroBoletosContainer.style.display = 'none';
                                        }
                                    });
                                }
                            });
                        </script>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <div class="datatable-bottom">
                <nav class="datatable-pagination">
                    <ul class="datatable-pagination-list"></ul>
                </nav>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="crearBoleto{{ $datos->codigo_even }}" tabindex="-1">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Agregar datos del boleto</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="{{ route('eventos.store.boletos', $datos->codigo_even) }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="modal-body">
                    <div class="form-group">
                        <div class="row">
                            <div class="col-md-12 col-12">
                                <label class="control-label is-required">Nombre</label>
                                <input class="form-control" name="nombre"  type="text" required>
                            </div>
                            <div class="col-md-12 col-12">
                                <label class="control-label">Precio de venta</label>
                                <input id="input-currency" class="form-control input-mask text-left"
                                    data-inputmask="'alias': 'numeric', 'groupSeparator': '', 'digits': 0, 'digitsOptional': false, 'prefix': '$ ', 'placeholder': '0'"
                                    name="precio">
                            </div>
                            <div class="col-md-12 col-12">
                                <label class="control-label">Limitar a un número de boletos</label>
                                <div>
                                    <input type="radio" name="limitarStock" id="limitarStockSi" value="1"> Sí
                                    <input type="radio" name="limitarStock" id="limitarStockNo" value="0" checked> No
                                </div>
                            </div>
                            <div class="col-md-12 col-12" id="numeroBoletosContainer" style="display: none;">
                                <label class="control-label">Número de boletos</label>
                                <input class="form-control" name="numeroBoletos" id="numeroBoletos" value="{{ $datos->nro_boletos_enbo }}" type="number" min="1">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-success"><i class="bx bx-save"></i> Guardar</button>
                    <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="bx  bxs-x-circle"></i> Cerrar</button>
                </div>
            </form>
        </div>
    </div>
</div>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const limitarStockSi = document.getElementById('limitarStockSi');
        const limitarStockNo = document.getElementById('limitarStockNo');
        const numeroBoletosContainer = document.getElementById('numeroBoletosContainer');
        limitarStockSi.addEventListener('change', function() {
            if (this.checked) {
                numeroBoletosContainer.style.display = 'block';
            }
        });
        limitarStockNo.addEventListener('change', function() {
            if (this.checked) {
                numeroBoletosContainer.style.display = 'none';
            }
        });
    });
</script>
@endsection
@endif

