@php
$VerEditor = auth()->user()->can('Eventos - Visor') || auth()->user()->can('Eventos - Editor')
@endphp
@if($VerEditor)
@extends('layouts/app')
@section('tituloModulo', 'EVENTOS')
@section('contenido')
<div class="card">
    <div class="card-body">
        @can('Eventos - Editor')
        <button type="button" class="btn btn-success mt-3" data-bs-toggle="modal" data-bs-target="#crear">
            <i class="bx bxs-folder-plus"></i> Agregar evento
        </button>
        <div class="modal fade" id="crear" tabindex="-1">
            <div class="modal-dialog modal-xl">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Agregar evento</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form action="{{ route('eventos.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                    <div class="modal-body">
                        <label class="control-label is-required">Nombre del evento</label>
                        <input class="form-control" type="text" name="nombre" required>
                        <label class="control-label is-required">Fecha de evento</label>
                        <input class="form-control" type="date" name="fecha" required>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success"><i class="bx bx-save"></i> Guardar</button>
                        <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="bx  bxs-x-circle"></i> Cerrar</button>
                    </div>
                    </form>
                </div>
            </div>
        </div>
        @endcan
        <div class="datatable-wrapper datatable-loading no-footer sortable searchable fixed-columns">
            <div class="datatable-container">
                <table class="table datatable datatable-table">
                    <thead>
                        <tr class="text">
                            <th data-sortable="true" scope="col">IMAGEN</th>
                            <th data-sortable="true" scope="col">NOMBRE</th>
                            <th data-sortable="true" scope="col">FECHA DEL EVENTO</th>
                            <th data-sortable="true" scope="col">ESTATUS</th>
                            @can('Eventos - Editor')
                            <th data-sortable="true" scope="col">ACCIÓN</th>
                            @endcan
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($datos as $item)
                        <tr>
                            <td data-title="IMAGEN">@if ($item->imagen_even)
                                <img src="{{ asset('assets/img/eventos/' . $item->imagen_even) }}" alt="Evento" width="50" >
                                @else
                                <img src="{!! asset('assets/img/eventos.png') !!}" alt="Profile" width="50" height="50" >
                                @endif</td>
                            <td data-title="NOMBRE">{{ $item->nombre_even }}</td>
                            <td data-title="FECHA DEL EVENTO">{{ date("d/m/Y", strtotime($item->fecha_even)) }}</td>
                            <td data-title="ESTATUS">
                                @if($item->estatus_even == 'Activo')
                                    <span class="badge bg-success">{{$item->estatus_even}}</span>
                                @endif
                                @if ($item->estatus_even == 'Inactivo')
                                    <span class="badge bg-danger">{{$item->estatus_even}}</span>
                                @endif
                            </td>
                            @can('Eventos - Editor')
                            <td data-title="ACCIÓN">
                                <div class="btn-group">
                                    <button type="button" class="btn btn-outline-primary dropdown-toggle btnTabla"
                                        data-bs-toggle="dropdown" aria-expanded="false">Acción <i
                                            class="mdi mdi-chevron-down"></i></button>
                                    <div class="dropdown-menu">
                                        <form action="{{ route('eventos.dats', $item->codigo_even) }}" method="GET">
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx bxs-edit"></i> Editar
                                            </button>
                                        </form>
                                        <form action="{{ route('eventos.activate', $item->codigo_even) }}" method="POST" enctype="multipart/form-data" class="form-activar">
                                            @csrf
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx bx-check-circle"></i> Activar
                                            </button>
                                        </form>
                                        <form action="{{ route('eventos.inactivate', $item->codigo_even) }}" method="POST" enctype="multipart/form-data" class="form-inactivar">
                                            @csrf
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx bx-x-circle"></i> Inactivar
                                            </button>
                                        </form>
                                        <form action="{{ route('eventos.delete', $item->codigo_even) }}" method="POST" enctype="multipart/form-data" class="form-delete">
                                            @csrf
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx  bxs-trash"></i> Eliminar
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </td>
                            @endcan
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <div class="datatable-bottom">
                <nav class="datatable-pagination">
                    <ul class="datatable-pagination-list"></ul>
                </nav>
            </div>
        </div>
    </div>
</div>
@endsection
@endif

