@extends('layouts/app')
@section('tituloModulo','DASHBOARD')
@section('contenido')
@role('Cliente')
<section class="section dashboard">
    <div class="row">
        <div class="col-xxl-4 col-md-6">
            <div class="card info-card sales-card">
                <div class="card-body">
                <h5 class="card-title">Productos Comprados <span>| {{ $mesActual }}</span></h5>
                <div class="d-flex align-items-center">
                    <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                        <i class="bi bi-cart"></i>
                    </div>
                    <div class="ps-3">
                        <h6>{{ $conteoProductos }}</h6>
                        <span class="text-success small pt-1 fw-bold"></span> <span class="text-muted small pt-2 ps-1">Productos Entregados</span>
                    </div>
                </div>
                </div>
            </div>
        </div>
        <div class="col-xxl-4 col-md-6">
            <div class="card info-card revenue-card">
                <div class="card-body">
                <h5 class="card-title">Compras <span>| {{ $mesActual }}</span></h5>
                <div class="d-flex align-items-center">
                    <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                        <i class="bi bi-currency-dollar"></i>
                    </div>
                    <div class="ps-3">
                        <h6>{{ "$" . number_format($conteoCompras, 2)}}</h6>
                        <span class="text-success small pt-1 fw-bold"></span> <span class="text-muted small pt-2 ps-1">Moneda Nacional MXM</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endrole
@role('Administrador')
<section class="section dashboard">
    <div class="row">
        <div class="col-xxl-4 col-md-4 col-12">
            <div class="card info-card sales-card">
                <div class="card-body">
                <h5 class="card-title">Productos Vendidos <span>| {{ $mesActual }}</span></h5>
                <div class="d-flex align-items-center">
                    <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                        <i class="bi bi-cart"></i>
                    </div>
                    <div class="ps-3">
                        <h6>{{ $conteoProductos }}</h6>
                        <span class="text-success small pt-1 fw-bold"></span> <span class="text-muted small pt-2 ps-1">Productos Entregados</span>
                    </div>
                </div>
                </div>
            </div>
        </div>
        <div class="col-xxl-4 col-md-4 col-12">
            <div class="card info-card revenue-card">
                <div class="card-body">
                <h5 class="card-title">Ventas <span>| {{ $mesActual }}</span></h5>
                <div class="d-flex align-items-center">
                    <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                        <i class="bi bi-currency-dollar"></i>
                    </div>
                    <div class="ps-3">
                        <h6>{{ "$" . number_format($conteoCompras, 2)}}</h6>
                        <span class="text-success small pt-1 fw-bold"></span> <span class="text-muted small pt-2 ps-1">Moneda Nacional MXM</span>
                    </div>
                </div>
                </div>
            </div>
        </div>
        <div class="col-xxl-4 col-md-4 col-12">
            <div class="card info-card customers-card">
                <div class="card-body">
                    <h5 class="card-title">Clientes <span>| Año {{ $anioActual }}</span></h5>
                    <div class="d-flex align-items-center">
                        <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                        <i class="bi bi-people"></i>
                        </div>
                        <div class="ps-3">
                        <h6>{{ $clientes }}</h6>
                        <span class="text-danger small pt-1 fw-bold"></span> <span class="text-muted small pt-2 ps-1">Clientes Registrados</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-12 col-md-12 col-12">
            <div class="card">
                <div class="card-body">
                <h5 class="card-title">Ventas por mes | Año {{ $anioActual }} </h5>
                <!-- Line Chart -->
                <canvas id="lineChart" style="max-height: 400px;"></canvas>
                    <script>
                    document.addEventListener("DOMContentLoaded", () => {
                    var labelsVentasMes = {{ Js::from($labelsVentasMes) }};
                    var dataConteoVisitasMes = {{ Js::from($dataConteoVisitasMes) }};
                    new Chart(document.querySelector('#lineChart'), {
                        type: 'line',
                        data: {
                            labels: labelsVentasMes,
                            datasets: [{
                                label: 'Ventas por mes en el año {{ $anioActual }}',
                                data: dataConteoVisitasMes,
                                backgroundColor: [
                                'rgba(255, 10, 10, 0.2)',
                                'rgba(255, 121, 10, 0.2)',
                                'rgba(255, 228, 0, 0.2)',
                                'rgba(197, 255, 0, 0.2)',
                                'rgba(53, 194, 5, 0.2)',
                                ],
                                borderColor: [
                                'rgba(255, 10, 10, 1)',
                                'rgba(255, 121, 10, 1)',
                                'rgba(2255, 228, 0, 1)',
                                'rgba(197, 255, 0, 1)',
                                'rgba(53, 194, 0, 1)',
                                ],
                                hoverOffset: 4
                            }]
                        },
                        options: { scales:  { y:    {   beginAtZero: true  }    }    }
                        });
                    });
                    </script>
                </div>
            </div>
        </div>
    </div>
</section>
@endrole
@endsection
