<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta content="width=device-width, initial-scale=1.0" name="viewport">
<title class="nombre_empresa"></title>
<meta content="" name="description">
<meta content="" name="keywords">
<!-- Favicons -->
<link href="{!! asset('assets/img/favicon.png') !!}" rel="icon">
<link href="{!! asset('assets/img/apple-touch-icon.png') !!}" rel="apple-touch-icon">
<!-- Google Fonts -->
<link href="https://fonts.gstatic.com" rel="preconnect">
<link
    href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i"
    rel="stylesheet">
<!-- Vendor CSS Files -->
<link href="{!! asset('assets/vendor/bootstrap/css/bootstrap.min.css') !!}" rel="stylesheet">
<link href="{!! asset('assets/vendor/bootstrap-icons/bootstrap-icons.css') !!}" rel="stylesheet">
<link href="{!! asset('assets/vendor/boxicons/css/boxicons.min.css') !!}" rel="stylesheet">
<link href="{!! asset('assets/vendor/quill/quill.snow.css') !!}" rel="stylesheet">
<link href="{!! asset('assets/vendor/quill/quill.bubble.css') !!}" rel="stylesheet">
<link href="{!! asset('assets/vendor/remixicon/remixicon.css') !!}" rel="stylesheet">
<link href="{!! asset('assets/vendor/simple-datatables/style.css') !!}" rel="stylesheet">
<link href="{!! asset('assets/vendor/fontawesome/css/fontawesome.css') !!}" rel="stylesheet">
<script src="https://cdn.ckeditor.com/ckeditor5/41.0.0/classic/ckeditor.js"></script>
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<!-- Template Main CSS File -->
<link href="{!! asset('assets/css/style.css') !!}" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js" integrity="sha512-v2CJ7UaYy4JwqLDIrZUI/4hqeoQieOmAZNXBeQyjo21dadnwR+8ZaIJVT8EE2iyI61OV8e6M8PP2/4hpQINQ/g==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
</head>
<body>
<!-- ======= Header ======= -->
<header id="header" class="header fixed-top d-flex align-items-center">
    <div class="d-flex align-items-center justify-content-between">
        <a href="{{ route('home') }}" class="logo d-flex align-items-center">
            <img  class="logo_empresa" alt="logo" width="50px">
            <span class="d-none d-lg-block nombre_empresa"></span>
        </a>
        <i class="bi bi-list toggle-sidebar-btn"></i>
    </div><!-- End Logo -->
    <nav class="header-nav ms-auto">
        <ul class="d-flex align-items-center">
            <li class="nav-item d-block d-lg-none">
                <a class="nav-link nav-icon search-bar-toggle " href="#">
                    <i class="bi bi-search"></i>
                </a>
            </li><!-- End Search Icon-->
            @role('Cliente')
                <li class="nav-item dropdown">
                    <a class="nav-link nav-icon" href="#" data-bs-toggle="dropdown">
                        <i class="fa-solid fa-heart"></i>
                        <span class="badge bg-primary badge-number">{{ $totalFavoritos }}</span>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow notifications">
                        <li class="dropdown-header">Usted tiene {{ $totalFavoritos }} @if ($totalFavoritos == 1) producto @else productos @endif en favoritos
                        </li>
                    <li>
                        <hr class="dropdown-divider">
                </li>
                    @foreach ($favoritos as $item)
                    <li class="notification-item">
                        <i class="fa-solid fa-heart text-primary"></i>
                        <div>
                            <h4>{{ $item['nombre'] }}</h4>
                        </div>
                        </li>
                    <li>
                        <hr class="dropdown-divider">
                    </li>
                        @endforeach
                    <li class="dropdown-footer">
                        <a href="{{ route('favoritos')}}">Mostrar lista completa</a>
                    </li>
                    </ul>
                </li>
                <li class="nav-item dropdown">
                    <a class="nav-link nav-icon" href="#" data-bs-toggle="dropdown">
                        <i class="fa-solid fa-cart-shopping"></i>
                        <span class="badge bg-primary badge-number">{{ $totalProducts }}</span>
                    </a><!-- End Notification Icon -->
                    <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow notifications">
                        <li class="dropdown-header">
                        Usted tiene {{ $totalProducts }} @if ($totalProducts == 1) producto @else productos @endif   en su carrito
                        <a href="{{ route('procesar.compra')}}"><span class="badge rounded-pill bg-primary p-2 ms-2">Confirmar compra</span></a>
                        </li>
                    <li>
                        <hr class="dropdown-divider">
                </li>
                    @foreach ($cart as $item)
                    <li class="notification-item">
                        <i class="fa-solid fa-certificate text-primary"></i>
                        <div>
                            <h4>{{ $item['nombreProduct'] }}</h4>
                            <p>{{ "Cantidad: " . $item['cantidad'] }}</p>
                            <p>{{"Precio: $" . number_format($item['total'], 2)   }}</p>
                        </div>
                        </li>
                    <li>
                        <hr class="dropdown-divider">
                </li>
                    @endforeach
                    <li class="dropdown-footer">
                        <a href="{{ route('carrito')}}">Mostrar lista completa</a>
                    </li>
                    </ul>
                </li>
                @endrole
            <li class="nav-item dropdown pe-3">
                <a class="nav-link nav-profile d-flex align-items-center pe-0" href="#"
                    data-bs-toggle="dropdown">
                    <img src="{!! asset('assets/img/avatar.png') !!}" alt="Profile" class="rounded-circle">
                    <span class="d-none d-md-block dropdown-toggle ps-2">{{ Auth::user()->name }}</span>
                </a><!-- End Profile Iamge Icon -->
                <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow profile">
                    <li class="dropdown-header">
                        <h6>{{ Auth::user()->name }}</h6>
                        <span>{{ Auth::user()->email }}</span>
                    </li>
                    <li>
                        <hr class="dropdown-divider">
                    </li>
                    <li>
                        <a class="dropdown-item d-flex align-items-center" href="users-profile.html">
                            <i class="bi bi-person"></i>
                            <span>Perfil</span>
                        </a>
                    </li>
                    <li>
                        <hr class="dropdown-divider">
                    </li>
                    <li>
                        <a class="dropdown-item d-flex align-items-center" href="{{ route('logout') }}" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                            <i class="bi bi-box-arrow-right"></i>Salir
                        </a>
                        <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                            @csrf
                        </form>
                    </li>
                </ul><!-- End Profile Dropdown Items -->
            </li><!-- End Profile Nav -->
        </ul>
    </nav><!-- End Icons Navigation -->
</header><!-- End Header -->
<!-- ======= Sidebar ======= -->
<aside id="sidebar" class="sidebar">
    <ul class="sidebar-nav" id="sidebar-nav">
        <li class="nav-item">
            <a class="nav-link collapsed" href="{{ route('home')}}">
                <i class="fa-solid fa-cubes"></i>
                <span>Dashboard</span>
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link collapsed" href="{{route('index')}}">
                <i class="fa-solid fa-store"></i>
                <span>Tienda</span>
            </a>
        </li>
        @php
        $productosPermisos = auth()->user()->can('Productos - Visor') || auth()->user()->can('Producto - Editor')
        @endphp
        @if($productosPermisos)
        <li class="nav-item">
            <a class="nav-link collapsed" href="{{route('productos.index')}}">
                <i class="fa-solid fa-dolly"></i>
                <span>Productos</span>
            </a>
        </li>
        @endif
        @php
        $ventasPermisos = auth()->user()->can('Ventas - Visor') || auth()->user()->can('Ventas - Editor')
        @endphp
        @if($ventasPermisos)
        <li class="nav-item">
            <a class="nav-link collapsed" href="{{route('ventas.index')}}">
                <i class="fa-solid fa-money-bill-transfer"></i>
                <span>Ventas</span>
            </a>
        </li>
        @endif
        @php
        $ventasPermisos = auth()->user()->can('Pedidos - Visor') || auth()->user()->can('Pedidos - Editor')
        @endphp
        @if($ventasPermisos)
        <li class="nav-item">
            <a class="nav-link collapsed" href="{{ route('pedidos.index') }}">
                <i class="fa-solid fa-rectangle-list"></i>
                <span>Pedidos</span>
            </a>
        </li>
        @endif
        @php
        $direccionesPermisos = auth()->user()->can('Direcciones - Visor') || auth()->user()->can('Direcciones - Editor')
        @endphp
        @if($direccionesPermisos)
        <li class="nav-item">
            <a class="nav-link collapsed" href="{{route('direcciones.index')}}">
                <i class="fa-solid fa-location-dot"></i>
                <span>Direcciones</span>
            </a>
        </li>
        @endif
        @php
        $suscripcionesPermisos = auth()->user()->can('Suscripciones - Visor') || auth()->user()->can('Suscripciones - Editor')
        @endphp
        @if($suscripcionesPermisos)
        <li class="nav-item">
            <a class="nav-link collapsed" href="{{route('suscripciones.index')}}">
                <i class="fa-solid fa-envelope"></i>
                <span>Suscripciones</span>
            </a>
        </li>
        @endif
        @php
        $calificacionesPermisos = auth()->user()->can('Calificaciones - Visor') || auth()->user()->can('Calificaciones - Editor')
        @endphp
        @if($calificacionesPermisos)
        <li class="nav-item">
            <a class="nav-link collapsed" href="{{route('calificaciones.index')}}">
                <i class="fa-solid fa-comment"></i>
                <span>Calificaciones</span>
            </a>
        </li>
        @endif
        @php
        $clientesPermisos = auth()->user()->can('Clientes - Visor') || auth()->user()->can('Clientes - Editor')
        @endphp
        @if($clientesPermisos)
        <li class="nav-item">
            <a class="nav-link collapsed" href="{{route('clientes.index')}}">
                <i class="fa-solid fa-users"></i>
                <span>Clientes</span>
            </a>
        </li>
        @endif
        @php
        $cuponesPermisos = auth()->user()->can('Cupones - Visor') || auth()->user()->can('Cupones - Editor')
        @endphp
        @if($cuponesPermisos)
        <li class="nav-item">
            <a class="nav-link collapsed"  href="{{ route('cupones.index')}} ">
                <i class="fa-solid fa-ticket"></i>
                <span>Cupones</span>
            </a>
        </li>
        @endif
        @php
        $eventosPermisos = auth()->user()->can('Eventos - Visor') || auth()->user()->can('Eventos - Editor')
        @endphp
        @if($eventosPermisos)
        <li class="nav-item">
            <a class="nav-link collapsed"  href="{{ route('eventos.index')}} ">
                <i class="fa-solid fa-calendar-days"></i>
                <span>Eventos</span>
            </a>
        </li>
        @endif
        @php
        $datosUsuarioPermisos = auth()->user()->can('Datos del usuario - Visor') || auth()->user()->can('Datos del usuario - Editor')
        @endphp
        @if($datosUsuarioPermisos)
        <li class="nav-item">
            <a class="nav-link collapsed" @if(Auth::check()) href="{{ route('clientes.cliente', Crypt::encrypt(Auth::user()->email))}}" @endif>
                <i class="fa-solid fa-user-gear"></i>
                <span>Datos del Cliente</span>
            </a>
        </li>
        @endif
        @php
            $configuracionesPermiso = auth()->user()->can('Productos / Categorías - Visor') || auth()->user()->can('Productos / Categorías - Editor')
            || auth()->user()->can('Productos / Subcategorías - Visor') || auth()->user()->can('Productos / Subcategorías - Editor')
            || auth()->user()->can('Productos / Marcas - Visor') || auth()->user()->can('Productos / Marcas - Editor')
        @endphp
        @if($configuracionesPermiso)
        <li class="nav-item">
            <a class="nav-link collapsed" data-bs-target="#catalogos-nav" data-bs-toggle="collapse"
                href="#">
                <i class="fa-solid fa-layer-group"></i><span>Catálogos Productos</span><i class="bi bi-chevron-down ms-auto"></i>
            </a>
            <ul id="catalogos-nav" class="nav-content collapse " data-bs-parent="#sidebar-nav">
                @php
                $categoriasPermisos = auth()->user()->can('Productos / Categorías - Visor') || auth()->user()->can('Productos / Categorías - Editor')
                @endphp
                @if($categoriasPermisos)
                <li>
                    <a href="{{ route('categorias.index')}}">
                        <i class="fas fa-list-alt"></i><span>Categorías</span>
                    </a>
                </li>
                @endif
                @php
                $subcategoriasPermisos = auth()->user()->can('Productos / Subcategorías - Visor') || auth()->user()->can('Productos / Subcategorías - Editor')
                @endphp
                @if($subcategoriasPermisos)
                <li>
                    <a href="{{ route('subcategorias.index')}}">
                        <i class="far fa-list-alt"></i><span>Subcategorías</span>
                    </a>
                </li>
                @endif
                @php
                $marcasPermisos = auth()->user()->can('Productos / Marcas - Visor') || auth()->user()->can('Productos / Marcas - Editor')
                @endphp
                @if($marcasPermisos)
                <li>
                    <a href="{{ route('marcas.index')}}">
                        <i class="fa-solid fa-tag"></i><span>Marcas</span>
                    </a>
                </li>
                @endif
            </ul>
        </li>
        @endif
        @php
            $configuracionesPermiso = auth()->user()->can('Empresa - Visor') || auth()->user()->can('Empresa - Editor')
            || auth()->user()->can('Usuarios - Visor') || auth()->user()->can('Usuarios - Editor')
            || auth()->user()->can('Permisos - Visor') || auth()->user()->can('Permisos - Editor')
            || auth()->user()->can('Empresa - Visor') || auth()->user()->can('Roles - Editor')
        @endphp
        @if($configuracionesPermiso)
        <li class="nav-item">
            <a class="nav-link collapsed" data-bs-target="#configuraciones-nav" data-bs-toggle="collapse"
                href="#">
                <i class="fa-solid fa-cubes"></i><span>Configuración</span><i class="bi bi-chevron-down ms-auto"></i>
            </a>
            <ul id="configuraciones-nav" class="nav-content collapse " data-bs-parent="#sidebar-nav">
                <li>
                    @php
                        $permisoEmpresa = auth()->user()->can('Empresa - Visor') || auth()->user()->can('Empresa - Editor')
                    @endphp
                    @if($permisoEmpresa)
                        <a href="{{ route('datos_empresa.index')}}">
                            <i class="bx bx-buildings"></i><span>Empresa</span>
                        </a>
                    @endif
                    @php
                        $permisoUsuarios = auth()->user()->can('Usuarios - Visor') || auth()->user()->can('Usuarios - Editor')
                    @endphp
                    @if($permisoUsuarios)
                        <a href="{{ route('usuarios.index')}}">
                            <i class="bx bxs-user-badge"></i><span>Usuarios</span>
                        </a>
                    @endif
                    @php
                        $permisoPermisos = auth()->user()->can('Permisos - Visor') || auth()->user()->can('Permisos - Editor')
                    @endphp
                    @if($permisoPermisos)
                        <a href="{{ route('permissions.index')}}">
                            <i class="bx bxs-lock-alt"></i><span>Permisos</span>
                        </a>
                    @endif
                    @php
                        $permisoRoles = auth()->user()->can('Roles - Visor') || auth()->user()->can('Roles - Editor')
                    @endphp
                    @if($permisoRoles)
                        <a href="{{ route('roles.index')}}">
                            <i class="bx bxs-vector"></i><span>Roles</span>
                        </a>
                    @endif
                </li>
            </ul>
        </li>
        @endif
    </ul>
</aside><!-- End Sidebar-->
<main id="main" class="main">
    <div class="pagetitle">
        <h1>@yield('tituloModulo')</h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">INICIO</a></li>
                <li class="breadcrumb-item active">@yield('tituloModulo')</li>
            </ol>
        </nav>
    </div><!-- End Page Title -->
    <section class="section">
        @if ($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        @if($mensaje = Session::get('success'))
            <div class="alert alert-success" role="alert">{{ $mensaje }}</div>
        @endif
        @if($mensaje = Session::get('danger'))
            <div class="alert alert-danger" role="alert">{{ $mensaje }}</div>
        @endif
        @yield('contenido')
    </section>
</main><!-- End #main -->
<!-- ======= Footer ======= -->
<footer id="footer" class="footer">
    <div class="copyright">
        &copy; Copyright <strong><span class="nombre_empresa"></span></strong>. Derechos reservados
    </div>
    <div class="credits">
        Desarollado por <a href="https://sistemaiemp.com/">Sistema IEMP</a>
    </div>
</footer><!-- End Footer -->
<a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i
        class="bi bi-arrow-up-short"></i></a>
<!-- Vendor JS Files -->-
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="{!! asset('assets/vendor/apexcharts/apexcharts.min.js') !!}"></script>
<script src="{!! asset('assets/vendor/bootstrap/js/bootstrap.bundle.min.js') !!}"></script>
<script src="{!! asset('assets/vendor/chart.js/chart.umd.js') !!}"></script>
<script src="{!! asset('assets/vendor/echarts/echarts.min.js') !!}"></script>
<script src="{!! asset('assets/vendor/quill/quill.min.js') !!}"></script>
<script src="{!! asset('assets/vendor/inputmask/jquery.inputmask.min.js') !!}"></script>
<script src="{!! asset('assets/vendor/pages/form-mask.init.js') !!}"></script>
<script src="{!! asset('assets/vendor/simple-datatables/simple-datatables.js') !!}"></script>
<script src="{!! asset('assets/vendor/tinymce/tinymce.min.js') !!}"></script>
<script src="{!! asset('assets/vendor/php-email-form/validate.js') !!}"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script src="{!! asset('assets/js/funciones.js') !!}"></script>
<!-- Template Main JS File -->
<script src="{!! asset('assets/js/main.js') !!}"></script>
<script>
$(document).ready(function() {
    $.ajax({
        url: '{{ route('empresa') }}', // URL de la ruta
        type: 'GET',
        success: function(response) {
            var nombreEmpresa = response.empresa_config;
            var logo = response.logo_config;
            $('.nombre_empresa').text(nombreEmpresa)
            if (typeof logo !== 'undefined' && logo) {
                var src = "{!! asset('assets/img/logos/') !!}/" + logo;
                $('.logo_empresa').attr('src', src);
            } else {
                var src = "{!! asset('assets/img/logos/logo.png') !!}";
                $('.logo_empresa').attr('src', src);
            }
        },
        error: function(xhr) {
            console.error('Error:', xhr);
        }
    });
});
</script>
</body>
</html>
