@php
$VerEditor = auth()->user()->can('Productos / Marcas - Visor') || auth()->user()->can('Productos / Marcas - Editor')
@endphp
@if($VerEditor)
@extends('layouts/app')
@section('tituloModulo', 'MARCAS')
@section('contenido')
<div class="card">
    <div class="card-body">
        @can('Productos / Marcas - Editor')
        <button type="button" class="btn btn-success mt-3" data-bs-toggle="modal" data-bs-target="#crear">
            <i class="bx bxs-folder-plus"></i> Agregar marca
        </button>
        <div class="modal fade" id="crear" tabindex="-1">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Agregar marca</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form action="{{ route('marcas.store') }}" method="POST">
                        @csrf
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-12 col-12">
                                <label class="control-label is-required">Nombre</label>
                                <input class="form-control" type="text" name="nombre" required>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success"><i class="bx bx-save"></i> Guardar</button>
                        <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="bx  bxs-x-circle"></i> Cerrar</button>
                    </div>
                    </form>
                </div>
            </div>
        </div>
        @endcan
        <div class="datatable-wrapper datatable-loading no-footer sortable searchable fixed-columns">
            <div class="datatable-container">
                <table class="table datatable datatable-table">
                    <thead>
                        <tr class="text">
                            <th data-sortable="true" scope="col">NOMBRE</th>
                            <th data-sortable="true" scope="col">ESTATUS</th>
                            @can('Productos / Marcas - Editor')
                            <th data-sortable="true" scope="col">ACCIÓN</th>
                            @endcan
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($datos as $item)
                        <tr>
                            <td data-title="NOMBRE">{{ $item->nombre_prma }}</td>
                            <td data-title="ESTATUS">
                                @if($item->estatus_prma == 'Activo')
                                    <span class="badge bg-success">{{$item->estatus_prma}}</span>
                                @endif
                                @if ($item->estatus_prma == 'Inactivo')
                                    <span class="badge bg-danger">{{$item->estatus_prma}}</span>
                                @endif
                            </td>
                            @can('Productos / Marcas - Editor')
                            <td data-title="ACCIÓN">
                                <div class="btn-group">
                                    <button type="button" class="btn btn-outline-primary dropdown-toggle btnTabla"
                                        data-bs-toggle="dropdown" aria-expanded="false">Acción <i
                                            class="mdi mdi-chevron-down"></i></button>
                                    <div class="dropdown-menu">
                                        <button type="button" class="btn btn-outline-success mt-2 dropdown-item" data-bs-toggle="modal" data-bs-target="#editar{{  $item->codigo_prma }}">
                                            <i class="bx bxs-edit"></i> Editar
                                        </button>
                                        <form action="{{ route('marcas.activate', $item->codigo_prma) }}" method="POST" enctype="multipart/form-data" class="form-activar">
                                            @csrf
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx bx-check-circle"></i> Activar
                                            </button>
                                        </form>
                                        <form action="{{ route('marcas.inactivate', $item->codigo_prma) }}" method="POST" enctype="multipart/form-data" class="form-inactivar">
                                            @csrf
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx bx-x-circle"></i> Inactivar
                                            </button>
                                        </form>
                                        <form action="{{ route('marcas.delete', $item->codigo_prma) }}" method="POST" enctype="multipart/form-data" class="form-delete">
                                            @csrf
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx  bxs-trash"></i> Eliminar
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </td>
                            @endcan
                        </tr>
                        @can('Productos / Marcas - Editor')
                        <div class="modal fade" id="editar{{  $item->codigo_prma }}" tabindex="-1">
                            <div class="modal-dialog modal-lg">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title">Editar marca</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <form action="{{ route('marcas.update',  $item->codigo_prma) }}" method="POST">
                                        @csrf
                                    <div class="modal-body">
                                        <div class="row">
                                            <div class="col-md-12 col-12">
                                                <label class="control-label is-required">Nombre</label>
                                                <input class="form-control" value="{{ $item->nombre_prma }}" type="text" name="nombre" required>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="submit" class="btn btn-success"><i class="bx bx-save"></i> Actualizar</button>
                                        <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="bx  bxs-x-circle"></i> Cerrar</button>
                                    </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        @endcan
                        @endforeach
                    </tbody>
                </table>
            </div>
            <div class="datatable-bottom">
                <nav class="datatable-pagination">
                    <ul class="datatable-pagination-list"></ul>
                </nav>
            </div>
        </div>
    </div>
</div>
@endsection
@endif

