@php
$VerEditor = auth()->user()->can('Pedidos - Visor') || auth()->user()->can('Pedidos - Editor')
@endphp
@if($VerEditor)
@extends('layouts/app')
@section('tituloModulo', 'PEDIDOS')
@section('contenido')
<div class="card">
    <div class="card-body">
        <div class="datatable-wrapper datatable-loading no-footer sortable searchable fixed-columns">
            <div class="datatable-container">
                <table class="table datatable datatable-table">
                    <thead>
                        <tr class="text">
                            <th data-sortable="true" scope="col">{{ "NO. COMPRA" }}</th>
                            <th data-sortable="true" scope="col">ID MERCADO PAGO</th>
                            <th data-sortable="true" scope="col">NOMBRE</th>
                            <th data-sortable="true" scope="col">TELÉFONO</th>
                            <th data-sortable="true" scope="col">CORREO ELECTRÓNICO</th>
                            <th data-sortable="true" scope="col">SUBTOTAL</th>
                            <th data-sortable="true" scope="col">DESCUENTO</th>
                            <th data-sortable="true" scope="col">TOTAL</th>
                            <th data-sortable="true" scope="col">REQUIERE FACTURA</th>
                            <th data-sortable="true" scope="col">ESTATUS</th>
                            @can('Pedidos - Editor')
                            <th data-sortable="true" scope="col">ACCIÓN</th>
                            @endcan
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($datos as $item)
                        <tr>
                            <td data-title="{{ "NO. COMPRA" }}">{{ $item->numero_pago }}</td>
                            <td data-title="ID MERCADO PAGO">{{ $item->payment_id_paco }}</td>
                            <td data-title="NOMBRE">{{ $item->nombre_comp }}</td>
                            <td data-title="TELÉFONO">{{ $item->telefono_comp }}</td>
                            <td data-title="CORREO ELECTRÓNICO">{{ $item->email_comp }}</td>
                            <td data-title="SUBTOTAL">{{ "$" . number_format($item->sub_total_comp, 2) }}</td>
                            <td data-title="DESCUENTO">{{ "$" . number_format($item->descuento_comp, 2) }}</td>
                            <td data-title="TOTAL">{{ "$" . number_format($item->total_comp, 2) }}</td>
                            <td data-title="REQUIERE FACTURA">@if ($item->requiereFact) Requiere Factura @else Sin Factura @endif </td>
                            <td data-title="ESTATUS">
                                @if($item->estatus_paco == 'Pagado')
                                    <span class="badge bg-warning">{{$item->estatus_paco}}</span>
                                @endif
                                @if ($item->estatus_paco == 'Enviado')
                                    <span class="badge bg-primary">{{$item->estatus_paco}}</span>
                                @endif
                                @if ($item->estatus_paco == 'Entregado')
                                    <span class="badge bg-success">{{$item->estatus_paco}}</span>
                                @endif
                            </td>
                            @can('Pedidos - Editor')
                            <td data-title="ACCIÓN">
                                <div class="btn-group">
                                    <button type="button" class="btn btn-outline-primary dropdown-toggle btnTabla"
                                        data-bs-toggle="dropdown" aria-expanded="false">Acción <i
                                            class="mdi mdi-chevron-down"></i></button>
                                    <div class="dropdown-menu">
                                        <form action="{{ route('pedidos.downloadPDFOC', $item->cod_pago_paco) }}" method="GET">
                                            <button type="submit" class="btn btn-outline-success mt-2 dropdown-item">
                                                <i class="fa-solid fa-file-pdf"></i> Ver Orden de Compra
                                            </button>
                                        </form>
                                        @role('Administrador')
                                        <form action="{{ route('pedidos.update', ['estatus'=>'Enviado','id'=>$item->codigo_paco]) }}" method="POST" class="form-enviar">
                                            @csrf
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="fa-solid fa-truck"></i> Enviar
                                            </button>
                                        </form>
                                        <form action="{{ route('pedidos.update', ['estatus'=>'Entregado','id'=>$item->codigo_paco]) }}" method="POST" class="form-entregar">
                                            @csrf
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="fa-solid fa-truck-ramp-box"></i> Entregar
                                            </button>
                                        </form>
                                        @endrole
                                    </div>
                                </div>
                            </td>
                            @endcan
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <div class="datatable-bottom">
                <nav class="datatable-pagination">
                    <ul class="datatable-pagination-list"></ul>
                </nav>
            </div>
        </div>
    </div>
</div>
@endsection
@endif

