@php
$VerEditor = auth()->user()->can('Productos - Editor')
@endphp
@if($VerEditor)
@extends('layouts/app')
@section('tituloModulo', 'DATOS DEL PRODUCTO')
@section('contenido')
<div class="card">
    <div class="card-body">
        <form action="{{ route('productos.update', $datos->codigo_prod) }}" method="POST"  enctype="multipart/form-data">
            @csrf
            <div class="row mt-2">
                <div class="col-md-12 col-12 text-center">
                    @if ($datos->imagen_principal_prod)
                    <img src="{{ asset('assets/img/productos/' . $datos->imagen_principal_prod) }}" alt="Producto" width="250" >
                    @else
                    <img src="{!! asset('assets/img/products.png') !!}" alt="Profile" width="150" height="250" >
                    @endif
                </div>
                <div class="col-md-6 col-12">
                    <label class="control-label is-required">SKU</label>
                    <input class="form-control" name="sku" value="{{ $datos->sku_prod }}" type="text" required>
                </div>
                <div class="col-md-6 col-12">
                    <label class="control-label">Imagen principal</label>
                    <input class="form-control" name="imagenPrincipal"  type="file">
                </div>
                <div class="col-md-12 col-12">
                    <label class="control-label is-required">Nombre</label>
                    <input class="form-control" name="nombre" value="{{ $datos->nombre_prod }}"type="text" required>
                </div>
                <div class="col-md-6 col-12">
                    <label class="control-label is-required">Categoría de producto</label>
                    <select class="form-select "  name="categoria" id="categoria" required>
                        <option value="{{ $datos->codigo_prca }}">{{ $datos->nombre_prca }}</option>
                        @foreach ($categorias as $categoria)
                        <option value="{{ $categoria->codigo_prca }}">{{ $categoria->nombre_prca }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-6 col-12">
                    <label class="control-label is-required">Subcategoría de producto</label>
                    <select class="form-select "  name="subcategoria" id="subcategoria" required>
                        <option value="{{ $datos->codigo_prsu }}">{{ $datos->nombre_prsu }}</option>
                        @foreach ($subcategorias as $subcategoria)
                        <option value="{{ $subcategoria->codigo_prsu }}">{{ $subcategoria->nombre_prsu }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-6 col-12">
                    <label class="control-label">Compra</label>
                    <input id="input-currency" class="form-control input-mask text-left"
                    data-inputmask="'alias': 'numeric', 'groupSeparator': '', 'digits': 0, 'digitsOptional': false, 'prefix': '$ ', 'placeholder': '0'"
                    name="compra" value="{{ $datos->compra_prod }}">
                </div>
                <div class="col-md-6 col-12">
                    <label class="control-label">Venta</label>
                    <input id="input-currency" class="form-control input-mask text-left"
                    data-inputmask="'alias': 'numeric', 'groupSeparator': '', 'digits': 0, 'digitsOptional': false, 'prefix': '$ ', 'placeholder': '0'"
                    name="venta" value="{{ $datos->venta_prod }}">
                </div>
                <div class="col-md-6 col-12">
                    <label class="control-label is-required">Stock</label>
                    <input class="form-control" name="stock" value="{{ $datos->stock_prod }}" type="number" >
                </div>
                <div class="col-md-6 col-12">
                    <label class="control-label is-required">Marca</label>
                    <select class="form-select "  name="marca" id="marca" required>
                        @if ($datos->marca_prod)
                        <option value="{{ $datos->codigo_prma }}">{{ $datos->nombre_prma }}</option>
                        @else
                        <option value="">Seleccione una marca</option>
                        @endif
                        @foreach ($marcas as $marca)
                        <option value="{{ $marca->codigo_prma }}">{{ $marca->nombre_prma }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-6 col-12">
                    <label class="control-label">¿EL producto estará en línea?</label>
                    <select class="form-select "  name="linea" required>
                        @if ($datos->linea_prod)
                        <option value="{{ $datos->linea_prod }}">{{ $datos->linea_prod }}</option>
                        @else
                        <option value="">Seleccione una opción</option>
                        @endif
                        <option value="Si">Si</option>
                        <option value="No">No</option>
                    </select>
                </div>
                <div class="col-md-6 col-12">
                    <label class="control-label">¿EL producto estará en la sección de ofertas?</label>
                    <select class="form-select "  name="oferta" required>
                        @if ($datos->ofertas_prod)
                        <option value="{{ $datos->ofertas_prod }}">{{ $datos->ofertas_prod }}</option>
                        @else
                        <option value="">Seleccione una opción</option>
                        @endif
                        <option value="Si">Si</option>
                        <option value="No">No</option>
                    </select>
                </div>
                <div class="col-md-6 col-12">
                    <label class="control-label">¿EL producto estará en la sección de nuevos productos?</label>
                    <select class="form-select "  name="nuevos" required>
                        @if ($datos->nuevo_prod)
                        <option value="{{ $datos->nuevo_prod }}">{{ $datos->nuevo_prod }}</option>
                        @else
                        <option value="">Seleccione una opción</option>
                        @endif
                        <option value="Si">Si</option>
                        <option value="No">No</option>
                    </select>
                </div>
                <div class="col-md-12 col-12">
                    <label class="control-label is-required">Descripción corta</label>
                    <div id="editor">{!! $datos->descripcion_corta_prod !!}</div>
                    <textarea name="descripcion_corta" style="display:none">{!! $datos->descripcion_corta_prod !!}</textarea>
                    <script>
                        ClassicEditor
                            .create( document.querySelector( '#editor' ) )
                            .then( editor => {
                                editor.model.document.on('change:data', () => {
                                    document.querySelector('textarea[name="descripcion_corta"]').value = editor.getData();
                                });
                            })
                            .catch( error => {
                                console.error( error );
                            } );
                    </script>
                </div>
                <div class="col-md-12 col-12">
                    <label class="control-label is-required">Descripción larga</label>
                    <div id="descripcionLarga">{!! $datos->descripcion_larga_prod !!}</div>
                    <textarea name="descripcion_larga" style="display:none">{!! $datos->descripcion_larga_prod !!}</textarea>
                    <script>
                        ClassicEditor
                            .create( document.querySelector( '#descripcionLarga' ) )
                            .then( descripcionLarga => {
                                descripcionLarga.model.document.on('change:data', () => {
                                    document.querySelector('textarea[name="descripcion_larga"]').value = descripcionLarga.getData();
                                });
                            })
                            .catch( error => {
                                console.error( error );
                            } );
                    </script>
                </div>
            </div>
            <button type="submit" class="btn btn-success mt-3" data-bs-toggle="modal" data-bs-target="#crear">
                <i class="bx  bxs-save"></i> Guardar
            </button>
        </form>
    </div>
</div>
<div class="card">
    <div class="card-body">
        <h5 class="card-title">Colores</h5>
        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#crearColor{{  $datos->codigo_prod }}">
            <i class="bx bxs-folder-plus"></i> Agregar color
        </button>
        <div class="datatable-wrapper datatable-loading no-footer sortable searchable fixed-columns">
            <div class="datatable-container">
                <table class="table datatable datatable-table">
                    <thead>
                        <tr class="text">
                            <th data-sortable="true" scope="col">COLOR</th>
                            <th data-sortable="true" scope="col">ACCIÓN</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($colores as $color)
                        <tr>
                            <td data-title="COLOR"><input type="color" class="form-control" style="width: 100%;" name="colorProducto" value="{{ $color->color_prco }}" disabled></td>
                            <td data-title="ACCIÓN">
                                <div class="btn-group">
                                    <button type="button" class="btn btn-outline-primary dropdown-toggle btnTabla"
                                        data-bs-toggle="dropdown" aria-expanded="false">Acción <i
                                            class="mdi mdi-chevron-down"></i></button>
                                    <div class="dropdown-menu">
                                        <form action="{{ route('productos.delete.color', $color->codigo_prco) }}" method="POST" enctype="multipart/form-data" class="form-delete">
                                            @csrf
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx  bxs-trash"></i> Eliminar
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <div class="datatable-bottom">
                <nav class="datatable-pagination">
                    <ul class="datatable-pagination-list"></ul>
                </nav>
            </div>
        </div>
    </div>
</div>
<div class="card">
    <div class="card-body">
        <h5 class="card-title">Imagenes secundarias</h5>
        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#crearImagen{{  $datos->codigo_prod }}">
            <i class="bx bxs-folder-plus"></i> Agregar imagen secundaria
        </button>
        <div class="datatable-wrapper datatable-loading no-footer sortable searchable fixed-columns">
            <div class="datatable-container">
                <table class="table datatable datatable-table">
                    <thead>
                        <tr class="text">
                            <th data-sortable="true" scope="col">IMAGEN</th>
                            <th data-sortable="true" scope="col">ACCIÓN</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($imagenes as $imagen)
                        <tr>
                            <td data-title="IMAGEN"><img src="{{ asset('assets/img/productos/' . $imagen->imagen_prim) }}" alt="Producto" width="100" >
                            </td>
                            <td data-title="ACCIÓN">
                                <div class="btn-group">
                                    <button type="button" class="btn btn-outline-primary dropdown-toggle btnTabla"
                                        data-bs-toggle="dropdown" aria-expanded="false">Acción <i
                                            class="mdi mdi-chevron-down"></i></button>
                                    <div class="dropdown-menu">
                                        <form action="{{ route('productos.delete.imagen', $imagen->codigo_prim) }}" method="POST" enctype="multipart/form-data" class="form-delete">
                                            @csrf
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx  bxs-trash"></i> Eliminar
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <div class="datatable-bottom">
                <nav class="datatable-pagination">
                    <ul class="datatable-pagination-list"></ul>
                </nav>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="crearImagen{{  $datos->codigo_prod }}" tabindex="-1">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Agregar imagen</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="{{ route('productos.store.imagen', $datos->codigo_prod) }}" method="POST" enctype="multipart/form-data">
                @csrf
            <div class="modal-body">
                <input class="form-control" name="imagen"  type="file">
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-success"><i class="bx bx-save"></i> Guardar</button>
                <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="bx  bxs-x-circle"></i> Cerrar</button>
            </div>
            </form>
        </div>
    </div>
</div>
<div class="modal fade" id="crearColor{{  $datos->codigo_prod }}" tabindex="-1">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Agregar color</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="{{ route('productos.store.color', $datos->codigo_prod) }}" method="POST" enctype="multipart/form-data">
                @csrf
            <div class="modal-body">
                <div class="form-group">
                <label class="control-label is-required">Color del producto</label>
                    <input type="color" class="form-control form-control-color" style="width: 100%;" name="colorProducto" value="#4154f1" title="Seleccona el color del producto">
                </div>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-success"><i class="bx bx-save"></i> Guardar</button>
                <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="bx  bxs-x-circle"></i> Cerrar</button>
            </div>
            </form>
        </div>
    </div>
</div>
@endsection
@endif

