@php
$VerEditor = auth()->user()->can('Productos - Visor') || auth()->user()->can('Productos - Editor')
@endphp
@if($VerEditor)
@extends('layouts/app')
@section('tituloModulo', 'PRODUCTOS')
@section('contenido')
<div class="card">
    <div class="card-body">
        @can('Productos - Editor')
        <button type="button" class="btn btn-success mt-3" data-bs-toggle="modal" data-bs-target="#crear">
            <i class="bx bxs-folder-plus"></i> Agregar producto
        </button>
        <div class="modal fade" id="crear" tabindex="-1">
            <div class="modal-dialog modal-xl">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Agregar producto</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form action="{{ route('productos.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                    <div class="modal-body">
                        <label class="control-label is-required">SKU</label>
                        <input class="form-control" type="text" name="sku" required>
                        <label class="control-label is-required">Nombre del producto</label>
                        <input class="form-control" type="text" name="nombre" required>
                        <label class="control-label is-required">Categoría de producto</label>
                        <select class="form-select "  name="categoria" id="categoria" required>
                            <option value="">Seleccione la categoría del producto</option>
                            @foreach ($categorias as $categoria)
                            <option value="{{ $categoria->codigo_prca }}">{{ $categoria->nombre_prca }}</option>
                            @endforeach
                        </select>
                        <label class="control-label is-required">Subcategoría de producto</label>
                        <select class="form-select "  name="subcategoria" id="subcategoria" required>
                            <option value="">Seleccione la categoría del producto</option>
                            @foreach ($subcategorias as $subcategoria)
                            <option value="{{ $subcategoria->codigo_prsu }}">{{ $subcategoria->nombre_prsu }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success"><i class="bx bx-save"></i> Guardar</button>
                        <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="bx  bxs-x-circle"></i> Cerrar</button>
                    </div>
                    </form>
                </div>
            </div>
        </div>
        @endcan
        <div class="datatable-wrapper datatable-loading no-footer sortable searchable fixed-columns">
            <div class="datatable-container">
                <table class="table datatable datatable-table">
                    <thead>
                        <tr class="text">
                            <th data-sortable="true" scope="col">IMAGEN</th>
                            <th data-sortable="true" scope="col">SKU</th>
                            <th data-sortable="true" scope="col">NOMBRE</th>
                            <th data-sortable="true" scope="col">CATEGORÍA</th>
                            <th data-sortable="true" scope="col">SUBCATEGORÍA</th>
                            <th data-sortable="true" scope="col">ESTATUS</th>
                            @can('Productos - Editor')
                            <th data-sortable="true" scope="col">ACCIÓN</th>
                            @endcan
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($datos as $item)
                        <tr>
                            <td data-title="IMAGEN">@if ($item->imagen_principal_prod)
                                <img src="{{ asset('assets/img/productos/' . $item->imagen_principal_prod) }}" alt="Producto" width="50" >
                                @else
                                <img src="{!! asset('assets/img/products.png') !!}" alt="Profile" width="50" height="50" >
                                @endif</td>
                            <td data-title="SKU">{{ $item->sku_prod }}</td>
                            <td data-title="NOMBRE">{{ $item->nombre_prod }}</td>
                            <td data-title="CATEGORÍA">{{ $item->nombre_prca }}</td>
                            <td data-title="SUBCATEGORÍA">{{ $item->nombre_prsu }}</td>
                            <td data-title="ESTATUS">
                                @if($item->estatus_prod == 'Activo')
                                    <span class="badge bg-success">{{$item->estatus_prod}}</span>
                                @endif
                                @if ($item->estatus_prod == 'Inactivo')
                                    <span class="badge bg-danger">{{$item->estatus_prod}}</span>
                                @endif
                            </td>
                            @can('Productos - Editor')
                            <td data-title="ACCIÓN">
                                <div class="btn-group">
                                    <button type="button" class="btn btn-outline-primary dropdown-toggle btnTabla"
                                        data-bs-toggle="dropdown" aria-expanded="false">Acción <i
                                            class="mdi mdi-chevron-down"></i></button>
                                    <div class="dropdown-menu">
                                        <form action="{{ route('productos.dats', $item->codigo_prod) }}" method="GET">
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx bxs-edit"></i> Editar
                                            </button>
                                        </form>
                                        <form action="{{ route('productos.activate', $item->codigo_prod) }}" method="POST" enctype="multipart/form-data" class="form-activar">
                                            @csrf
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx bx-check-circle"></i> Activar
                                            </button>
                                        </form>
                                        <form action="{{ route('productos.inactivate', $item->codigo_prod) }}" method="POST" enctype="multipart/form-data" class="form-inactivar">
                                            @csrf
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx bx-x-circle"></i> Inactivar
                                            </button>
                                        </form>
                                        <form action="{{ route('productos.delete', $item->codigo_prod) }}" method="POST" enctype="multipart/form-data" class="form-delete">
                                            @csrf
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx  bxs-trash"></i> Eliminar
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </td>
                            @endcan
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <div class="datatable-bottom">
                <nav class="datatable-pagination">
                    <ul class="datatable-pagination-list"></ul>
                </nav>
            </div>
        </div>
    </div>
</div>
@endsection
@endif

