@php
$VerEditor = auth()->user()->can('Roles - Visor') || auth()->user()->can('Roles - Editor')
@endphp
@if($VerEditor)
@extends('layouts/app')
@section('tituloModulo', 'ROLES')
@section('contenido')
<div class="card">
    <div class="card-body">
        @can('Roles - Editor')
        <button type="button" class="btn btn-success mt-3" data-bs-toggle="modal" data-bs-target="#crear">
            <i class="bx bxs-folder-plus"></i> Agregar Rol
        </button>
        <div class="modal fade" id="crear" tabindex="-1">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Agregar Rol</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form action="{{ route('roles.store') }}" method="POST">
                        @csrf
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-12 col-12">
                                <label class="control-label is-required">Nombre</label>
                                <input class="form-control" type="text" name="name" required>
                                <label for="permissions">Permisos:</label>
                                <select name="permissions[]" id="permissions"  class="form-control" multiple>
                                    @foreach($permissions as $permission)
                                        <option value="{{ $permission->name }}">{{ $permission->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success"><i class="bx bx-save"></i> Guardar</button>
                        <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="bx  bxs-x-circle"></i> Cerrar</button>
                    </div>
                    </form>
                </div>
            </div>
        </div>
        @endcan
        <h5 class="card-title">Roles y sus Permisos</h5>
            <ul>
            @foreach ($roles as $role)
                <li>{{ $role->name }}
                    @can('Roles - Editor')
                    <a data-bs-toggle="modal" data-bs-target="#editar{{ $role->id }}"><i class="bx bxs-edit"></i><strong>Editar</strong></a>
                    @endcan
                </li>
            <ul>
                @foreach ($role->permissions as $permission)
                    <li>{{ $permission->name }}</li>
                @endforeach
            </ul>
            @can('Roles - Editor')
                <div class="modal fade" id="editar{{ $role->id }}" tabindex="-1">
                    <div class="modal-dialog modal-lg">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title">Editar Rol</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <form action="{{ route('roles.update',  $role->id) }}" method="POST">
                                @csrf
                                @method('put')
                            <div class="modal-body">
                                <div class="row">
                                    <div class="col-md-12 col-12">
                                        <label class="control-label is-required">Nombre</label>
                                        <input class="form-control" type="text" name="name" value="{{ $role->name }}" disabled>
                                        <label for="permissions">Nuevos Permisos:</label>
                                        <label>Permisos:</label>
                                        @foreach($permissions as $permission)
                                            <div>
                                                <input type="checkbox" name="permissions[]" value="{{ $permission->name }}" {{ $role->permissions->contains($permission) ? 'checked' : '' }}>
                                                <label>{{ $permission->name }}</label>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-success"><i class="bx bx-save"></i> Actualizar</button>
                                <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="bx  bxs-x-circle"></i> Cerrar</button>
                            </div>
                            </form>
                        </div>
                    </div>
                </div>
            @endcan
            @endforeach
        </ul>
    </div>
</div>
@endsection
@endif
