@php
$VerEditor = auth()->user()->can('Productos / Subcategorías - Visor') || auth()->user()->can('Productos / Subcategorías - Editor')
@endphp
@if($VerEditor)
@extends('layouts/app')
@section('tituloModulo', 'SUBCATEGORÍAS')
@section('contenido')
<div class="card">
    <div class="card-body">
        @can('Productos / Subcategorías - Editor')
        <button type="button" class="btn btn-success mt-3" data-bs-toggle="modal" data-bs-target="#crear">
            <i class="bx bxs-folder-plus"></i> Agregar Subcategoría
        </button>
        <div class="modal fade" id="crear" tabindex="-1">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Agregar Subcategoría</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form action="{{ route('subcategorias.store') }}" method="POST">
                        @csrf
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-12 col-12">
                                <label class="control-label is-required">Nombre</label>
                                <input class="form-control" type="text" name="nombre" required>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success"><i class="bx bx-save"></i> Guardar</button>
                        <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="bx  bxs-x-circle"></i> Cerrar</button>
                    </div>
                    </form>
                </div>
            </div>
        </div>
        @endcan
        <div class="datatable-wrapper datatable-loading no-footer sortable searchable fixed-columns">
            <div class="datatable-container">
                <table class="table datatable datatable-table">
                    <thead>
                        <tr class="text">
                            <th data-sortable="true" scope="col">NOMBRE</th>
                            <th data-sortable="true" scope="col">ESTATUS</th>
                            @can('Productos / Subcategorías - Editor')
                            <th data-sortable="true" scope="col">ACCIÓN</th>
                            @endcan
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($datos as $item)
                        <tr>
                            <td data-title="NOMBRE">{{ $item->nombre_prsu }}</td>
                            <td data-title="ESTATUS">
                                @if($item->estatus_prsu == 'Activo')
                                    <span class="badge bg-success">{{$item->estatus_prsu}}</span>
                                @endif
                                @if ($item->estatus_prsu == 'Inactivo')
                                    <span class="badge bg-danger">{{$item->estatus_prsu}}</span>
                                @endif
                            </td>
                            @can('Productos / Subcategorías - Editor')
                            <td data-title="ACCIÓN">
                                <div class="btn-group">
                                    <button type="button" class="btn btn-outline-primary dropdown-toggle btnTabla"
                                        data-bs-toggle="dropdown" aria-expanded="false">Acción <i
                                            class="mdi mdi-chevron-down"></i></button>
                                    <div class="dropdown-menu">
                                        <button type="button" class="btn btn-outline-success mt-2 dropdown-item" data-bs-toggle="modal" data-bs-target="#editar{{  $item->codigo_prsu }}">
                                            <i class="bx bxs-edit"></i> Editar
                                        </button>
                                        <form action="{{ route('subcategorias.activate', $item->codigo_prsu) }}" method="POST" enctype="multipart/form-data" class="form-activar">
                                            @csrf
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx bx-check-circle"></i> Activar
                                            </button>
                                        </form>
                                        <form action="{{ route('subcategorias.inactivate', $item->codigo_prsu) }}" method="POST" enctype="multipart/form-data" class="form-inactivar">
                                            @csrf
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx bx-x-circle"></i> Inactivar
                                            </button>
                                        </form>
                                        <form action="{{ route('subcategorias.delete', $item->codigo_prsu) }}" method="POST" enctype="multipart/form-data" class="form-delete">
                                            @csrf
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx  bxs-trash"></i> Eliminar
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </td>
                            @endcan
                        </tr>
                        @can('Productos / Subcategorías - Editor')
                        <div class="modal fade" id="editar{{  $item->codigo_prsu }}" tabindex="-1">
                            <div class="modal-dialog modal-lg">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title">Editar subcategoría</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <form action="{{ route('subcategorias.update',  $item->codigo_prsu) }}" method="POST">
                                        @csrf
                                    <div class="modal-body">
                                        <div class="row">
                                            <div class="col-md-12 col-12">
                                                <label class="control-label is-required">Nombre</label>
                                                <input class="form-control" value="{{ $item->nombre_prsu }}" type="text" name="nombre" required>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="submit" class="btn btn-success"><i class="bx bx-save"></i> Actualizar</button>
                                        <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="bx  bxs-x-circle"></i> Cerrar</button>
                                    </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        @endcan
                        @endforeach
                    </tbody>
                </table>
            </div>
            <div class="datatable-bottom">
                <nav class="datatable-pagination">
                    <ul class="datatable-pagination-list"></ul>
                </nav>
            </div>
        </div>
    </div>
</div>
@endsection
@endif

