@php
$VerEditor = auth()->user()->can('Suscripciones - Visor') || auth()->user()->can('Suscripciones - Editor')
@endphp
@if($VerEditor)
@extends('layouts/app')
@section('tituloModulo', 'SUSCRIPCIONES')
@section('contenido')
<div class="card">
    <div class="card-body">
        <div class="datatable-wrapper datatable-loading no-footer sortable searchable fixed-columns">
            <div class="datatable-container">
                <table class="table datatable datatable-table">
                    <thead>
                        <tr class="text">
                            <th data-sortable="true" scope="col">CORREO ELECTRÓNICO</th>
                            <th data-sortable="true" scope="col">FECHA DE REGISTRO</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($datos as $item)
                        <tr>
                            <td data-title="CORREO ELECTRÓNICO">{{ $item->email_susc }}</td>
                            <td data-title="FECHA DE REGISTRO">{{ date("d/m/Y", strtotime($item->fecha_susc)) }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <div class="datatable-bottom">
                <nav class="datatable-pagination">
                    <ul class="datatable-pagination-list"></ul>
                </nav>
            </div>
        </div>
    </div>
</div>
@endsection
@endif

