@extends('tienda/layout')
@section('contenido')
<style>
    .color-circle {
        display: inline-block;
        width: 30px;
        height: 30px;
        border-radius: 50%;
        border: 5px solid #ccc;
        cursor: pointer;
        transition: border-color 0.3s; /* Transición suave para el cambio de color del borde */
    }
    /* Estilo para el borde dorado cuando el radio button está seleccionado */
    .custom-control-input:checked ~ .color-circle {
        border-color: gold;
    }
</style>
<!-- Navbar Start -->
    <div class="container-fluid">
        <div class="row border-top px-xl-5">
            <div class="col-lg-3 d-none d-lg-block">
                <a class="btn shadow-none d-flex align-items-center justify-content-between text-white w-100  color-principal" data-toggle="collapse" href="#navbar-vertical" style="height: 65px; margin-top: -1px; padding: 0 30px; background-color: #ffffff;">
                    <h6 class="m-0">Categorías</h6>
                    <i class="fa fa-angle-down text-dark"></i>
                </a>
                <nav class="collapse position-absolute navbar navbar-vertical navbar-light align-items-start p-0 border border-top-0 border-bottom-0 bg-light" id="navbar-vertical" style="width: calc(100% - 30px); z-index: 1;">
                    <div class="navbar-nav w-100 overflow-hidden" style="height: 410px">
                        <div class="nav-item dropdown">
                            <a href="#" class="nav-link" data-toggle="dropdown">Subcategoría <i class="fa fa-angle-down float-right mt-1"></i></a>
                            <div class="dropdown-menu position-absolute bg-secondary border-0 rounded-0 w-100 m-0">
                                @foreach ($subcategorias as $subcategoria)
                                <form action="{{ route('filtro') }}" method="POST" id="form-{{ $subcategoria->codigo_prsu }}">
                                    @csrf
                                    <a href="#" class="dropdown-item" onclick="document.getElementById('form-{{ $subcategoria->codigo_prsu }}').submit(); return false;">
                                    {{ $subcategoria->nombre_prsu }}</a>
                                    <input type="hidden" name="subcategoria[]" value="{{ $subcategoria->codigo_prsu }}">
                                </form>
                                @endforeach
                            </div>
                        </div>
                        @foreach ($categorias as $categoria)
                        <form action="{{ route('filtro') }}" method="POST" id="form-{{ $categoria->codigo_prca }}">
                            @csrf
                            <a href="#" class="nav-item nav-link" onclick="document.getElementById('form-{{ $categoria->codigo_prca }}').submit(); return false;">
                            {{ $categoria->nombre_prca }}</a>
                            <input type="hidden" name="categoria[]" value="{{ $categoria->codigo_prca }}">
                        </form>
                        @endforeach
                    </div>
                </nav>
            </div>
            <div class="col-lg-9">
                <nav class="navbar navbar-expand-lg bg-light navbar-light py-3 py-lg-0 px-0">
                    <a href="" class="text-decoration-none d-block d-lg-none">
                        <h1 class="m-0 display-5 font-weight-semi-bold"><img alt="logo" class="logo_empresa" width="50"><span class="nombre_empresa"></span></h1>
                    </a>
                    <button type="button" class="navbar-toggler" data-toggle="collapse" data-target="#navbarCollapse">
                        <span class="navbar-toggler-icon"></span>
                    </button>
                    <div class="collapse navbar-collapse justify-content-between" id="navbarCollapse">
                        <div class="navbar-nav mr-auto py-0">
                            <a href="{{ route('index')}}" class="nav-item nav-link active">Inicio</a>
                            <a href="{{ route('catalogo')}}" class="nav-item nav-link">Tienda</a>
                            <a href="{{ route('carrito')}}" class="nav-item nav-link">Carrito</a>
                            <a href="{{ route('eventos')}}" class="nav-item nav-link">Eventos</a>
                            <a href="https://elblogdelauto.com" class="nav-item nav-link">Nosotros</a>
                            <a href="{{ route('contacto')}}" class="nav-item nav-link">Contacto</a>
                        </div>
                        <div class="navbar-nav ml-auto py-0">
                            @if(Auth::check())
                            <a href="{{ route('home')}}" class="nav-item nav-link">Panel de control</a>
                            @else
                            <a href="{{ route('login')}}" class="nav-item nav-link">Acceso</a>
                            <a href="{{ route('register')}}" class="nav-item nav-link">Registro</a>
                            @endif
                        </div>
                    </div>
                </nav>
            </div>
        </div>
    </div>
    <!--HEADER INICIO -->
    <div class="container-fluid">
        <div class="d-flex flex-column align-items-center justify-content-center" style="min-height: 50px">
            <h1 class="font-weight-semi-bold text-uppercase">Carrito de compras</h1>
            <div class="d-inline-flex">
                <p class="m-0"><a href="{{ route('index')}}" class="color-principal-color">Inicio</a></p>
                <p class="m-0 px-2">-</p>
                <p class="m-0">Catálogo</p>
            </div>
        </div>
    </div>
    <!--HEADER FIN -->
    <!-- CONTENIDO INICIO-->
    <div class="container-fluid pt-5">
        <div class="row px-xl-5">
            <div class="col-lg-8 table-responsive mb-5">
                <table class="table table-bordered text-center mb-0">
                    <thead class="color-principal" style="color: #ffffff">
                        <tr>
                            <th></th>
                            <th>Producto</th>
                            <th>Precio</th>
                            <th>Cantidad</th>
                            <th>Total</th>
                            <th>Eliminar</th>
                        </tr>
                    </thead>
                    <tbody class="align-middle">
                        @if ($totalProducts >= 1)
                        @foreach ($cart  as $item)
                        <tr>
                            <td class="align-middle"><a href="{{ route('detalle.producto', $item['product'])}}"><img src="{{ asset('assets/img/productos/' .   $item['imagenProduct']) }}" alt="" style="width: 50px;"></a></td>
                            <td class="align-middle">{{ $item['nombreProduct'] }} @if ($item['color']) Color: <div style="display: inline-block; width: 20px; height: 20px; background-color: {{ $item['color'] }}; border-radius: 50%;"></div>@endif
                            </td>
                            <td class="align-middle">{{ "$" . number_format($item['costo'], 2) }}</td>
                            <td class="align-middle">
                                <div class="input-group quantity mx-auto" style="width: 100px;">
                                    <div class="input-group-btn">
                                        <button class="btn btn-sm color-principal btn-minus" style="color: #ffffff">
                                            <i class="fa fa-minus"></i>
                                        </button>
                                    </div>
                                    <input type="text" class="form-control form-control-sm bg-secondary text-center numberx" value="{{ $item['cantidad'] }}" data-product-id="{{ $item['token'] }}" maxlength="2" size="1">
                                    <div class="input-group-btn">
                                        <button class="btn btn-sm color-principal btn-plus" style="color: #ffffff">
                                            <i class="fa fa-plus"></i>
                                        </button>
                                    </div>
                                </div>
                            </td>
                            <td class="align-middle subtotalProducto{{ $item['token'] }}">{{ "$" . number_format($item['total'], 2) }}</td>
                            <td class="align-middle"><a href="{{ route('eliminar.carrito', $item['token']) }}" class="btn btn-sm color-principal" style="color: #ffffff"><i class="fa fa-times"></i></a></td>
                        </tr>
                        @endforeach
                        @endif
                    </tbody>
                </table>
            </div>
            <div class="col-lg-4">
                <form class="mb-5"  action="{{ route('cupon')}}" method="POST">
                    @csrf
                    <div class="input-group">
                        <input type="text"  name="cupon" class="form-control p-4" placeholder="Código">
                        <div class="input-group-append">
                            <button class="btn color-principal btn btn-primary" style="color: #ffffff">Aplicar cupón</button>
                        </div>
                    </div>
                </form>
                <div class="card border-secondary mb-5">
                    <div class="card-header border-0 color-principal">
                        <h4 class="font-weight-semi-bold m-0"  style="color: #ffffff">Resumen de la compra</h4>
                    </div>
                    <div class="card-body">
                        @php
                        $totalCost = 0; // Inicializamos el total en 0
                        if ($cart) {
                            foreach ($cart as $item) {
                                // Sumamos el costo del producto actual al total
                                $totalCost += $item['costo'] * $item['cantidad'];
                            }
                        }
                        @endphp
                        <div class="d-flex justify-content-between mb-3 pt-1">
                            <h6 class="font-weight-medium">Subtotal</h6>
                            <h6 class="font-weight-medium subtotal">{{ "$" . number_format($totalCost, 2)  }}</h6>
                        </div>
                        @if($datosCupon)
                        <div class="d-flex justify-content-between">
                            <h6 class="font-weight-medium">Descuento</h6>
                            @if ($datosCupon->tipo_cupo == 'Porcentaje')
                            {{ number_format($datosCupon->descuento_cupo, 0) . "%" }}
                            @endif
                            @if ($datosCupon->tipo_cupo == 'Monetario')
                                {{ "$" . number_format($datosCupon->descuento_cupo, 2) }}
                            @endif
                            @if ($datosCupon->tipo_cupo == 'Porcentaje')
                            <h6 class="font-weight-medium descuento">{{"$" . number_format($totalCost * ($datosCupon->descuento_cupo / 100 ), 2) }}</h6>
                            @endif
                            @if ($datosCupon->tipo_cupo == 'Monetario')
                            <h6 class="font-weight-medium descuento">{{ "$" . number_format($datosCupon->descuento_cupo, 2) }}</h6>
                            @endif
                        </div>
                        @endif
                    </div>
                    <div class="card-footer border-secondary bg-transparent">
                        <div class="d-flex justify-content-between mt-2">
                            <h5 class="font-weight-bold">Total</h5>
                            @if($datosCupon)
                            @if ($datosCupon->tipo_cupo == 'Porcentaje')
                            <h5 class="font-weight-bold total">{{ "$" . number_format($totalCost - ($totalCost * ($datosCupon->descuento_cupo / 100 )), 2) }}</h5>
                            @endif
                            @if ($datosCupon->tipo_cupo == 'Monetario')
                            <h5 class="font-weight-bold total">{{ "$" . number_format($totalCost -  $datosCupon->descuento_cupo,2) }}</h5>
                            @endif
                        @else
                        <h5 class="font-weight-bold total">{{ "$" . number_format($totalCost,2) }}</h5>
                        @endif
                        </div>
                        @if ($cart)
                        <a href="{{ route('procesar.compra')}}" class="btn btn-block color-principal my-3 py-3" style="color: #ffffff">PROCESAR COMPRA</a>@else
                        <div class="alert alert-danger mt-2">Carrito Vacio</div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
        $(document).ready(function() {
            $(document).ready(function() {
                // Manejar entrada manual de números
                $('.numberx').on('keypress input', function(e) {
                    var key = e.which || e.keyCode;
                    var value = $(this).val();
                    // Validar solo números
                    if ((key < 48 || key > 57) && key !== 8 && key !== 46) {
                        e.preventDefault();
                        Swal.fire({
                            icon: "error",
                            title: "Oops...",
                            text: "¡Solo debe ingresar números!",
                        });
                        return;
                    }
                    // Validar valor mínimo
                    if (value < 1 || isNaN(value)) {
                        $(this).val(1);
                        Swal.fire({
                            icon: "error",
                            title: "Oops...",
                            text: "¡El valor mínimo es 1!",
                        });
                        return;
                    }
                    processNumber($(this));
                });
                // Manejar clicks en botones + y -
                $('.btn-plus').on('click', function() {
                    var $input = $(this).closest('.quantity').find('.numberx');
                    var currentValue = parseInt($input.val());
                    $input.val(currentValue + 1);
                    processNumber($input);
                });
                $('.btn-minus').on('click', function() {
                    var $input = $(this).closest('.quantity').find('.numberx');
                    var currentValue = parseInt($input.val());
                    if (currentValue > 1) {
                        $input.val(currentValue - 1);
                        processNumber($input);
                    } else {
                        Swal.fire({
                            icon: "error",
                            title: "Oops...",
                            text: "¡El valor mínimo es 1!",
                        });
                    }
                });
                function processNumber($input) {
                    var productId = $input.data('product-id');
                    var newValue = $input.val();
                    $.ajax({
                        url: '/carrito/actualizar/' + productId + '/' + newValue,
                        method: 'GET',
                        success: function(response) {
                            // Actualizar subtotal del producto
                            $('.subtotalProducto' + productId).text(
                                response.subtotalProducto.toLocaleString('es-MX', {
                                    style: 'currency',
                                    currency: 'MXN'
                                })
                            );
                            // Actualizar subtotal general
                            $('.subtotal').text(
                                response.nuevoSubtotal.toLocaleString('es-MX', {
                                    style: 'currency',
                                    currency: 'MXN'
                                })
                            );
                            // Actualizar descuento si existe
                            if (response.nuevoDescuento > 0) {
                                $('.descuento').text(
                                    response.nuevoDescuento.toLocaleString('es-MX', {
                                        style: 'currency',
                                        currency: 'MXN'
                                    })
                                );
                            }
                            // Actualizar total
                            $('.total').text(
                                response.nuevototal.toLocaleString('es-MX', {
                                    style: 'currency',
                                    currency: 'MXN'
                                })
                            );
                        }
                    });
                }
            });
        });
    </script>
    <!-- CONTENIDO FIN -->
@endsection
