<!DOCTYPE html>
<html>
    <head>
    <meta charset="utf-8">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <style type="text/css">
    .logoEmpresaPDF{
        text-align:center;
        width:150px;
    }
    .tituloEmpresaPDF{
        text-align:center;
        width:400px;
        color: #003C8D;
    }
    .datosPDF{
        margin-left: auto;
        margin-right: auto;
        width: 100%;
        font-size: 12px;
    }
    .thDatosPDF{
        width: 5%;
        text-align: left;
        font-size: 12px;
    }
    .thDatosDPDF{
        width: 5%;
        text-align: LEFT;
        font-size: 12px;
    }
    .header {
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        text-align: center;
        padding: 12px;
    }
    /* Estilos para el contenido */
    .content {
        margin-top: 60px; /* Ajusta el margen superior para dejar espacio para el encabezado */
    }
    body {
        font-family: Arial, sans-serif;
        margin: 0;
        padding: 0;
    }
    .container {
        max-width: 600px;
        margin: 20px auto;
        padding: 20px;
        border: 1px solid #ccc;
        border-radius: 12px;
    }
    h1 {
        text-align: center;
    }
    h4 {
        text-align: center;
    }
    table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 20px;
    }
    th, td {
        padding: 5px;
        border-bottom: 1px solid #ddd;
        text-align: left;
        font-size: 12px;
    }
    th {
        background-color: #f2f2f2;
    }
    tr.total {
        font-weight: bold;
    }
    td:last-child {
        text-align: right;
    }
    </style>
</head>
<body>
    <table>
        <tr>
            <td class="logoEmpresaPDF"> <img src="{{ public_path('/assets/img/logos/'. $empresaImg ) }}" alt="" width="100"></td>
            <td class="tituloEmpresaPDF"><h3>COMPROBANTE DE PAGO DEL EVENTO</h3></td>
        </tr>
    </table><br>
    <table class="datosPDF">
        <tr>
            <th  style="background-color: {{ $empresaColor }}; color:aliceblue; text-align: center;"><h1>¡Gracias por su compra!</h1></th>
        </tr>
        <tr>
            <th>
                <span class="input-group-text">Estimado {{ "(a):" }} {{ $nombre }},<br>
                Nos complace informarte que has realizado una compra para nuestro evento en nuestra tienda en línea. Queremos confirmarte los detalles de tu compra para garantizar una experiencia de compra sin problemas.<br><br><br>
                Detalles de la compra:<br><br>
                <strong>Evento comprado:</strong> {{ $evento }}<br>
                <strong>Fecha de compra:</strong> {{ $fechaActual }}<br><br>
                ...<br>
                <strong>Total de la compra:</strong> {{ "$" . number_format($total, 2) }}<br><br>
                <strong>Código QR {{ "(Entradas por escaneo)" }}</strong><br><br><br>
                    @foreach ($compras as $index => $compra)
                    <p>Boleto No . {{ $index + 1 }}</p>
                    <img src="https://tienda.elblogdelauto.com/assets/img/qrs/{{ $compra->qr_ebven }}" alt="" width="100">
                    @endforeach
                <br><br>
                Si tienes alguna pregunta o necesitas más asistencia, no dudes en ponerte en contacto con nuestro equipo de atención al cliente. Estamos aquí para ayudarte en cualquier momento.<br><br>
                Gracias por elegirnos. Valoramos tu confianza en nosotros y esperamos que disfrutes de tus productos.<br><br>
                Atentamente,<br><br><br>
                <strong>{{ $empresaCorreo }}</strong><br>
                Equipo de Atención al Cliente</span>
            </th>
        </tr>
    </table>
</body>
</html>
