@extends('tienda/layout')
@section('contenido')
<style>
    .color-circle {
        display: inline-block;
        width: 30px;
        height: 30px;
        border-radius: 50%;
        border: 5px solid #ccc;
        cursor: pointer;
        transition: border-color 0.3s; /* Transición suave para el cambio de color del borde */
    }
    /* Estilo para el borde dorado cuando el radio button está seleccionado */
    .custom-control-input:checked ~ .color-circle {
        border-color: gold;
    }
</style>
<!-- Navbar Start -->
    <div class="container-fluid">
        <div class="row border-top px-xl-5">
            <div class="col-lg-3 d-none d-lg-block">
                <a class="btn shadow-none d-flex align-items-center justify-content-between color-principal text-white w-100" data-toggle="collapse" href="#navbar-vertical" style="height: 65px; margin-top: -1px; padding: 0 30px;  background-color: #ffffff;" >
                    <h6 class="m-0">Categorías</h6>
                    <i class="fa fa-angle-down text-dark"></i>
                </a>
                <nav class="collapse position-absolute navbar navbar-vertical navbar-light align-items-start p-0 border border-top-0 border-bottom-0 bg-light" id="navbar-vertical" style="width: calc(100% - 30px); z-index: 1;">
                    <div class="navbar-nav w-100 overflow-hidden" style="height: 410px">
                        <div class="nav-item dropdown">
                            <a href="#" class="nav-link" data-toggle="dropdown">Subcategoría <i class="fa fa-angle-down float-right mt-1"></i></a>
                            <div class="dropdown-menu position-absolute bg-secondary border-0 rounded-0 w-100 m-0">
                                @foreach ($subcategorias as $subcategoria)
                                <form action="{{ route('filtro') }}" method="POST" id="form-{{ $subcategoria->codigo_prsu }}">
                                    @csrf
                                    <a href="#" class="dropdown-item" onclick="document.getElementById('form-{{ $subcategoria->codigo_prsu }}').submit(); return false;">
                                    {{ $subcategoria->nombre_prsu }}</a>
                                    <input type="hidden" name="subcategoria[]" value="{{ $subcategoria->codigo_prsu }}">
                                </form>
                                @endforeach
                            </div>
                        </div>
                        @foreach ($categorias as $categoria)
                        <form action="{{ route('filtro') }}" method="POST" id="form-{{ $categoria->codigo_prca }}">
                            @csrf
                            <a href="#" class="nav-item nav-link" onclick="document.getElementById('form-{{ $categoria->codigo_prca }}').submit(); return false;">
                            {{ $categoria->nombre_prca }}</a>
                            <input type="hidden" name="categoria[]" value="{{ $categoria->codigo_prca }}">
                        </form>
                        @endforeach
                    </div>
                </nav>
            </div>
            <div class="col-lg-9">
                <nav class="navbar navbar-expand-lg bg-light navbar-light py-3 py-lg-0 px-0">
                    <a href="" class="text-decoration-none d-block d-lg-none">
                        <h1 class="m-0 display-5 font-weight-semi-bold"><img alt="logo" class="logo_empresa" width="50"><span class="nombre_empresa"></span></h1>
                    </a>
                    <button type="button" class="navbar-toggler" data-toggle="collapse" data-target="#navbarCollapse">
                        <span class="navbar-toggler-icon"></span>
                    </button>
                    <div class="collapse navbar-collapse justify-content-between" id="navbarCollapse">
                        <div class="navbar-nav mr-auto py-0">
                            <a href="{{ route('index')}}" class="nav-item nav-link active">Inicio</a>
                            <a href="{{ route('catalogo')}}" class="nav-item nav-link">Tienda</a>
                            <a href="{{ route('carrito')}}" class="nav-item nav-link">Carrito</a>
                            <a href="{{ route('eventos')}}" class="nav-item nav-link">Eventos</a>
                            <a href="https://elblogdelauto.com" class="nav-item nav-link">Nosotros</a>
                            <a href="{{ route('contacto')}}" class="nav-item nav-link">Contacto</a>
                        </div>
                        <div class="navbar-nav ml-auto py-0">
                            @if(Auth::check())
                            <a href="{{ route('home')}}" class="nav-item nav-link">Panel de control</a>
                            @else
                            <a href="{{ route('login')}}" class="nav-item nav-link">Acceso</a>
                            <a href="{{ route('register')}}" class="nav-item nav-link">Registro</a>
                            @endif
                        </div>
                    </div>
                </nav>
            </div>
        </div>
    </div>
    <!--HEADER INICIO -->
    <div class="container-fluid">
        <div class="d-flex flex-column align-items-center justify-content-center" style="min-height: 50px">
            <h1 class="font-weight-semi-bold text-uppercase">Eventos</h1>
            <div class="d-inline-flex">
                <p class="m-0"><a href="{{ route('index')}}" class="color-principal-color">Inicio</a></p>
                <p class="m-0 px-2">-</p>
                <p class="m-0">Eventos</p>
            </div>
        </div>
    </div>
    <!--HEADER FIN -->
    <!-- CONTENIDO INICIO-->
    <div id="header-carousel" class="carousel slide" data-ride="carousel">
        <div class="carousel-inner">
            @foreach ($eventos as $index => $banner)
            <div class="carousel-item {{ $index == 0 ? 'active' : '' }}" style="width: 100%; height: 100%;">
                <img class="img-fluid" src="{!! asset('assets/img/eventos/' . $banner->banner_even ) !!}" alt="Image" style="width: 100%; height: 100%;">
                <div class="carousel-caption d-flex flex-column align-items-center justify-content-center">
                    <div class="p-3" style="max-width: 100%;">
                        <h4 class="text-light text-uppercase font-weight-medium mb-3">{{ $banner->nombre_even }}</h4>
                        <a href="{{ route('eventosDatos', $banner->codigo_even )}}" class="btn btn-light py-2 px-3">Ver más</a>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
        <a class="carousel-control-prev" href="#header-carousel" data-slide="prev">
            <div class="btn btn-dark" style="width: 45px; height: 45px;">
                <span class="carousel-control-prev-icon mb-n2"></span>
            </div>
        </a>
        <a class="carousel-control-next" href="#header-carousel" data-slide="next">
            <div class="btn btn-dark" style="width: 45px; height: 45px;">
                <span class="carousel-control-next-icon mb-n2"></span>
            </div>
        </a>
    </div>
    <!-- CONTENIDO FIN -->
@endsection
