@extends('tienda/layout')
@section('contenido')
<style>
    .color-circle {
        display: inline-block;
        width: 30px;
        height: 30px;
        border-radius: 50%;
        border: 5px solid #ccc;
        cursor: pointer;
        transition: border-color 0.3s; /* Transición suave para el cambio de color del borde */
    }
    /* Estilo para el borde dorado cuando el radio button está seleccionado */
    .custom-control-input:checked ~ .color-circle {
        border-color: gold;
    }
</style>
<!-- Navbar Start -->
    <div class="container-fluid">
        <div class="row border-top px-xl-5">
            <div class="col-lg-3 d-none d-lg-block">
                <a class="btn shadow-none d-flex align-items-center justify-content-between color-principal text-white w-100" data-toggle="collapse" href="#navbar-vertical" style="height: 65px; margin-top: -1px; padding: 0 30px;  background-color: #ffffff;" >
                    <h6 class="m-0">Categorías</h6>
                    <i class="fa fa-angle-down text-dark"></i>
                </a>
                <nav class="collapse position-absolute navbar navbar-vertical navbar-light align-items-start p-0 border border-top-0 border-bottom-0 bg-light" id="navbar-vertical" style="width: calc(100% - 30px); z-index: 1;">
                    <div class="navbar-nav w-100 overflow-hidden" style="height: 410px">
                        <div class="nav-item dropdown">
                            <a href="#" class="nav-link" data-toggle="dropdown">Subcategoría <i class="fa fa-angle-down float-right mt-1"></i></a>
                            <div class="dropdown-menu position-absolute bg-secondary border-0 rounded-0 w-100 m-0">
                                @foreach ($subcategorias as $subcategoria)
                                <form action="{{ route('filtro') }}" method="POST" id="form-{{ $subcategoria->codigo_prsu }}">
                                    @csrf
                                    <a href="#" class="dropdown-item" onclick="document.getElementById('form-{{ $subcategoria->codigo_prsu }}').submit(); return false;">
                                    {{ $subcategoria->nombre_prsu }}</a>
                                    <input type="hidden" name="subcategoria[]" value="{{ $subcategoria->codigo_prsu }}">
                                </form>
                                @endforeach
                            </div>
                        </div>
                        @foreach ($categorias as $categoria)
                        <form action="{{ route('filtro') }}" method="POST" id="form-{{ $categoria->codigo_prca }}">
                            @csrf
                            <a href="#" class="nav-item nav-link" onclick="document.getElementById('form-{{ $categoria->codigo_prca }}').submit(); return false;">
                            {{ $categoria->nombre_prca }}</a>
                            <input type="hidden" name="categoria[]" value="{{ $categoria->codigo_prca }}">
                        </form>
                        @endforeach
                    </div>
                </nav>
            </div>
            <div class="col-lg-9">
                <nav class="navbar navbar-expand-lg bg-light navbar-light py-3 py-lg-0 px-0">
                    <a href="" class="text-decoration-none d-block d-lg-none">
                        <h1 class="m-0 display-5 font-weight-semi-bold"><img alt="logo" class="logo_empresa" width="50"><span class="nombre_empresa"></span></h1>
                    </a>
                    <button type="button" class="navbar-toggler" data-toggle="collapse" data-target="#navbarCollapse">
                        <span class="navbar-toggler-icon"></span>
                    </button>
                    <div class="collapse navbar-collapse justify-content-between" id="navbarCollapse">
                        <div class="navbar-nav mr-auto py-0">
                            <a href="{{ route('index')}}" class="nav-item nav-link active">Inicio</a>
                            <a href="{{ route('catalogo')}}" class="nav-item nav-link">Tienda</a>
                            <a href="{{ route('carrito')}}" class="nav-item nav-link">Carrito</a>
                            <a href="{{ route('eventos')}}" class="nav-item nav-link">Eventos</a>
                            <a href="https://elblogdelauto.com" class="nav-item nav-link">Nosotros</a>
                            <a href="{{ route('contacto')}}" class="nav-item nav-link">Contacto</a>
                        </div>
                        <div class="navbar-nav ml-auto py-0">
                            @if(Auth::check())
                            <a href="{{ route('home')}}" class="nav-item nav-link">Panel de control</a>
                            @else
                            <a href="{{ route('login')}}" class="nav-item nav-link">Acceso</a>
                            <a href="{{ route('register')}}" class="nav-item nav-link">Registro</a>
                            @endif
                        </div>
                    </div>
                </nav>
            </div>
        </div>
    </div>
    <!--HEADER INICIO -->
    <div class="container-fluid">
        <div class="d-flex flex-column align-items-center justify-content-center" style="min-height: 50px">
            <h1 class="font-weight-semi-bold text-uppercase">{{ $evento->nombre_even }}</h1>
            <div class="d-inline-flex">
                <p class="m-0"><a href="{{ route('index')}}" class="color-principal-color">Inicio</a></p>
                <p class="m-0 px-2">-</p>
                <p class="m-0">Eventos</p>
            </div>
        </div>
    </div>
    <!--HEADER FIN -->
    <!-- CONTENIDO INICIO-->
    <div class="row px-xl-5">
        <div class="col-lg-4 mb-5 col-12">
            <div class="card product-item border-0">
                <div class="card-header product-img position-relative overflow-hidden bg-transparent border p-0 text-center">
                    @if ($evento->imagen_even)
                        <img class="img-fluid "  src="{{ asset('assets/img/eventos/' . $evento->imagen_even) }}" alt="evento" width="350">
                    @else
                        <img class="img-fluid w-100"  src="{!! asset('assets/img/eventos/eventos.png') !!}" alt="evento" width="150">
                    @endif
                </div>
                <div class="card-body border-left border-right text-center p-0 pt-4 pb-3">
                    <h6 class="text-truncate">{{ $evento->nombre_even }}</h6>
                    <div class="d-flex justify-content-center">
                        <h6> {{ $evento->venta_prod }}</h6>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-8 mb-5 col-12">
            <div class="card-footer justify-content-between bg-light border text-center">
                <i class="fas fa-eye color-principal-color mr-1"></i>Detalles de evento
            </div>
            <div class="control-group">
                {!! $evento->decripcion_even !!}
            </div>
        </div>
    </div>
    <div class="text-center mb-4">
        <h2 class="section-title px-5"><span>Compra de boletos</span></h2>
    </div>
    <div class="container-fluid">
        <div class="row px-xl-5">
            @foreach ($boletos as $boleto)
                @if (($boleto->stock_enbo == 1 && $boleto->nro_boletos_enbo >= 1) || $boleto->stock_enbo == null)
                <div class="col-md-4 col-12">
                    <div class="card product-item border-0 mb-4">
                        <div class="card-header product-img position-relative overflow-hidden p-0 text-center bg-primary text-white">
                            {{ $boleto->nombre_enbo }}
                        </div>
                        <div class="card-body border-left border-right text-center p-0 pt-4 pb-3">
                            <h6 class="text-truncate mb-3"></h6>
                            <div class="d-flex justify-content-center">
                                <h6>{{ "$" . number_format($boleto->precio_enbo, 2) }}</h6>
                            </div>
                        </div>
                        <div class="card-footer d-flex justify-content-between bg-light border text-center">
                            <button type="button" class="btn btn-outline-success mt-2" data-toggle="modal" data-target="#comprar{{ $boleto->codigo_enbo }}">
                                <i class="fas fa-shopping-cart mr-1"></i> Comprar
                            </button>
                        </div>
                    </div>
                </div>
                <!-- Modal de compra -->
                <div class="modal fade" id="comprar{{ $boleto->codigo_enbo }}" tabindex="-1" role="dialog" aria-labelledby="comprarModalLabel" aria-hidden="true">
                    <div class="modal-dialog modal-lg" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="comprarModalLabel">Completar datos del cliente</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body">
                                <h5 class="modal-title">Costo por boleto es de {{ "$" . number_format($boleto->precio_enbo, 2) }}</h5>
                                <form id="formBoleto{{ $boleto->codigo_enbo }}">
                                    @csrf
                                    <div class="form-group">
                                        <input class="form-control input-resaltado" type="hidden" id="codigo{{ $boleto->codigo_enbo }}" name="codigo" value="{{ $boleto->codigo_enbo }}">
                                    </div>
                                    <div class="form-group">
                                        <label class="control-label is-required">Número de boletos</label>
                                        <input class="form-control input-resaltado" type="number" id="cantidad{{ $boleto->codigo_enbo }}" name="cantidad" min="1" value="1" required>
                                    </div>
                                    <div class="form-group">
                                        <label class="control-label is-required">Nombre</label>
                                        <input class="form-control input-resaltado" type="text" id="nombre{{ $boleto->codigo_enbo }}" name="nombre" required>
                                    </div>
                                    <div class="form-group">
                                        <label class="control-label is-required">Correo electrónico</label>
                                        <input class="form-control input-resaltado" type="email" id="email{{ $boleto->codigo_enbo }}" name="email" required>
                                    </div>
                                    <div class="form-group">
                                        <label class="control-label is-required">Teléfono del cliente</label>
                                        <input class="form-control input-resaltado" type="text" id="telefono{{ $boleto->codigo_enbo }}" name="telefono" required>
                                    </div>
                                    <div class="form-group">
                                        <input type="checkbox" id="term-cdn{{ $boleto->codigo_enbo }}" class="termcdn" required>
                                        <label for="term-cdn{{ $boleto->codigo_enbo }}" class="gray">Acepto los <a href="{{ route('terminos.condiciones')}}" style="color: #00B79A">Términos y Condiciones</a></label>
                                    </div>
                                </form>
                                <div class="modal-footer">
                                    <button type="button" id="checkout-btn-mercadoPago{{ $boleto->codigo_enbo }}" class="btn btn-success checkout-btn-mp">
                                        <i class="fas fa-shopping-cart mr-1"></i> Procesar Pago
                                    </button>
                                    <div id="wallet_container{{ $boleto->codigo_enbo }}"></div>
                                    <button type="button" class="btn btn-danger" data-dismiss="modal">
                                        <i class="fas fa-times-circle mr-1"></i> Cerrar
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                @endif
            @endforeach
        </div>
    </div>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    {{--Agregar este script al final de su vista--}}
    <script src="https://sdk.mercadopago.com/js/v2"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        // Token CSRF para Laravel
        const token = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
        const rootUrl = "{{ url('/') }}";
        // Inicializar el SDK de MercadoPago
        const mp = new MercadoPago("{{ env('MERCADOPAGO_PUBLIC_KEY') }}");
        console.log(mp);
        // Crear un botón de pago para cada modal de boleto
        @foreach ($boletos as $boleto)
            @if (($boleto->stock_enbo == 1 && $boleto->nro_boletos_enbo >= 1) || $boleto->stock_enbo == null)
                document.getElementById('checkout-btn-mercadoPago{{ $boleto->codigo_enbo }}').addEventListener('click', function() {
                    procesarPago('{{ $boleto->codigo_enbo }}');
                });
            @endif
        @endforeach
        // Función para procesar el pago
        function procesarPago(codigoBoleto) {
            // Obtener valores del formulario
            const nombre = document.getElementById('nombre' + codigoBoleto).value;
            const email = document.getElementById('email' + codigoBoleto).value;
            const telefono = document.getElementById('telefono' + codigoBoleto).value;
            const codigo = document.getElementById('codigo' + codigoBoleto).value;
            const cantidad = document.getElementById('cantidad' + codigoBoleto).value;
            const termAccepted = document.getElementById('term-cdn' + codigoBoleto).checked;
            // Validar datos
            if (!termAccepted) {
                Swal.fire({
                    icon: "error",
                    title: "Oops...",
                    text: "¡Favor de aceptar los términos y condiciones!",
                });
                return;
            }
            if(!nombre) {
                Swal.fire({
                    icon: "error",
                    title: "Oops...",
                    text: "¡Nombre no encontrado!",
                });
                return;
            }
            if(!email) {
                Swal.fire({
                    icon: "error",
                    title: "Oops...",
                    text: "¡Correo electrónico no encontrado!",
                });
                return;
            }
            if(!telefono) {
                Swal.fire({
                    icon: "error",
                    title: "Oops...",
                    text: "¡Teléfono no encontrado!",
                });
                return;
            }
            // Deshabilitar botón para evitar múltiples clicks
            document.getElementById('checkout-btn-mercadoPago' + codigoBoleto).setAttribute("disabled", true);
            // Preparar datos para enviar al servidor
            const data = {
                nombre: nombre,
                email: email,
                telefono: telefono,
                codigo: codigo,
                cantidad: parseInt(cantidad)
            };
            // Enviar datos al servidor
            fetch(rootUrl + "/procesar/compra/mercadoPago/boletos", {
                method: "POST",
                headers: {
                    "Content-Type": "application/json",
                    "X-CSRF-TOKEN": token
                },
                body: JSON.stringify(data)
            })
            .then(function(response) {
                return response.json();
            })
            .then(function(preference) {
                if (preference.id) {
                    // Crear botón de pago
                    ejecutarMercadoPago(preference.id, codigoBoleto);
                } else if (preference.status === 'error') {
                    // Mostrar mensaje de error
                    Swal.fire({
                        icon: "error",
                        title: "Error",
                        text: preference.message || "Error al procesar el pago",
                    });
                    // Rehabilitar botón
                    document.getElementById('checkout-btn-mercadoPago' + codigoBoleto).removeAttribute("disabled");
                }
            })
            .catch(function(error) {
                console.error("Error:", error);
                Swal.fire({
                    icon: "error",
                    title: "Error",
                    text: "Ocurrió un error al procesar su solicitud",
                });
                // Rehabilitar botón
                document.getElementById('checkout-btn-mercadoPago' + codigoBoleto).removeAttribute("disabled");
            });
        }
        // Función para ejecutar el botón de MercadoPago
        function ejecutarMercadoPago(preferenceId, codigoBoleto) {
            // Limpiar contenedor previo
            const container = document.getElementById('wallet_container' + codigoBoleto);
            container.innerHTML = '';
            // Crear botón de Mercado Pago
            const bricksBuilder = mp.bricks();
            // Renderizar botón de pago
            bricksBuilder.create("wallet", "wallet_container" + codigoBoleto, {
                initialization: {
                    preferenceId: preferenceId,
                    redirectMode: "modal"
                },
                callbacks: {
                    onError: (error) => {
                        console.error("Error de MercadoPago:", error);
                        Swal.fire({
                            icon: "error",
                            title: "Error",
                            text: "Error al conectar con MercadoPago",
                        });
                    }
                }
            });
            // Mostrar la confirmación
            Swal.fire({
                icon: "success",
                title: "Datos validados",
                text: "Por favor, haga clic en el botón de MercadoPago para continuar con el pago",
            });
        }
    </script>
    <!-- CONTENIDO FIN -->
@endsection
