@extends('tienda/layout')
@section('contenido')
<style>
    .color-circle {
        display: inline-block;
        width: 30px;
        height: 30px;
        border-radius: 50%;
        border: 5px solid #ccc;
        cursor: pointer;
        transition: border-color 0.3s; /* Transición suave para el cambio de color del borde */
    }
    /* Estilo para el borde dorado cuando el radio button está seleccionado */
    .custom-control-input:checked ~ .color-circle {
        border-color: gold;
    }
</style>
<!-- Navbar Start -->
    <div class="container-fluid">
        <div class="row border-top px-xl-5">
            <div class="col-lg-3 d-none d-lg-block">
                <a class="btn shadow-none d-flex align-items-center justify-content-between color-principal text-white w-100" data-toggle="collapse" href="#navbar-vertical" style="height: 65px; margin-top: -1px; padding: 0 30px;  background-color: #ffffff;" >
                    <h6 class="m-0">Categorías</h6>
                    <i class="fa fa-angle-down text-dark"></i>
                </a>
                <nav class="collapse position-absolute navbar navbar-vertical navbar-light align-items-start p-0 border border-top-0 border-bottom-0 bg-light" id="navbar-vertical" style="width: calc(100% - 30px); z-index: 1;">
                    <div class="navbar-nav w-100 overflow-hidden" style="height: 410px">
                        <div class="nav-item dropdown">
                            <a href="#" class="nav-link" data-toggle="dropdown">Subcategoría <i class="fa fa-angle-down float-right mt-1"></i></a>
                            <div class="dropdown-menu position-absolute bg-secondary border-0 rounded-0 w-100 m-0">
                                @foreach ($subcategorias as $subcategoria)
                                <form action="{{ route('filtro') }}" method="POST" id="form-{{ $subcategoria->codigo_prsu }}">
                                    @csrf
                                    <a href="#" class="dropdown-item" onclick="document.getElementById('form-{{ $subcategoria->codigo_prsu }}').submit(); return false;">
                                    {{ $subcategoria->nombre_prsu }}</a>
                                    <input type="hidden" name="subcategoria[]" value="{{ $subcategoria->codigo_prsu }}">
                                </form>
                                @endforeach
                            </div>
                        </div>
                        @foreach ($categorias as $categoria)
                        <form action="{{ route('filtro') }}" method="POST" id="form-{{ $categoria->codigo_prca }}">
                            @csrf
                            <a href="#" class="nav-item nav-link" onclick="document.getElementById('form-{{ $categoria->codigo_prca }}').submit(); return false;">
                            {{ $categoria->nombre_prca }}</a>
                            <input type="hidden" name="categoria[]" value="{{ $categoria->codigo_prca }}">
                        </form>
                        @endforeach
                    </div>
                </nav>
            </div>
            <div class="col-lg-9">
                <nav class="navbar navbar-expand-lg bg-light navbar-light py-3 py-lg-0 px-0">
                    <a href="" class="text-decoration-none d-block d-lg-none">
                        <h1 class="m-0 display-5 font-weight-semi-bold"><img alt="logo" class="logo_empresa" width="50"><span class="nombre_empresa"></span></h1>
                    </a>
                    <button type="button" class="navbar-toggler" data-toggle="collapse" data-target="#navbarCollapse">
                        <span class="navbar-toggler-icon"></span>
                    </button>
                    <div class="collapse navbar-collapse justify-content-between" id="navbarCollapse">
                        <div class="navbar-nav mr-auto py-0">
                            <a href="{{ route('index')}}" class="nav-item nav-link active">Inicio</a>
                            <a href="{{ route('catalogo')}}" class="nav-item nav-link">Tienda</a>
                            <a href="{{ route('carrito')}}" class="nav-item nav-link">Carrito</a>
                            <a href="{{ route('eventos')}}" class="nav-item nav-link">Eventos</a>
                            <a href="https://elblogdelauto.com" class="nav-item nav-link">Nosotros</a>
                            <a href="{{ route('contacto')}}" class="nav-item nav-link">Contacto</a>
                        </div>
                        <div class="navbar-nav ml-auto py-0">
                            @if(Auth::check())
                            <a href="{{ route('home')}}" class="nav-item nav-link">Panel de control</a>
                            @else
                            <a href="{{ route('login')}}" class="nav-item nav-link">Acceso</a>
                            <a href="{{ route('register')}}" class="nav-item nav-link">Registro</a>
                            @endif
                        </div>
                    </div>
                </nav>
            </div>
        </div>
    </div>
    <!--HEADER INICIO -->
    <div class="container-fluid">
        <div class="d-flex flex-column align-items-center justify-content-center" style="min-height: 50px">
            <h1 class="font-weight-semi-bold text-uppercase">Favoritos</h1>
            <div class="d-inline-flex">
                <p class="m-0"><a href="{{ route('index')}}" class="color-principal-color">Inicio</a></p>
                <p class="m-0 px-2">-</p>
                <p class="m-0">Catálogo</p>
            </div>
        </div>
    </div>
    <!--HEADER FIN -->
    <!-- CONTENIDO INICIO-->
    <div class="container-fluid pt-5">
        <div class="row px-xl-5">
            <div class="col-lg-12 table-responsive mb-5">
                <table class="table table-bordered text-center mb-0">
                    <thead class="bg-secondary text-dark">
                        <tr>
                            <th></th>
                            <th>SKU</th>
                            <th>Nombre</th>
                            <th>Categoría</th>
                            <th>Subcategoría</th>
                            <th>Accion</th>
                        </tr>
                    </thead>
                    <tbody class="align-middle">
                        @if ($totalFavoritos >= 1)
                        @foreach ($favoritos  as $item)
                        <tr>
                            <td class="align-middle"><a href="{{ route('detalle.producto', $item['product']) }}"><img src="{{ asset('assets/img/productos/' .   $item['imagen']) }}" alt="" style="width: 50px;"></a></td>
                            <td class="align-middle">{{ $item['sku'] }}</td>
                            <td class="align-middle">{{ $item['nombre'] }}</td>
                            <td class="align-middle">{{ $item['categoria'] }}</td>
                            <td class="align-middle">{{ $item['subcategoria'] }}</td>

                            <td class="align-middle">
                                <a href="{{ route('eliminar.favoritos', $item['token']) }}" class="btn btn-sm color-principal" style="color: #ffffff"><i class="fa fa-times"></i></a>
                                <a href="{{ route('detalle.producto', $item['product']) }}" class="btn btn-sm color-principal" style="color: #ffffff"><i class="fas fa-eye"></i></a>
                            </td>
                        </tr>
                        @endforeach
                        @endif
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <!-- CONTENIDO FIN -->
@endsection
