@php
$VerEditor = auth()->user()->can('Usuarios - Visor') || auth()->user()->can('Usuarios - Editor')
@endphp
@if($VerEditor)
@extends('layouts/app')
@section('tituloModulo', 'USUARIOS')
@section('contenido')
<div class="card">
    <div class="card-body">
        @can('Usuarios - Editor')
        <button type="button" class="btn btn-success mt-3" data-bs-toggle="modal" data-bs-target="#crear">
            <i class="bx bxs-folder-plus"></i> Agregar usuario
        </button>
        <div class="modal fade" id="crear" tabindex="-1">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Agregar usuario</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form action="{{ route('usuarios.store') }}" method="POST">
                        @csrf
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6 col-12">
                                <label class="control-label is-required">Nombre</label>
                                <input class="form-control" type="text" name="name" required>
                            </div>
                            <div class="col-md-6 col-12">
                                <label class="control-label is-required">Email</label>
                                <input class="form-control" type="email" name="email" required>
                            </div>
                            <div class="col-md-6 col-12">
                                <label  for="password" class="control-label is-required">Contraseña</label>
                                <input id="password"  class="form-control" type="password" name="password"  required>
                            </div>
                            <div class="col-md-6 col-12">
                                <label for="password-confirm" class="control-label is-required">Confirmar contraseña</label>
                                <input id="password-confirm" type="password" class="form-control" name="password_confirmation" required autocomplete="new-password">
                            </div>
                            <div class="col-md-6 col-12">
                                <label class="control-label is-required">Roles</label>
                                <select class="form-select" name="role" id="role">
                                    @foreach ($roles as $role)
                                        <option value="{{ $role->name }}">{{ $role->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success"><i class="bx bx-save"></i> Guardar</button>
                        <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="bx  bxs-x-circle"></i> Cerrar</button>
                    </div>
                    </form>
                </div>
            </div>
        </div>
        @endcan
        <div class="datatable-wrapper datatable-loading no-footer sortable searchable fixed-columns">
            <div class="datatable-container">
                <table class="table datatable datatable-table">
                    <thead>
                        <tr class="text">
                            <th data-sortable="true" scope="col">NOMBRE</th>
                            <th data-sortable="true" scope="col">EMAIL</th>
                            <th data-sortable="true" scope="col">ROL</th>
                            <th data-sortable="true" scope="col">ESTATUS</th>
                            @can('Usuarios - Editor')
                            <th data-sortable="true" scope="col">ACCIÓN</th>
                            @endcan
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($datos as $item)
                        <tr>
                            <td data-title="NOMBRE">{{ $item->name }}</td>
                            <td data-title="EMAIL">{{ $item->email }}</td>

                            <td data-title="ROL">
                                @foreach ($item->roles as $role)
                                    {{ $role->name }}
                                    @if (!$loop->last)
                                        ,
                                    @endif
                                @endforeach
                            </td>
                            <td data-title="ESTATUS">
                                @if($item->status == 'Activo')
                                    <span class="badge bg-success">{{$item->status}}</span>
                                @endif
                                @if ($item->status== 'Inactivo')
                                    <span class="badge bg-danger">{{$item->status}}</span>
                                @endif
                            </td>
                            @can('Usuarios - Editor')
                            <td data-title="ACCIÓN">
                                <div class="btn-group">
                                    <button type="button" class="btn btn-outline-primary dropdown-toggle btnTabla"
                                        data-bs-toggle="dropdown" aria-expanded="false">Acción <i
                                            class="mdi mdi-chevron-down"></i></button>
                                    <div class="dropdown-menu">
                                        <button type="button" class="btn btn-outline-success mt-2 dropdown-item" data-bs-toggle="modal" data-bs-target="#editar{{  $item->id }}">
                                            <i class="bx bxs-edit"></i> Editar
                                        </button>
                                        <form action="{{ route('usuarios.activate', $item->id) }}" method="POST" enctype="multipart/form-data" class="form-activar">
                                            @csrf
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx bx-check-circle"></i> Activar
                                            </button>
                                        </form>
                                        <form action="{{ route('usuarios.inactivate', $item->id) }}" method="POST" enctype="multipart/form-data" class="form-inactivar">
                                            @csrf
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx bx-x-circle"></i> Inactivar
                                            </button>
                                        </form>
                                        <form action="{{ route('usuarios.delete', $item->id) }}" method="POST" enctype="multipart/form-data" class="form-delete">
                                            @csrf
                                            <button class="dropdown-item"   type="submit" id="btn" >
                                                <i class="bx  bxs-trash"></i> Eliminar
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </td>
                            @endcan
                        </tr>
                        @can('Usuarios - Editor')
                        <div class="modal fade" id="editar{{  $item->id }}" tabindex="-1">
                            <div class="modal-dialog modal-lg">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title">Editar usuario</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <form action="{{ route('usuarios.update',  $item->id) }}" method="POST">
                                        @csrf
                                    <div class="modal-body">
                                        <div class="row">
                                            <div class="col-md-6 col-12">
                                                <label class="control-label is-required">Nombre</label>
                                                <input class="form-control" value="{{ $item->name }}" type="text" name="name" required>
                                            </div>
                                            <div class="col-md-6 col-12">
                                                <label class="control-label is-required">Email</label>
                                                <input class="form-control" value="{{ $item->email }}" type="email" name="email" required>
                                            </div>
                                            <div class="col-md-6 col-12">
                                                <label  for="password" class="control-label is-required">Contraseña</label>
                                                <input id="password"  class="form-control" type="password" name="password">
                                            </div>
                                            <div class="col-md-6 col-12">
                                                <label for="password-confirm" class="control-label is-required">Confirmar contraseña</label>
                                                <input id="password-confirm" type="password" class="form-control" name="password_confirmation">
                                            </div>
                                            <div class="col-md-6 col-12">
                                                <label class="control-label is-required">Roles</label>
                                                <select class="form-select" name="role" id="role">
                                                    @foreach ($item->roles as $role)
                                                    <option value="{{ $role->name }}">{{ $role->name }}</option>
                                                        @if (!$loop->last)
                                                            ,
                                                        @endif
                                                    @endforeach
                                                    @foreach ($roles as $role)
                                                        <option value="{{ $role->name }}">{{ $role->name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="submit" class="btn btn-success"><i class="bx bx-save"></i> Actualizar</button>
                                        <button type="button" class="btn btn-danger" data-bs-dismiss="modal"><i class="bx  bxs-x-circle"></i> Cerrar</button>
                                    </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        @endcan
                        @endforeach
                    </tbody>
                </table>
            </div>
            <div class="datatable-bottom">
                <nav class="datatable-pagination">
                    <ul class="datatable-pagination-list"></ul>
                </nav>
            </div>
        </div>
    </div>
</div>
@endsection
@endif

