@php
$VerEditor = auth()->user()->can('Ventas - Visor') || auth()->user()->can('Ventas - Editor')
@endphp
@if($VerEditor)
@extends('layouts/app')
@section('tituloModulo', 'VENTAS')
@section('contenido')
@if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif
@if($mensaje = Session::get('success'))
    <div class="alert alert-success" role="alert">{{ $mensaje }}</div>
@endif
@if($mensaje = Session::get('danger'))
    <div class="alert alert-danger" role="alert">{{ $mensaje }}</div>
@endif
<div class="card">
    <div class="card-body">
        <div class="datatable-wrapper datatable-loading no-footer sortable searchable fixed-columns">
            <div class="datatable-container">
                <table class="table datatable datatable-table">
                    <thead>
                        <tr class="text">
                            <th data-sortable="true" scope="col">{{ "NO. COMPRA" }}</th>
                            <th data-sortable="true" scope="col">ID PROVEEDOR PAGO</th>
                            <th data-sortable="true" scope="col">NOMBRE</th>
                            <th data-sortable="true" scope="col">TELÉFONO</th>
                            <th data-sortable="true" scope="col">CORREO ELECTRÓNICO</th>
                            <th data-sortable="true" scope="col">SUBTOTAL</th>
                            <th data-sortable="true" scope="col">DESCUENTO</th>
                            <th data-sortable="true" scope="col">TOTAL</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($datos as $item)
                        <tr>
                            <td data-title="{{ "NO. COMPRA" }}">{{ $item->numero_pago }}</td>
                            <td data-title="ID PROVEEDOR PAGO">{{ $item->payment_id_paco }}</td>
                            <td data-title="NOMBRE">{{ $item->nombre_comp }}</td>
                            <td data-title="TELÉFONO">{{ $item->telefono_comp }}</td>
                            <td data-title="CORREO ELECTRÓNICO">{{ $item->email_comp }}</td>
                            <td data-title="SUBTOTAL">{{ "$" . number_format($item->sub_total_comp, 2) }}</td>
                            <td data-title="DESCUENTO">{{ "$" . number_format($item->descuento_comp, 2) }}</td>
                            <td data-title="TOTAL">{{ "$" . number_format($item->total_comp, 2) }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <div class="datatable-bottom">
                <nav class="datatable-pagination">
                    <ul class="datatable-pagination-list"></ul>
                </nav>
            </div>
        </div>
    </div>
</div>
@endsection
@endif
