<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\RolesController;
use App\Http\Controllers\UsersController;
use App\Http\Controllers\TiendaController;
use App\Http\Controllers\ComprasController;
use App\Http\Controllers\CuponesController;
use App\Http\Controllers\ClientesController;
use App\Http\Controllers\ProductosController;
use App\Http\Controllers\SuscritosController;
use App\Http\Controllers\PermissionController;
use App\Http\Controllers\DireccionesController;
use App\Http\Controllers\DatosEmpresasController;
use App\Http\Controllers\CalificacionesController;
use App\Http\Controllers\EventosController;
use App\Http\Controllers\ProductosMarcasController;
use App\Http\Controllers\ProductosCategoriasController;
use App\Http\Controllers\ProductosSubcategoriasController;
use App\Models\Eventos_boletos;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/
Route::get('/', [TiendaController::class, 'index'])->name('index');
Route::get('/detalle/producto/{id}', [TiendaController::class, 'detalleProducto'])->name('detalle.producto');
Route::get('/carrito', [TiendaController::class, 'carrito'])->name('carrito');
Route::post('/carrito/agregar/{id}', [TiendaController::class, 'agregarCarrito'])->name('agregar.carrito');
Route::get('/carrito/eliminar/{id}', [TiendaController::class, 'eliminarCarrito'])->name('eliminar.carrito');
Route::get('/carrito/actualizar/{id}/{number}', [TiendaController::class, 'actualizarCarrito'])->name('actualizar.carrito');
Route::match(['get', 'post'],'/catalogo', [TiendaController::class, 'catalogo'])->name('catalogo');
Route::match(['get', 'post'],'/catalogo/filtro', [TiendaController::class, 'filtro'])->name('filtro');
Route::post('/cupon', [TiendaController::class, 'cupon'])->name('cupon');
Route::get('/procesar/compra', [TiendaController::class, 'procesar'])->name('procesar.compra');
Route::post('/procesar/compra/mercadoPago', [TiendaController::class, 'pagarMercadoPago']);
Route::get('/mercadopago/pago/{estatus}/{id}', [TiendaController::class, 'estatusMercadoPago']);
Route::post('/procesar/compra/paypal', [TiendaController::class, 'pagarPaypal']);
Route::get('/paypal/pago/{estatus}/{idCompra}/{idpaypal}', [TiendaController::class, 'estatusPaypal']);
Route::get('/favoritos', [TiendaController::class, 'favoritos'])->name('favoritos');
Route::get('/favoritos/agregar/producto/{id}', [TiendaController::class, 'agregarFavoritos'])->name('agregar.favoritos');
Route::get('/favoritos/eliminar/producto/{id}', [TiendaController::class, 'eliminarFavoritos'])->name('eliminar.favoritos');
Route::get('/favoritos/actualizar/producto/{id}/{number}', [TiendaController::class, 'actualizarFavoritos'])->name('actualizar.favoritos');
Route::get('/datos/empresa', [TiendaController::class, 'empresa'])->name('empresa');
Route::post('/suscribir', [TiendaController::class, 'suscribir'])->name('suscribir');
Route::get('/contacto', [TiendaController::class, 'contacto'])->name('contacto');
Route::post('/contacto/envioCorreo', [TiendaController::class, 'contactoEnvioCorreo'])->name('contacto.envio.correo');
Route::get('/terminos-y-condiciones', [TiendaController::class, 'terminosCondiciones'])->name('terminos.condiciones');
Route::get('/politicas-ventas-y-entregas', [TiendaController::class, 'politicasVentasEntregas'])->name('politicas.ventas.entregas');
Route::get('/politicas-cancelaciones-y-devoluciones', [TiendaController::class, 'politicasCancelacionesDevoluciones'])->name('politicas.cancelaciones.devoluciones');
Route::get('/avisos-privacidad', [TiendaController::class, 'avisoPrivacidad'])->name('aviso.privacidad');
Route::get('/api/skydropx/{cp}', [TiendaController::class, 'skydropx'])->name('skydropx');
Route::get('/api/skydropx/addDireccion/{codigo}', [TiendaController::class, 'skydropxAddDireccion'])->name('skydropxAddDireccion');
Route::get('/eventos', [TiendaController::class, 'eventos'])->name('eventos');
Route::get('/eventos/datos/{id}', [TiendaController::class, 'eventosDatos'])->name('eventosDatos');
Route::post('/procesar/compra/mercadoPago/boletos', [TiendaController::class, 'pagarMercadoPagoBoletos']);
Route::get('/mercadopago/pago/boleto/{estatus}/{id}', [TiendaController::class, 'estatusMercadoPagoBoletos']);
Route::post('/webhook/mercadopago/tienda', [TiendaController::class, 'tokenComprastoken']);




// RUTAS DE INTERNAS
Route::middleware(['auth', 'active'])->group(function () {
Route::get('/home', [HomeController::class, 'index'])->name('home')->middleware('auth');

// USUARIOS
Route::get('/usuarios', [UsersController::class, 'index'])->name('usuarios.index')->middleware('auth');
Route::post('/usuarios/store', [UsersController::class, 'store'])->name('usuarios.store')->middleware('auth');
Route::post('/usuarios/update/{id}', [UsersController::class, 'update'])->name('usuarios.update')->middleware('auth');
Route::post('/usuarios/inactivate/{id}', [UsersController::class, 'inactivate'])->name('usuarios.inactivate')->middleware('auth');
Route::post('/usuarios/activate/{id}', [UsersController::class, 'activate'])->name('usuarios.activate')->middleware('auth');
Route::post('/usuarios/delete/{id}', [UsersController::class, 'delete'])->name('usuarios.delete')->middleware('auth');

// DATOS DE LA EMPRESA
Route::get('/datos_empresa/index', [DatosEmpresasController::class, 'index'])->name('datos_empresa.index')->middleware('auth');
Route::put('/datos_empresa/update', [DatosEmpresasController::class, 'update'])->name('datos_empresa.update')->middleware('auth');
Route::post('/datos_empresa/banner/store', [DatosEmpresasController::class, 'storeBanner'])->name('datos_empresa.banner.store')->middleware('auth');
Route::get('/datos_empresa/banner/delete/{id}', [DatosEmpresasController::class, 'deleteBanner'])->name('datos_empresa.banner.delete')->middleware('auth');

// PERMISOS
Route::get('/permissions/index', [PermissionController::class, 'index'])->name('permissions.index')->middleware('auth');
Route::post('/permissions/store', [PermissionController::class, 'store'])->name('permissions.store')->middleware('auth');

// PERMISOS
Route::get('/roles/index', [RolesController::class, 'index'])->name('roles.index')->middleware('auth');
Route::post('/roles/store', [RolesController::class, 'store'])->name('roles.store')->middleware('auth');
Route::put('/roles/update/{role}', [RolesController::class, 'update'])->name('roles.update')->middleware('auth');

// PRODUCTOS
Route::get('/productos', [ProductosController::class, 'index'])->name('productos.index')->middleware('auth');
Route::post('/productos/store', [ProductosController::class, 'store'])->name('productos.store')->middleware('auth');
Route::post('/productos/store/imagen/{id}', [ProductosController::class, 'storeImagen'])->name('productos.store.imagen')->middleware('auth');
Route::post('/productos/store/color/{id}', [ProductosController::class, 'storeColor'])->name('productos.store.color')->middleware('auth');
Route::get('/productos/dats/{id}', [ProductosController::class, 'dats'])->name('productos.dats')->middleware('auth');
Route::post('/productos/update/{id}', [ProductosController::class, 'update'])->name('productos.update')->middleware('auth');
Route::post('/productos/inactivate/{id}', [ProductosController::class, 'inactivate'])->name('productos.inactivate')->middleware('auth');
Route::post('/productos/activate/{id}', [ProductosController::class, 'activate'])->name('productos.activate')->middleware('auth');
Route::post('/productos/delete/{id}', [ProductosController::class, 'delete'])->name('productos.delete')->middleware('auth');
Route::post('/productos/delete/imagen/{id}', [ProductosController::class, 'deleteImagen'])->name('productos.delete.imagen')->middleware('auth');
Route::post('/productos/delete/color/{id}', [ProductosController::class, 'deleteColor'])->name('productos.delete.color')->middleware('auth');
Route::get('/productos/descargar/bgs', [ProductosController::class, 'descargarBGS'])->name('productos.descargar.bgs')->middleware('auth');

// MARCAS
Route::get('/marcas', [ProductosMarcasController::class, 'index'])->name('marcas.index')->middleware('auth');
Route::post('/marcas/store', [ProductosMarcasController::class, 'store'])->name('marcas.store')->middleware('auth');
Route::post('/marcas/update/{id}', [ProductosMarcasController::class, 'update'])->name('marcas.update')->middleware('auth');
Route::post('/marcas/inactivate/{id}', [ProductosMarcasController::class, 'inactivate'])->name('marcas.inactivate')->middleware('auth');
Route::post('/marcas/activate/{id}', [ProductosMarcasController::class, 'activate'])->name('marcas.activate')->middleware('auth');
Route::post('/marcas/delete/{id}', [ProductosMarcasController::class, 'delete'])->name('marcas.delete')->middleware('auth');

// CATEGORIAS
Route::get('/categorias', [ProductosCategoriasController::class, 'index'])->name('categorias.index')->middleware('auth');
Route::post('/categorias/store', [ProductosCategoriasController::class, 'store'])->name('categorias.store')->middleware('auth');
Route::post('/categorias/update/{id}', [ProductosCategoriasController::class, 'update'])->name('categorias.update')->middleware('auth');
Route::post('/categorias/inactivate/{id}', [ProductosCategoriasController::class, 'inactivate'])->name('categorias.inactivate')->middleware('auth');
Route::post('/categorias/activate/{id}', [ProductosCategoriasController::class, 'activate'])->name('categorias.activate')->middleware('auth');
Route::post('/categorias/delete/{id}', [ProductosCategoriasController::class, 'delete'])->name('categorias.delete')->middleware('auth');

// SUBCATEGORIAS
Route::get('/subcategoria', [ProductosSubcategoriasController::class, 'index'])->name('subcategorias.index')->middleware('auth');
Route::post('/subcategoria/store', [ProductosSubcategoriasController::class, 'store'])->name('subcategorias.store')->middleware('auth');
Route::post('/subcategoria/update/{id}', [ProductosSubcategoriasController::class, 'update'])->name('subcategorias.update')->middleware('auth');
Route::post('/subcategoria/inactivate/{id}', [ProductosSubcategoriasController::class, 'inactivate'])->name('subcategorias.inactivate')->middleware('auth');
Route::post('/subcategoria/activate/{id}', [ProductosSubcategoriasController::class, 'activate'])->name('subcategorias.activate')->middleware('auth');
Route::post('/subcategoria/delete/{id}', [ProductosSubcategoriasController::class, 'delete'])->name('subcategorias.delete')->middleware('auth');

// CUPONES
Route::get('/cupones', [CuponesController::class, 'index'])->name('cupones.index')->middleware('auth');
Route::post('/cupones/store', [CuponesController::class, 'store'])->name('cupones.store')->middleware('auth');
Route::post('/cupones/update/{id}', [CuponesController::class, 'update'])->name('cupones.update')->middleware('auth');
Route::post('/cupones/inactivate/{id}', [CuponesController::class, 'inactivate'])->name('cupones.inactivate')->middleware('auth');
Route::post('/cupones/activate/{id}', [CuponesController::class, 'activate'])->name('cupones.activate')->middleware('auth');
Route::post('/cupones/delete/{id}', [CuponesController::class, 'delete'])->name('cupones.delete')->middleware('auth');

// CLIENTES
Route::get('/clientes', [ClientesController::class, 'index'])->name('clientes.index')->middleware('auth');
Route::post('/clientes/store', [ClientesController::class, 'store'])->name('clientes.store')->middleware('auth');
Route::put('/clientes/update/{id}', [ClientesController::class, 'update'])->name('clientes.update')->middleware('auth');
Route::post('/clientes/inactivate/{id}', [ClientesController::class, 'inactivate'])->name('clientes.inactivate')->middleware('auth');
Route::post('/clientes/activate/{id}', [ClientesController::class, 'activate'])->name('clientes.activate')->middleware('auth');
Route::post('/clientes/delete/{id}', [ClientesController::class, 'delete'])->name('clientes.delete')->middleware('auth');
Route::get('/clientes/datos/{id}', [ClientesController::class, 'cliente'])->name('clientes.cliente')->middleware('auth');
Route::get('/clientes/descargar/documento/{id}', [ClientesController::class, 'descargarDocumento'])->name('clientes.descargar.documento')->middleware('auth');

// DIRECCIONES
Route::get('/direcciones', [DireccionesController::class, 'index'])->name('direcciones.index')->middleware('auth');
Route::post('/direcciones/store', [DireccionesController::class, 'store'])->name('direcciones.store')->middleware('auth');
Route::post('/direcciones/update/{id}', [DireccionesController::class, 'update'])->name('direcciones.update')->middleware('auth');
Route::post('/direcciones/inactivate/{id}', [DireccionesController::class, 'inactivate'])->name('direcciones.inactivate')->middleware('auth');
Route::post('/direcciones/activate/{id}', [DireccionesController::class, 'activate'])->name('direcciones.activate')->middleware('auth');
Route::post('/direcciones/delete/{id}', [DireccionesController::class, 'delete'])->name('direcciones.delete')->middleware('auth');

// PEDIDOS
Route::get('/pedidos', [ComprasController::class, 'pedidos'])->name('pedidos.index')->middleware('auth');
Route::post('/pedidos/update/{estatus}/{id}', [ComprasController::class, 'update'])->name('pedidos.update')->middleware('auth');
Route::get('/pedidos/downloadPDFOC/{id}', [ComprasController::class, 'downloadPDFOC'])->name('pedidos.downloadPDFOC')->middleware('auth');
Route::get('/ventas', [ComprasController::class, 'ventas'])->name('ventas.index')->middleware('auth');

// SUSCRIPCIONES
Route::get('/suscripciones', [SuscritosController::class, 'index'])->name('suscripciones.index')->middleware('auth');

// CALIFICACIONES
Route::get('/calificaciones', [CalificacionesController::class, 'index'])->middleware('auth')->name('calificaciones.index');
Route::get('/calificar/aprobar/{id}', [CalificacionesController::class, 'aprobar'])->name('calificaciones.aprobar')->middleware('auth');
Route::get('/calificar/pendiente/{id}', [CalificacionesController::class, 'pendiente'])->name('calificaciones.pendiente')->middleware('auth');
Route::get('/calificar/delete/{id}', [CalificacionesController::class, 'delete'])->name('calificaciones.delete')->middleware('auth');
Route::post('/calificar/{id}', [CalificacionesController::class, 'store'])->middleware('auth')->name('calificar');

// EVENTOS
Route::get('/eventos/index', [EventosController::class, 'index'])->name('eventos.index')->middleware('auth');
Route::post('/eventos/store', [EventosController::class, 'store'])->name('eventos.store')->middleware('auth');
Route::get('/eventos/dats/{id}', [EventosController::class, 'dats'])->name('eventos.dats')->middleware('auth');
Route::post('/eventos/update/{id}', [EventosController::class, 'update'])->name('eventos.update')->middleware('auth');
Route::post('/eventos/inactivate/{id}', [EventosController::class, 'inactivate'])->name('eventos.inactivate')->middleware('auth');
Route::post('/eventos/activate/{id}', [EventosController::class, 'activate'])->name('eventos.activate')->middleware('auth');
Route::post('/eventos/delete/{id}', [EventosController::class, 'delete'])->name('eventos.delete')->middleware('auth');
Route::post('/eventos/boletos/store/{id}', [EventosController::class, 'storeBoletos'])->name('eventos.store.boletos')->middleware('auth');
Route::post('/eventos/boletos/delete/{id}', [EventosController::class, 'deleteBoletos'])->name('eventos.delete.boletos')->middleware('auth');
Route::post('/eventos/boletos/update/{id}', [EventosController::class, 'updateBoletos'])->name('eventos.update.boletos')->middleware('auth');

});

