<?php $__env->startSection('contenido'); ?>
<style>
    .color-circle {
        display: inline-block;
        width: 30px;
        height: 30px;
        border-radius: 50%;
        border: 5px solid #ccc;
        cursor: pointer;
        transition: border-color 0.3s; /* Transición suave para el cambio de color del borde */
    }
    /* Estilo para el borde dorado cuando el radio button está seleccionado */
    .custom-control-input:checked ~ .color-circle {
        border-color: gold;
    }
</style>
<!-- Navbar Start -->
    <div class="container-fluid">
        <div class="row border-top px-xl-5">
            <div class="col-lg-3 d-none d-lg-block">
                <a class="btn shadow-none d-flex align-items-center justify-content-between color-principal text-white w-100" data-toggle="collapse" href="#navbar-vertical" style="height: 65px; margin-top: -1px; padding: 0 30px;  background-color: #ffffff;" >
                    <h6 class="m-0">Categorías</h6>
                    <i class="fa fa-angle-down text-dark"></i>
                </a>
                <nav class="collapse position-absolute navbar navbar-vertical navbar-light align-items-start p-0 border border-top-0 border-bottom-0 bg-light" id="navbar-vertical" style="width: calc(100% - 30px); z-index: 1;">
                    <div class="navbar-nav w-100 overflow-hidden" style="height: 410px">
                        <div class="nav-item dropdown">
                            <a href="#" class="nav-link" data-toggle="dropdown">Subcategoría <i class="fa fa-angle-down float-right mt-1"></i></a>
                            <div class="dropdown-menu position-absolute bg-secondary border-0 rounded-0 w-100 m-0">
                                <?php $__currentLoopData = $subcategorias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subcategoria): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <form action="<?php echo e(route('filtro')); ?>" method="POST" id="form-<?php echo e($subcategoria->codigo_prsu); ?>">
                                    <?php echo csrf_field(); ?>
                                    <a href="#" class="dropdown-item" onclick="document.getElementById('form-<?php echo e($subcategoria->codigo_prsu); ?>').submit(); return false;">
                                    <?php echo e($subcategoria->nombre_prsu); ?></a>
                                    <input type="hidden" name="subcategoria[]" value="<?php echo e($subcategoria->codigo_prsu); ?>">
                                </form>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                        <?php $__currentLoopData = $categorias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categoria): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <form action="<?php echo e(route('filtro')); ?>" method="POST" id="form-<?php echo e($categoria->codigo_prca); ?>">
                            <?php echo csrf_field(); ?>
                            <a href="#" class="nav-item nav-link" onclick="document.getElementById('form-<?php echo e($categoria->codigo_prca); ?>').submit(); return false;">
                            <?php echo e($categoria->nombre_prca); ?></a>
                            <input type="hidden" name="categoria[]" value="<?php echo e($categoria->codigo_prca); ?>">
                        </form>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </nav>
            </div>
            <div class="col-lg-9">
                <nav class="navbar navbar-expand-lg bg-light navbar-light py-3 py-lg-0 px-0">
                    <a href="" class="text-decoration-none d-block d-lg-none">
                        <h1 class="m-0 display-5 font-weight-semi-bold"><span class="color-principal-color font-weight-bold border px-3 mr-1">K</span>Shopper</h1>
                    </a>
                    <button type="button" class="navbar-toggler" data-toggle="collapse" data-target="#navbarCollapse">
                        <span class="navbar-toggler-icon"></span>
                    </button>
                    <div class="collapse navbar-collapse justify-content-between" id="navbarCollapse">
                        <div class="navbar-nav mr-auto py-0">
                            <a href="<?php echo e(route('index')); ?>" class="nav-item nav-link active">Inicio</a>
                            <a href="<?php echo e(route('catalogo')); ?>" class="nav-item nav-link">Tienda</a>
                            <a href="<?php echo e(route('carrito')); ?>" class="nav-item nav-link">Carrito</a>
                            <a href="<?php echo e(route('contacto')); ?>" class="nav-item nav-link">Contacto</a>
                        </div>
                        <div class="navbar-nav ml-auto py-0">
                            <?php if(Auth::check()): ?>
                            <a href="<?php echo e(route('home')); ?>" class="nav-item nav-link">Panel de control</a>
                            <?php else: ?>
                            <a href="<?php echo e(route('login')); ?>" class="nav-item nav-link">Acceso</a>
                            <a href="<?php echo e(route('register')); ?>" class="nav-item nav-link">Registro</a>
                            <?php endif; ?>
                        </div>
                    </div>
                </nav>
            </div>
        </div>
    </div>
    <!--HEADER INICIO -->
    <div class="container-fluid">
        <div class="d-flex flex-column align-items-center justify-content-center" style="min-height: 50px">
            <h1 class="font-weight-semi-bold text-uppercase">Favoritos</h1>
            <div class="d-inline-flex">
                <p class="m-0"><a href="<?php echo e(route('index')); ?>" class="color-principal-color">Inicio</a></p>
                <p class="m-0 px-2">-</p>
                <p class="m-0">Catálogo</p>
            </div>
        </div>
    </div>
    <!--HEADER FIN -->
    <!-- CONTENIDO INICIO-->
    <div class="container-fluid pt-5">
        <div class="row px-xl-5">
            <div class="col-lg-12 table-responsive mb-5">
                <table class="table table-bordered text-center mb-0">
                    <thead class="bg-secondary text-dark">
                        <tr>
                            <th></th>
                            <th>SKU</th>
                            <th>Nombre</th>
                            <th>Categoría</th>
                            <th>Subcategoría</th>
                            <th>Accion</th>
                        </tr>
                    </thead>
                    <tbody class="align-middle">
                        <?php if($totalFavoritos >= 1): ?>
                        <?php $__currentLoopData = $favoritos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td class="align-middle"><a href="<?php echo e(route('detalle.producto', $item['product'])); ?>"><img src="<?php echo e(asset('assets/img/productos/' .   $item['imagen'])); ?>" alt="" style="width: 50px;"></a></td>
                            <td class="align-middle"><?php echo e($item['sku']); ?></td>
                            <td class="align-middle"><?php echo e($item['nombre']); ?></td>
                            <td class="align-middle"><?php echo e($item['categoria']); ?></td>
                            <td class="align-middle"><?php echo e($item['subcategoria']); ?></td>

                            <td class="align-middle">
                                <a href="<?php echo e(route('eliminar.favoritos', $item['token'])); ?>" class="btn btn-sm color-principal" style="color: #ffffff"><i class="fa fa-times"></i></a>
                                <a href="<?php echo e(route('detalle.producto', $item['product'])); ?>" class="btn btn-sm color-principal" style="color: #ffffff"><i class="fas fa-eye"></i></a>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <!-- CONTENIDO FIN -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('tienda/layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\keninails\resources\views/tienda/favoritos.blade.php ENDPATH**/ ?>